/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;

public class ObjectObjectIdentityHashMap<KType, VType>
extends ObjectObjectHashMap<KType, VType> {
    public ObjectObjectIdentityHashMap() {
        this(4);
    }

    public ObjectObjectIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectObjectIdentityHashMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor);
    }

    public ObjectObjectIdentityHashMap(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key2) {
        assert (key2 != null);
        return BitMixer.mixPhi(System.identityHashCode(key2));
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    @Override
    protected boolean equalElements(ObjectObjectHashMap<?, ?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ObjectObjectCursor<?, ?> objectObjectCursor : other) {
            Object key2 = objectObjectCursor.key;
            if (this.containsKey(key2) && this.equals(objectObjectCursor.value, this.get(key2))) continue;
            return false;
        }
        return true;
    }

    public static <KType, VType> ObjectObjectIdentityHashMap<KType, VType> from(KType[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectObjectIdentityHashMap<KType, VType> map = new ObjectObjectIdentityHashMap<KType, VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

