/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectFloatAssociativeContainer;
import com.carrotsearch.hppc.ObjectFloatMap;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.WormUtil;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.ObjectFloatPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.ObjectFloatProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class ObjectFloatWormMap<KType>
implements ObjectFloatMap<KType>,
Preallocable,
Cloneable,
Accountable {
    public Object[] keys;
    public float[] values;
    public byte[] next;
    protected int size;
    protected int iterationSeed;

    public ObjectFloatWormMap() {
        this(4);
    }

    public ObjectFloatWormMap(int expectedElements) {
        if (expectedElements < 0) {
            throw new IllegalArgumentException("Invalid expectedElements=" + expectedElements);
        }
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public ObjectFloatWormMap(ObjectFloatAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    public static <KType> ObjectFloatWormMap<KType> from(KType[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectFloatWormMap<KType> map = new ObjectFloatWormMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public ObjectFloatWormMap<KType> clone() {
        try {
            ObjectFloatWormMap cloneMap = (ObjectFloatWormMap)super.clone();
            cloneMap.keys = (Object[])this.keys.clone();
            cloneMap.values = (float[])this.values.clone();
            cloneMap.next = (byte[])this.next.clone();
            cloneMap.iterationSeed = HashContainers.nextIterationSeed();
            return cloneMap;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public float noValue() {
        return 0.0f;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public float get(KType key2) {
        int hashIndex = this.hashMod(key2);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int entryIndex = this.searchInChain(key2, hashIndex, nextOffset);
        return entryIndex < 0 ? this.noValue() : this.values[entryIndex];
    }

    @Override
    public float getOrDefault(KType key2, float defaultValue) {
        float value = this.get(key2);
        return value == this.noValue() ? defaultValue : value;
    }

    @Override
    public float put(KType key2, float value) {
        return this.put(key2, value, WormUtil.PutPolicy.NEW_OR_REPLACE, true);
    }

    @Override
    public int putAll(ObjectFloatAssociativeContainer<? extends KType> container) {
        int initialSize = this.size();
        for (ObjectFloatCursor<KType> objectFloatCursor : container) {
            this.put(objectFloatCursor.key, objectFloatCursor.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public int putAll(Iterable<? extends ObjectFloatCursor<? extends KType>> iterable) {
        int initialSize = this.size();
        for (ObjectFloatCursor<KType> objectFloatCursor : iterable) {
            this.put(objectFloatCursor.key, objectFloatCursor.value);
        }
        return this.size() - initialSize;
    }

    @Override
    public float putOrAdd(KType key2, float putValue, float incrementValue) {
        int keyIndex = this.indexOf(key2);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key2, putValue);
        }
        return putValue;
    }

    @Override
    public float addTo(KType key2, float additionValue) {
        return this.putOrAdd(key2, additionValue, additionValue);
    }

    @Override
    public boolean putIfAbsent(KType key2, float value) {
        return this.noValue() == this.put(key2, value, WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT, true);
    }

    @Override
    public float remove(KType key2) {
        byte[] next = this.next;
        int hashIndex = this.hashMod(key2);
        byte nextOffset = next[hashIndex];
        if (nextOffset <= 0) {
            return this.noValue();
        }
        int previousEntryIndex = this.searchInChainReturnPrevious(key2, hashIndex, nextOffset);
        if (previousEntryIndex < 0) {
            return this.noValue();
        }
        int entryToRemoveIndex = previousEntryIndex == Integer.MAX_VALUE ? hashIndex : WormUtil.addOffset(previousEntryIndex, Math.abs(next[previousEntryIndex]), next.length);
        return this.remove(entryToRemoveIndex, previousEntryIndex);
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int size = this.size();
        if (other.size() >= size && other instanceof ObjectLookupContainer) {
            Object[] keys = this.keys;
            byte[] byArray = this.next;
            int capacity = byArray.length;
            int entryIndex = 0;
            while (entryIndex < capacity) {
                Object key2;
                if (byArray[entryIndex] != 0 && other.contains(key2 = keys[entryIndex])) {
                    this.remove(key2);
                    continue;
                }
                ++entryIndex;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return size - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        Object[] keys = this.keys;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            Object key2;
            if (next[entryIndex] != 0 && predicate.apply(key2 = keys[entryIndex])) {
                this.remove(key2);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public int removeAll(ObjectFloatPredicate<? super KType> predicate) {
        Object[] keys = this.keys;
        float[] values = this.values;
        byte[] next = this.next;
        int capacity = next.length;
        int size = this.size();
        int entryIndex = 0;
        while (entryIndex < capacity) {
            Object key2;
            if (next[entryIndex] != 0 && predicate.apply(key2 = keys[entryIndex], values[entryIndex])) {
                this.remove(key2);
                continue;
            }
            ++entryIndex;
        }
        return size - this.size();
    }

    @Override
    public <T extends ObjectFloatProcedure<? super KType>> T forEach(T procedure) {
        Object[] keys = this.keys;
        float[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (next[slot] != 0) {
                procedure.apply((Object)keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends ObjectFloatPredicate<? super KType>> T forEach(T predicate) {
        Object[] keys = this.keys;
        float[] values = this.values;
        byte[] next = this.next;
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = next.length - 1;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (next[slot] == 0 || predicate.apply((Object)keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    @Override
    public Iterator<ObjectFloatCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key2) {
        int hashIndex = this.hashMod(key2);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return false;
        }
        return this.searchInChain(key2, hashIndex, nextOffset) >= 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.next, (byte)0);
        this.size = 0;
        Arrays.fill(this.keys, null);
    }

    @Override
    public void release() {
        this.keys = null;
        this.values = null;
        this.next = null;
        this.size = 0;
        this.ensureCapacity(4);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        int size = this.size;
        ObjectFloatMap map = (ObjectFloatMap)o;
        if (size != map.size()) {
            return false;
        }
        Object[] keys = this.keys;
        float[] values = this.values;
        byte[] next = this.next;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (next[index] != 0) {
                if (Float.floatToIntBits(values[index]) != Float.floatToIntBits(map.get(keys[index]))) {
                    return false;
                }
                ++entryCount;
            }
            ++index;
        }
        return true;
    }

    protected boolean equals(Object v1, Object v2) {
        return Objects.equals(v1, v2);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int size = this.size;
        int index = 0;
        int entryCount = 0;
        while (entryCount < size) {
            if (this.next[index] != 0) {
                hashCode += BitMixer.mixPhi(this.keys[index]) ^ BitMixer.mixPhi(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        return hashCode;
    }

    protected int hashKey(KType key2) {
        return BitMixer.mixPhi(key2);
    }

    private int hashMod(KType key2) {
        return this.hashKey(key2) & this.next.length - 1;
    }

    @Override
    public int indexOf(KType key2) {
        int hashIndex = this.hashMod(key2);
        byte nextOffset = this.next[hashIndex];
        if (nextOffset <= 0) {
            return ~hashIndex;
        }
        return this.searchInChain(key2, hashIndex, nextOffset);
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < this.next.length);
        return index >= 0;
    }

    @Override
    public float indexGet(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        return this.values[index];
    }

    @Override
    public float indexReplace(int index, float newValue) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        float previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, KType key2, float value) {
        assert (index < 0) : "The index must not point at an existing key.";
        if (this.next[index ^= 0xFFFFFFFF] == 0) {
            this.keys[index] = key2;
            this.values[index] = value;
            this.next[index] = 127;
            ++this.size;
        } else {
            this.put(key2, value, WormUtil.PutPolicy.NEW_GUARANTEED, true);
        }
    }

    @Override
    public float indexRemove(int index) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (this.next[index] != 0);
        return this.remove(index, Integer.MAX_VALUE);
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append('[');
        int index = 0;
        int entryCount = 0;
        while (entryCount < this.size) {
            if (this.next[index] != 0) {
                if (entryCount > 0) {
                    sBuilder.append(", ");
                }
                sBuilder.append(this.keys[index]);
                sBuilder.append("=>");
                sBuilder.append(this.values[index]);
                ++entryCount;
            }
            ++index;
        }
        sBuilder.append(']');
        return sBuilder.toString();
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.allocateBuffers((int)((float)expectedElements / 0.75f));
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.next.length - 1, characters);
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values) + RamUsageEstimator.shallowSizeOfArray(this.next);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.next, this.size());
    }

    protected void allocateBuffers(int capacity) {
        capacity = Math.max(capacity, this.size);
        if ((capacity = Math.max(BitUtil.nextHighestPowerOfTwo(capacity), 4)) > 0x40000000) {
            throw new BufferAllocationException("Maximum array size exceeded (capacity: %d)", capacity);
        }
        if (this.keys != null && this.keys.length == capacity) {
            return;
        }
        Object[] oldKeys = this.keys;
        float[] oldValues = this.values;
        byte[] oldNext = this.next;
        this.keys = new Object[capacity];
        this.values = new float[capacity];
        this.next = new byte[capacity];
        if (oldKeys != null) {
            this.putOldEntries(oldKeys, oldValues, oldNext, this.size);
        }
    }

    private void putOldEntries(KType[] oldKeys, float[] oldValues, byte[] oldNext, int entryNum) {
        int entryCount = 0;
        int endIndex = oldNext.length;
        for (int index = 0; entryCount < entryNum && index < endIndex; ++index) {
            if (oldNext[index] == 0) continue;
            KType oldKey = oldKeys[index];
            int hashIndex = this.hashMod(oldKey);
            this.putNewEntry(hashIndex, this.next[hashIndex], oldKey, oldValues[index]);
            ++entryCount;
        }
    }

    private float put(KType key2, float value, WormUtil.PutPolicy policy, boolean sizeIncrease) {
        int hashIndex = this.hashMod(key2);
        byte nextOffset = this.next[hashIndex];
        boolean added = false;
        if (nextOffset > 0 && policy != WormUtil.PutPolicy.NEW_GUARANTEED) {
            int entryIndex = this.searchInChain(key2, hashIndex, nextOffset);
            if (entryIndex >= 0) {
                float previousValue = this.values[entryIndex];
                if (policy != WormUtil.PutPolicy.NEW_ONLY_IF_ABSENT) {
                    this.values[entryIndex] = value;
                }
                return previousValue;
            }
            if (this.enlargeIfNeeded()) {
                hashIndex = this.hashMod(key2);
                nextOffset = this.next[hashIndex];
            } else {
                if (!this.appendTailOfChain(~entryIndex, key2, value)) {
                    this.enlargeAndPutNewEntry(key2, value);
                }
                added = true;
            }
        } else if (this.enlargeIfNeeded()) {
            hashIndex = this.hashMod(key2);
            nextOffset = this.next[hashIndex];
        }
        if (!added) {
            this.putNewEntry(hashIndex, nextOffset, key2, value);
        }
        if (sizeIncrease) {
            ++this.size;
        }
        return this.noValue();
    }

    private boolean enlargeIfNeeded() {
        if (this.size >= this.next.length) {
            this.allocateBuffers(this.next.length << 1);
            return true;
        }
        return false;
    }

    private void enlargeAndPutNewEntry(KType key2, float value) {
        this.allocateBuffers(this.next.length << 1);
        this.put(key2, value, WormUtil.PutPolicy.NEW_GUARANTEED, false);
    }

    private float remove(int entryToRemoveIndex, int previousEntryIndex) {
        int lastIndex;
        assert (WormUtil.checkIndex(entryToRemoveIndex, this.next.length));
        assert (previousEntryIndex == Integer.MAX_VALUE || WormUtil.checkIndex(previousEntryIndex, this.next.length));
        byte[] next = this.next;
        float previousValue = this.values[entryToRemoveIndex];
        byte nextOffset = next[entryToRemoveIndex];
        int beforeLastIndex = WormUtil.findLastOfChain(entryToRemoveIndex, nextOffset, true, next);
        if (beforeLastIndex == -1) {
            lastIndex = entryToRemoveIndex;
            if (nextOffset < 0) {
                beforeLastIndex = previousEntryIndex == Integer.MAX_VALUE ? WormUtil.findPreviousInChain(entryToRemoveIndex, next) : previousEntryIndex;
                next[beforeLastIndex] = (byte)(next[beforeLastIndex] > 0 ? 127 : -127);
            }
        } else {
            byte beforeLastNextOffset = next[beforeLastIndex];
            lastIndex = WormUtil.addOffset(beforeLastIndex, Math.abs(beforeLastNextOffset), next.length);
            assert (entryToRemoveIndex != lastIndex);
            this.keys[entryToRemoveIndex] = this.keys[lastIndex];
            this.values[entryToRemoveIndex] = this.values[lastIndex];
            next[beforeLastIndex] = (byte)(beforeLastNextOffset > 0 ? 127 : -127);
        }
        this.keys[lastIndex] = null;
        this.values[lastIndex] = this.noValue();
        next[lastIndex] = 0;
        --this.size;
        return previousValue;
    }

    private boolean appendTailOfChain(int lastEntryIndex, KType key2, float value) {
        return this.appendTailOfChain(lastEntryIndex, key2, value, WormUtil.ExcludedIndexes.NONE, 0);
    }

    private boolean appendTailOfChain(int lastEntryIndex, KType key2, float value, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        int capacity = this.next.length;
        int searchFromIndex = WormUtil.addOffset(lastEntryIndex, 1, capacity);
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, WormUtil.maxOffset(capacity), -1, this.next);
        if (freeIndex == -1 && (freeIndex = this.searchAndMoveBucket(searchFromIndex, WormUtil.maxOffset(capacity), excludedIndexes, recursiveCallLevel)) == -1) {
            return false;
        }
        this.keys[freeIndex] = key2;
        this.values[freeIndex] = value;
        this.next[freeIndex] = -127;
        int nextOffset = WormUtil.getOffsetBetweenIndexes(lastEntryIndex, freeIndex, this.next.length);
        this.next[lastEntryIndex] = (byte)(this.next[lastEntryIndex] > 0 ? nextOffset : -nextOffset);
        return true;
    }

    private int searchAndMoveBucket(int fromIndex, int range, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        assert (WormUtil.checkIndex(fromIndex, this.next.length));
        assert (range >= 0 && range <= WormUtil.maxOffset(this.next.length)) : "range=" + range + ", maxOffset=" + WormUtil.maxOffset(this.next.length);
        int remainingAttempts = WormUtil.RECURSIVE_MOVE_ATTEMPTS[recursiveCallLevel];
        if (remainingAttempts <= 0 || range <= 0) {
            return -1;
        }
        byte[] next = this.next;
        int capacity = next.length;
        int nextRecursiveCallLevel = recursiveCallLevel + 1;
        for (int index = fromIndex + range - 1; index >= fromIndex; --index) {
            byte nextOffset;
            int rolledIndex = index & capacity - 1;
            if (excludedIndexes.isIndexExcluded(rolledIndex) || (nextOffset = next[rolledIndex]) >= 0) continue;
            if (this.moveTailOfChain(rolledIndex, nextOffset, excludedIndexes, nextRecursiveCallLevel)) {
                return rolledIndex;
            }
            if (--remainingAttempts > 0) continue;
            return -1;
        }
        return -1;
    }

    private void putNewEntry(int hashIndex, int nextOffset, KType key2, float value) {
        assert (hashIndex == this.hashMod(key2)) : "hashIndex=" + hashIndex + ", hashReduce(key)=" + this.hashMod(key2);
        assert (WormUtil.checkIndex(hashIndex, this.next.length));
        assert (Math.abs(nextOffset) <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[hashIndex]) : "nextOffset=" + nextOffset + ", next[hashIndex]=" + this.next[hashIndex];
        if (nextOffset > 0) {
            if (!this.appendTailOfChain(WormUtil.findLastOfChain(hashIndex, nextOffset, false, this.next), key2, value)) {
                this.enlargeAndPutNewEntry(key2, value);
            }
        } else {
            if (nextOffset < 0 && !this.moveTailOfChain(hashIndex, nextOffset, WormUtil.ExcludedIndexes.NONE, 0)) {
                this.enlargeAndPutNewEntry(key2, value);
                return;
            }
            this.keys[hashIndex] = key2;
            this.values[hashIndex] = value;
            this.next[hashIndex] = 127;
        }
    }

    private boolean moveTailOfChain(int tailIndex, int nextOffset, WormUtil.ExcludedIndexes excludedIndexes, int recursiveCallLevel) {
        boolean nextIndexWithinRange;
        int searchRange;
        int searchFromIndex;
        assert (WormUtil.checkIndex(tailIndex, this.next.length));
        assert (nextOffset < 0 && nextOffset >= -127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[tailIndex]) : "nextOffset=" + nextOffset + ", next[tailIndex]=" + this.next[tailIndex];
        byte[] next = this.next;
        int capacity = next.length;
        int maxOffset = WormUtil.maxOffset(capacity);
        int previousIndex = WormUtil.findPreviousInChain(tailIndex, next);
        int absPreviousOffset = Math.abs(next[previousIndex]);
        int nextIndex = nextOffset == -127 ? -1 : WormUtil.addOffset(tailIndex, -nextOffset, capacity);
        int offsetFromPreviousToNext = absPreviousOffset - nextOffset;
        if (offsetFromPreviousToNext <= maxOffset) {
            searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
            searchRange = offsetFromPreviousToNext - 1;
            nextIndexWithinRange = true;
        } else {
            if (nextIndex == -1) {
                searchFromIndex = WormUtil.addOffset(previousIndex, 1, capacity);
                searchRange = maxOffset;
            } else {
                searchFromIndex = WormUtil.addOffset(nextIndex, -maxOffset, capacity);
                int searchToIndex = WormUtil.addOffset(previousIndex, maxOffset, capacity);
                searchRange = WormUtil.getOffsetBetweenIndexes(searchFromIndex, searchToIndex, capacity) + 1;
            }
            nextIndexWithinRange = false;
        }
        int freeIndex = WormUtil.searchFreeBucket(searchFromIndex, searchRange, tailIndex, next);
        if (freeIndex == -1) {
            if (nextIndexWithinRange && this.appendTailOfChain(WormUtil.findLastOfChain(nextIndex, next[nextIndex], false, next), this.keys[tailIndex], this.values[tailIndex], excludedIndexes, recursiveCallLevel)) {
                int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, nextIndex, capacity);
                next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
                return true;
            }
            WormUtil.ExcludedIndexes recursiveExcludedIndexes = excludedIndexes.union(WormUtil.ExcludedIndexes.fromChain(previousIndex, next));
            freeIndex = this.searchAndMoveBucket(searchFromIndex, searchRange, recursiveExcludedIndexes, recursiveCallLevel);
            if (freeIndex == -1) {
                return false;
            }
        }
        this.keys[freeIndex] = this.keys[tailIndex];
        this.values[freeIndex] = this.values[tailIndex];
        next[freeIndex] = (byte)(nextOffset == -127 ? nextOffset : -WormUtil.getOffsetBetweenIndexes(freeIndex, nextIndex, capacity));
        int previousOffset = WormUtil.getOffsetBetweenIndexes(previousIndex, freeIndex, capacity);
        next[previousIndex] = (byte)(next[previousIndex] > 0 ? previousOffset : -previousOffset);
        assert (next[freeIndex] < 0) : "freeIndex=" + freeIndex + ", next[freeIndex]=" + next[freeIndex];
        return true;
    }

    private int searchInChain(KType key2, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (Objects.equals(this.keys[index], key2)) {
            return index;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            if (Objects.equals(this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)], key2)) {
                return index;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    private int searchInChainReturnPrevious(KType key2, int index, int nextOffset) {
        assert (WormUtil.checkIndex(index, this.next.length));
        assert (nextOffset > 0 && nextOffset <= 127) : "nextOffset=" + nextOffset;
        assert (nextOffset == this.next[index]) : "nextOffset=" + nextOffset + ", next[index]=" + this.next[index];
        if (Objects.equals(this.keys[index], key2)) {
            return Integer.MAX_VALUE;
        }
        int capacity = this.next.length;
        while (nextOffset != 127) {
            int previousIndex = index;
            if (Objects.equals(this.keys[index = WormUtil.addOffset(index, nextOffset, capacity)], key2)) {
                return previousIndex;
            }
            nextOffset = -this.next[index];
            assert (nextOffset > 0) : "nextOffset=" + nextOffset;
        }
        return ~index;
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        @Override
        public boolean contains(KType e) {
            return ObjectFloatWormMap.this.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            ObjectFloatWormMap.this.forEach((key2, value) -> procedure.apply(key2));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            ObjectFloatWormMap.this.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return ObjectFloatWormMap.this.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return ObjectFloatWormMap.this.size();
        }

        @Override
        public void clear() {
            ObjectFloatWormMap.this.clear();
        }

        @Override
        public void release() {
            ObjectFloatWormMap.this.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return ObjectFloatWormMap.this.removeAll(predicate);
        }

        @Override
        public int removeAll(KType e) {
            return ObjectFloatWormMap.this.remove(e) == ObjectFloatWormMap.this.noValue() ? 0 : 1;
        }
    }

    private class ValuesContainer
    extends AbstractFloatCollection {
        private ValuesContainer() {
        }

        @Override
        public int size() {
            return ObjectFloatWormMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ObjectFloatWormMap.this.isEmpty();
        }

        @Override
        public boolean contains(float value) {
            for (ObjectFloatCursor c : ObjectFloatWormMap.this) {
                if (Float.floatToIntBits(value) != Float.floatToIntBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            for (ObjectFloatCursor c : ObjectFloatWormMap.this) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            for (ObjectFloatCursor c : ObjectFloatWormMap.this) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(float e) {
            return ObjectFloatWormMap.this.removeAll((? super KType key2, float value) -> Float.floatToIntBits(e) == Float.floatToIntBits(value));
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            return ObjectFloatWormMap.this.removeAll((? super KType key2, float value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            ObjectFloatWormMap.this.clear();
        }

        @Override
        public void release() {
            ObjectFloatWormMap.this.release();
        }
    }

    private class EntryIterator
    extends AbstractIterator<ObjectFloatCursor<KType>> {
        private final ObjectFloatCursor<KType> cursor = new ObjectFloatCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = ObjectFloatWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ObjectFloatWormMap.this.next.length - 1;
        }

        @Override
        protected ObjectFloatCursor<KType> fetch() {
            int mask = ObjectFloatWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ObjectFloatWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = ObjectFloatWormMap.this.keys[this.slot];
                this.cursor.value = ObjectFloatWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (ObjectFloatCursor)this.done();
        }
    }

    private class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = ObjectFloatWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ObjectFloatWormMap.this.next.length - 1;
        }

        @Override
        protected FloatCursor fetch() {
            int mask = ObjectFloatWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ObjectFloatWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ObjectFloatWormMap.this.values[this.slot];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = ObjectFloatWormMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ObjectFloatWormMap.this.next.length - 1;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int mask = ObjectFloatWormMap.this.next.length - 1;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ObjectFloatWormMap.this.next[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ObjectFloatWormMap.this.keys[this.slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

