/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.Accountable;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ByteCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectByteAssociativeContainer;
import com.carrotsearch.hppc.ObjectByteMap;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.RamUsageEstimator;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.ObjectByteCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.ObjectBytePredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.ObjectByteProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectByteHashMap<KType>
implements ObjectByteMap<KType>,
Preallocable,
Cloneable,
Accountable {
    public Object[] keys;
    public byte[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public ObjectByteHashMap() {
        this(4);
    }

    public ObjectByteHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectByteHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.nextIterationSeed();
        this.ensureCapacity(expectedElements);
    }

    public ObjectByteHashMap(ObjectByteAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public byte put(KType key2, byte value) {
        Object existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key2 == null) {
            this.hasEmptyKey = true;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(key2, existing)) {
                byte previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key2, value);
        } else {
            keys[slot] = key2;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ObjectByteAssociativeContainer<? extends KType> container) {
        int count = this.size();
        for (ObjectByteCursor<KType> objectByteCursor : container) {
            this.put(objectByteCursor.key, objectByteCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends ObjectByteCursor<? extends KType>> iterable) {
        int count = this.size();
        for (ObjectByteCursor<KType> objectByteCursor : iterable) {
            this.put(objectByteCursor.key, objectByteCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public byte putOrAdd(KType key2, byte putValue, byte incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key2);
        if (this.indexExists(keyIndex)) {
            putValue = (byte)(this.values[keyIndex] + incrementValue);
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key2, putValue);
        }
        return putValue;
    }

    @Override
    public byte addTo(KType key2, byte incrementValue) {
        return this.putOrAdd(key2, incrementValue, incrementValue);
    }

    @Override
    public byte remove(KType key2) {
        Object existing;
        int mask = this.mask;
        if (key2 == null) {
            this.hasEmptyKey = false;
            byte previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(key2, existing)) {
                byte previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int before2 = this.size();
        if (other.size() >= this.size() && other instanceof ObjectLookupContainer) {
            void var4_6;
            if (this.hasEmptyKey && other.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            Object[] keys = this.keys;
            boolean bl = false;
            int max = this.mask;
            while (var4_6 <= max) {
                Object existing = keys[var4_6];
                if (existing != null && other.contains(existing)) {
                    this.shiftConflictingKeys((int)var4_6);
                    continue;
                }
                ++var4_6;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return before2 - this.size();
    }

    @Override
    public int removeAll(ObjectBytePredicate<? super KType> predicate) {
        int before2 = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(null, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        Object[] keys = this.keys;
        byte[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            Object existing = keys[slot];
            if (existing != null && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before2 - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before2 = this.size();
        if (this.hasEmptyKey && predicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        Object[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            Object existing = keys[slot];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before2 - this.size();
    }

    @Override
    public byte get(KType key2) {
        Object existing;
        if (key2 == null) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (byte)0;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(key2, existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public byte getOrDefault(KType key2, byte defaultValue) {
        Object existing;
        if (key2 == null) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(key2, existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(KType key2) {
        Object existing;
        if (key2 == null) {
            return this.hasEmptyKey;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(key2, existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(KType key2) {
        Object existing;
        int mask = this.mask;
        if (key2 == null) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key2) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(key2, existing)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public byte indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        byte previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, KType key2, byte value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key2 == null) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == null);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key2, value);
            } else {
                this.keys[index] = key2;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public byte indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        byte previousValue = this.values[index];
        if (index > this.mask) {
            this.hasEmptyKey = false;
            this.values[index] = 0;
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectByteCursor<KType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((ObjectByteHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(ObjectByteHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ObjectByteCursor<?> c : other) {
            Object key2 = c.key;
            if (this.containsKey(key2) && c.value == this.get(key2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            Object[] prevKeys = this.keys;
            byte[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public long ramBytesAllocated() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowSizeOfArray(this.keys) + RamUsageEstimator.shallowSizeOfArray(this.values);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 16 + 8 + 1) + RamUsageEstimator.shallowUsedSizeOfArray(this.keys, this.size()) + RamUsageEstimator.shallowUsedSizeOfArray(this.values, this.size());
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<ObjectByteCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectByteProcedure<? super KType>> T forEach(T procedure) {
        Object[] keys = this.keys;
        byte[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(null, values[this.mask + 1]);
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask; ++i) {
            if (keys[slot] != null) {
                procedure.apply((Object)keys[slot], values[slot]);
            }
            slot = slot + inc & mask;
        }
        return procedure;
    }

    @Override
    public <T extends ObjectBytePredicate<? super KType>> T forEach(T predicate) {
        Object[] keys = this.keys;
        byte[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(null, values[this.mask + 1])) {
            return predicate;
        }
        int seed = this.nextIterationSeed();
        int inc = HashContainers.iterationIncrement(seed);
        int mask = this.mask;
        int slot = seed & mask;
        for (int i = 0; i <= mask && (keys[slot] == null || predicate.apply((Object)keys[slot], values[slot])); ++i) {
            slot = slot + inc & mask;
        }
        return predicate;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ByteCollection values() {
        return new ValuesContainer();
    }

    public ObjectByteHashMap<KType> clone() {
        try {
            ObjectByteHashMap cloned = (ObjectByteHashMap)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.values = (byte[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.nextIterationSeed();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectByteCursor<KType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static <KType> ObjectByteHashMap<KType> from(KType[] keys, byte[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectByteHashMap<KType> map = new ObjectByteHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(KType key2) {
        assert (key2 != null);
        return BitMixer.mixPhi(key2);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(KType[] fromKeys, byte[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        Object[] keys = this.keys;
        byte[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            KType existing = fromKeys[from];
            if (existing == null) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != null) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        Object[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new Object[arraySize + emptyElementSlot];
            this.values = new byte[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, KType pendingKey, byte pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == null && pendingKey != null);
        Object[] prevKeys = this.keys;
        byte[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        Object existing;
        Object[] keys = this.keys;
        byte[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != null) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = null;
        values[gapSlot] = 0;
        --this.assigned;
    }

    protected boolean equals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectByteCursor<KType>> {
        private final ObjectByteCursor<KType> cursor = new ObjectByteCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = ObjectByteHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ObjectByteHashMap.this.mask;
        }

        @Override
        protected ObjectByteCursor<KType> fetch() {
            int mask = ObjectByteHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                Object existing = ObjectByteHashMap.this.keys[this.slot];
                if (existing == null) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = ObjectByteHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && ObjectByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = null;
                this.cursor.value = ObjectByteHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (ObjectByteCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectByteHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectByteHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(KType e) {
            if (this.owner.containsKey(e)) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final ObjectByteHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (ObjectByteCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            for (ObjectByteCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            for (ObjectByteCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(byte e) {
            return this.owner.removeAll((? super KType key2, byte value) -> e == value);
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            return this.owner.removeAll((? super KType key2, byte value) -> predicate.apply(value));
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = ObjectByteHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ObjectByteHashMap.this.mask;
        }

        @Override
        protected ByteCursor fetch() {
            int mask = ObjectByteHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (ObjectByteHashMap.this.keys[this.slot] == null) continue;
                this.cursor.index = this.slot;
                this.cursor.value = ObjectByteHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && ObjectByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = ObjectByteHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = ObjectByteHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & ObjectByteHashMap.this.mask;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int mask = ObjectByteHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                Object existing = ObjectByteHashMap.this.keys[this.slot];
                if (existing == null) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && ObjectByteHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

