/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.testng;

import com.intellij.rt.testng.IDEATestNGRemoteListener;
import com.intellij.rt.testng.IDEATestNGSuiteListener;
import com.intellij.rt.testng.IDEATestNGTestListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.testng.CommandLineArgs;
import org.testng.TestNG;
import org.testng.collections.Lists;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class IDEARemoteTestNG
extends TestNG {
    private final String myParam;

    public IDEARemoteTestNG(String param) {
        this.myParam = param;
    }

    private static void calculateAllSuites(List<XmlSuite> suites, List<XmlSuite> outSuites) {
        for (XmlSuite s : suites) {
            outSuites.add(s);
            IDEARemoteTestNG.calculateAllSuites(s.getChildSuites(), outSuites);
        }
    }

    public void configure(CommandLineArgs cla) {
        super.configure(cla);
    }

    public void run() {
        try {
            this.initializeSuitesAndJarFile();
            List suites = Lists.newArrayList();
            IDEARemoteTestNG.calculateAllSuites(this.m_suites, suites);
            if (!suites.isEmpty()) {
                for (XmlSuite suite : suites) {
                    List tests = suite.getTests();
                    for (XmlTest test : tests) {
                        try {
                            if (this.myParam == null) continue;
                            for (XmlClass aClass : test.getXmlClasses()) {
                                ArrayList<XmlInclude> includes = new ArrayList<XmlInclude>();
                                for (XmlInclude include : aClass.getIncludedMethods()) {
                                    includes.add(new XmlInclude(include.getName(), Collections.singletonList(Integer.parseInt(this.myParam)), 0));
                                }
                                aClass.setIncludedMethods(includes);
                            }
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Invocation number: expected integer but found: " + this.myParam);
                        }
                    }
                }
                this.attachListeners(new IDEATestNGRemoteListener());
                super.run();
            } else {
                System.out.println("##teamcity[enteredTheMatrix]");
                System.err.println("Nothing found to run");
            }
            System.exit(0);
        }
        catch (Throwable cause) {
            cause.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private void attachListeners(IDEATestNGRemoteListener listener) {
        this.addListener(new IDEATestNGSuiteListener(listener));
        this.addListener(new IDEATestNGTestListener(listener));
        try {
            Class<?> configClass = Class.forName("com.intellij.rt.testng.IDEATestNGConfigurationListener");
            Object configurationListener = configClass.getConstructor(IDEATestNGRemoteListener.class).newInstance(listener);
            this.addListener(configurationListener);
            Class<?> invokeClass = Class.forName("com.intellij.rt.testng.IDEATestNGInvokedMethodListener");
            Object invokedMethodListener = invokeClass.getConstructor(IDEATestNGRemoteListener.class).newInstance(listener);
            this.addListener(invokedMethodListener);
            configClass.getMethod("setIgnoreStarted", new Class[0]).invoke(configurationListener, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

