/*
 * Decompiled with CFR 0.152.
 */
package runtime.x.primitives;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import platform.common.IntPositionPx2d;
import platform.common.IntRectanglePx2d;
import platform.common.IntSizePx2d;
import runtime.x.primitives.PopupAnchorAlignment;
import runtime.x.primitives.PopupPointAlignment;
import runtime.x.primitives.PopupVM;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0005\u00a8\u0006\u0010"}, d2={"calculatePopupRect", "Lplatform/common/IntRectanglePx2d;", "position", "Lplatform/common/IntPositionPx2d;", "alignment", "Lruntime/x/primitives/PopupAnchorAlignment;", "popupSize", "Lplatform/common/IntSizePx2d;", "findBetterPosition", "Lkotlin/Pair;", "Lruntime/x/primitives/PopupVM;", "currentPosition", "popup", "constraints", "toPointPosition", "Lruntime/x/primitives/PopupPointAlignment;", "platform-ui"})
public final class PopupKt {
    @NotNull
    public static final PopupPointAlignment toPointPosition(@NotNull PopupAnchorAlignment $this$toPointPosition) {
        PopupPointAlignment popupPointAlignment;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toPointPosition), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toPointPosition.ordinal()]) {
            case 1: {
                popupPointAlignment = PopupPointAlignment.TOP_RIGHT;
                break;
            }
            case 2: {
                popupPointAlignment = PopupPointAlignment.TOP_CENTER;
                break;
            }
            case 3: {
                popupPointAlignment = PopupPointAlignment.TOP_LEFT;
                break;
            }
            case 4: {
                popupPointAlignment = PopupPointAlignment.BOTTOM_RIGHT;
                break;
            }
            case 5: {
                popupPointAlignment = PopupPointAlignment.BOTTOM_CENTER;
                break;
            }
            case 6: {
                popupPointAlignment = PopupPointAlignment.BOTTOM_LEFT;
                break;
            }
            case 7: {
                popupPointAlignment = PopupPointAlignment.BOTTOM_LEFT;
                break;
            }
            case 8: {
                popupPointAlignment = PopupPointAlignment.LEFT_CENTER;
                break;
            }
            case 9: {
                popupPointAlignment = PopupPointAlignment.TOP_LEFT;
                break;
            }
            case 10: {
                popupPointAlignment = PopupPointAlignment.BOTTOM_RIGHT;
                break;
            }
            case 11: {
                popupPointAlignment = PopupPointAlignment.RIGHT_CENTER;
                break;
            }
            case 12: {
                popupPointAlignment = PopupPointAlignment.TOP_RIGHT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return popupPointAlignment;
    }

    @NotNull
    public static final IntRectanglePx2d calculatePopupRect(@NotNull IntPositionPx2d position, @NotNull PopupAnchorAlignment alignment, @NotNull IntSizePx2d popupSize) {
        IntRectanglePx2d intRectanglePx2d;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        Intrinsics.checkNotNullParameter((Object)popupSize, (String)"popupSize");
        switch (WhenMappings.$EnumSwitchMapping$1[PopupKt.toPointPosition(alignment).ordinal()]) {
            case 1: {
                intRectanglePx2d = new IntRectanglePx2d(new IntPositionPx2d(position.getX() - popupSize.getWidth(), position.getY() - popupSize.getHeight()), popupSize);
                break;
            }
            case 2: {
                intRectanglePx2d = new IntRectanglePx2d(new IntPositionPx2d(position.getX() - popupSize.getWidth() / 2, position.getY() - popupSize.getHeight()), popupSize);
                break;
            }
            case 3: {
                intRectanglePx2d = new IntRectanglePx2d(new IntPositionPx2d(position.getX(), position.getY() - popupSize.getHeight()), popupSize);
                break;
            }
            case 4: {
                intRectanglePx2d = new IntRectanglePx2d(new IntPositionPx2d(position.getX() - popupSize.getWidth(), position.getY()), popupSize);
                break;
            }
            case 5: {
                intRectanglePx2d = new IntRectanglePx2d(new IntPositionPx2d(position.getX() - popupSize.getWidth() / 2, position.getY()), popupSize);
                break;
            }
            case 6: {
                intRectanglePx2d = new IntRectanglePx2d(new IntPositionPx2d(position.getX(), position.getY()), popupSize);
                break;
            }
            case 7: {
                intRectanglePx2d = new IntRectanglePx2d(new IntPositionPx2d(position.getX() - popupSize.getWidth(), position.getY() - popupSize.getHeight() / 2), popupSize);
                break;
            }
            case 8: {
                intRectanglePx2d = new IntRectanglePx2d(new IntPositionPx2d(position.getX(), position.getY() - popupSize.getHeight() / 2), popupSize);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return intRectanglePx2d;
    }

    @NotNull
    public static final Pair<IntPositionPx2d, PopupAnchorAlignment> findBetterPosition(@NotNull PopupVM $this$findBetterPosition, @NotNull IntPositionPx2d currentPosition, @NotNull IntRectanglePx2d popup2, @NotNull IntRectanglePx2d constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$findBetterPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)currentPosition, (String)"currentPosition");
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        PopupAnchorAlignment currentAlignment = $this$findBetterPosition.getAlignment().getValue();
        IntRectanglePx2d anchor = $this$findBetterPosition.getAnchor().getValue();
        int containerLeft = constraints.getPosition().getX();
        int containerTop = constraints.getPosition().getY();
        int containerRight = containerLeft + constraints.getSize().getWidth();
        int containerBottom = containerTop + constraints.getSize().getHeight();
        int popupTop = popup2.getPosition().getY();
        int popupLeft = popup2.getPosition().getX();
        int popupBottom = popup2.getPosition().getY() + popup2.getSize().getHeight();
        int popupRight = popup2.getPosition().getX() + popup2.getSize().getWidth();
        Pair result2 = TuplesKt.to((Object)currentPosition, (Object)((Object)currentAlignment));
        switch (WhenMappings.$EnumSwitchMapping$0[currentAlignment.ordinal()]) {
            case 1: {
                if (popupRight > containerRight && popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.BOTTOM_RIGHT));
                    break;
                }
                if (popupRight > containerRight) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.TOP_RIGHT));
                    break;
                }
                if (popupTop >= containerTop) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.BOTTOM_LEFT));
                break;
            }
            case 2: {
                if (popupLeft < containerLeft && popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - popupLeft, currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.BOTTOM_CENTER));
                    break;
                }
                if (popupRight > containerRight && popupTop < containerLeft) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - (popupRight - containerRight), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.BOTTOM_CENTER));
                    break;
                }
                if (popupLeft < containerLeft) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - popupLeft, currentPosition.getY()), (Object)((Object)currentAlignment));
                    break;
                }
                if (popupRight > containerRight) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - (popupRight - containerRight), currentPosition.getY()), (Object)((Object)currentAlignment));
                    break;
                }
                if (popupTop >= containerTop) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.BOTTOM_CENTER));
                break;
            }
            case 3: {
                if (popupLeft < containerLeft && popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.BOTTOM_LEFT));
                    break;
                }
                if (popupLeft < containerLeft) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.TOP_LEFT));
                    break;
                }
                if (popupTop >= containerTop) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.BOTTOM_RIGHT));
                break;
            }
            case 4: {
                if (popupRight > containerRight && popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.TOP_RIGHT));
                    break;
                }
                if (popupRight > containerRight) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.BOTTOM_RIGHT));
                    break;
                }
                if (popupLeft < containerLeft) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + (containerLeft - popupLeft), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.BOTTOM_LEFT));
                    break;
                }
                if (popupBottom <= containerBottom) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.TOP_LEFT));
                break;
            }
            case 5: {
                if (popupLeft < containerLeft && popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - popupLeft, currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.TOP_CENTER));
                    break;
                }
                if (popupRight > containerRight && popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - (popupRight - containerRight), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.TOP_CENTER));
                    break;
                }
                if (popupLeft < containerLeft) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - popupLeft, currentPosition.getY()), (Object)((Object)currentAlignment));
                    break;
                }
                if (popupRight > containerRight) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - (popupRight - containerRight), currentPosition.getY()), (Object)((Object)currentAlignment));
                    break;
                }
                if (popupBottom <= containerBottom) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.TOP_CENTER));
                break;
            }
            case 6: {
                if (popupLeft < containerLeft && popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.TOP_LEFT));
                    break;
                }
                if (popupRight > containerRight) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - (popupRight - containerRight), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.BOTTOM_RIGHT));
                    break;
                }
                if (popupLeft < containerLeft) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.BOTTOM_LEFT));
                    break;
                }
                if (popupBottom <= containerBottom) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.TOP_RIGHT));
                break;
            }
            case 7: {
                if (popupLeft < containerLeft && popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.RIGHT_BOTTOM));
                    break;
                }
                if (popupLeft < containerLeft) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.RIGHT_TOP));
                    break;
                }
                if (popupBottom <= containerBottom) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.LEFT_BOTTOM));
                break;
            }
            case 8: {
                if (popupLeft < containerLeft && popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY() - popupTop), (Object)((Object)PopupAnchorAlignment.RIGHT_CENTER));
                    break;
                }
                if (popupLeft < containerLeft && popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY() - (popupBottom - containerBottom)), (Object)((Object)PopupAnchorAlignment.RIGHT_CENTER));
                    break;
                }
                if (popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() - (popupBottom - containerBottom)), (Object)((Object)currentAlignment));
                    break;
                }
                if (popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() - popupTop), (Object)((Object)currentAlignment));
                    break;
                }
                if (popupLeft >= containerLeft) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.RIGHT_CENTER));
                break;
            }
            case 9: {
                if (popupLeft < containerLeft && popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.RIGHT_TOP));
                    break;
                }
                if (popupLeft < containerLeft) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() + anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.RIGHT_BOTTOM));
                    break;
                }
                if (popupTop >= containerTop) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.LEFT_TOP));
                break;
            }
            case 10: {
                if (popupRight > containerRight && popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.LEFT_BOTTOM));
                    break;
                }
                if (popupRight > containerRight) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.LEFT_TOP));
                    break;
                }
                if (popupBottom <= containerBottom) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() - anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.RIGHT_BOTTOM));
                break;
            }
            case 11: {
                if (popupRight > containerRight && popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY() - popupTop), (Object)((Object)PopupAnchorAlignment.LEFT_CENTER));
                    break;
                }
                if (popupRight > containerRight && popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY() - (popupBottom - containerBottom)), (Object)((Object)PopupAnchorAlignment.LEFT_CENTER));
                    break;
                }
                if (popupBottom > containerBottom) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() - (popupBottom - containerBottom)), (Object)((Object)currentAlignment));
                    break;
                }
                if (popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() - popupTop), (Object)((Object)currentAlignment));
                    break;
                }
                if (popupRight <= containerRight) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.LEFT_CENTER));
                break;
            }
            case 12: {
                if (popupRight > containerRight && popupTop < containerTop) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.LEFT_TOP));
                    break;
                }
                if (popupRight > containerRight) {
                    result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX() - anchor.getSize().getWidth(), currentPosition.getY()), (Object)((Object)PopupAnchorAlignment.LEFT_BOTTOM));
                    break;
                }
                if (popupTop >= containerTop) break;
                result2 = TuplesKt.to((Object)new IntPositionPx2d(currentPosition.getX(), currentPosition.getY() + anchor.getSize().getHeight()), (Object)((Object)PopupAnchorAlignment.RIGHT_TOP));
            }
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PopupAnchorAlignment.values().length];
            try {
                nArray[PopupAnchorAlignment.TOP_LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.TOP_CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.TOP_RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.BOTTOM_LEFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.BOTTOM_CENTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.BOTTOM_RIGHT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.LEFT_TOP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.LEFT_CENTER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.LEFT_BOTTOM.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.RIGHT_TOP.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.RIGHT_CENTER.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupAnchorAlignment.RIGHT_BOTTOM.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PopupPointAlignment.values().length];
            try {
                nArray[PopupPointAlignment.TOP_LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPointAlignment.TOP_CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPointAlignment.TOP_RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPointAlignment.BOTTOM_LEFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPointAlignment.BOTTOM_CENTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPointAlignment.BOTTOM_RIGHT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPointAlignment.LEFT_CENTER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPointAlignment.RIGHT_CENTER.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

