/*
 * Decompiled with CFR 0.152.
 */
package runtime.x;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;
import runtime.text.TextRange;
import runtime.text.TextRangeKt;
import runtime.x.SelectionVM;
import runtime.x.XTextModel;
import runtime.x.XTextModelImpl;
import runtime.x.primitives.FocusKt;
import runtime.x.primitives.FocusVM;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0010H\u0016J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0013H\u0002J\b\u0010(\u001a\u00020\u0010H\u0016J\b\u0010)\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0003H\u0016J \u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020$2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0010H\u0002J\u0018\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0010H\u0016J\b\u00101\u001a\u00020\"H\u0016J\u0010\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020$H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00064"}, d2={"Lruntime/x/XTextModelImpl;", "Lruntime/x/XTextModel;", "initialText", "", "(Ljava/lang/String;)V", "textState", "Lruntime/reactive/MutableProperty;", "focusVM", "Lruntime/x/primitives/FocusVM;", "(Lruntime/reactive/MutableProperty;Lruntime/x/primitives/FocusVM;)V", "getFocusVM", "()Lruntime/x/primitives/FocusVM;", "setFocusVM", "(Lruntime/x/primitives/FocusVM;)V", "isEmpty", "Lruntime/reactive/Property;", "", "()Lruntime/reactive/Property;", "lastIdx", "", "getLastIdx", "()I", "selectedText", "getSelectedText", "()Ljava/lang/String;", "selectionVM", "Lruntime/x/SelectionVM;", "getSelectionVM", "()Lruntime/x/SelectionVM;", "setSelectionVM", "(Lruntime/x/SelectionVM;)V", "getTextState", "()Lruntime/reactive/MutableProperty;", "clear", "", "getSelectionRange", "Lruntime/text/TextRange;", "isSelectionAtEndOfContent", "isSelectionAtPoint", "value", "isSelectionAtStartOfContent", "moveCaretToEnd", "replaceAll", "result", "replaceRange", "selectionToReplace", "selectAfterReplaced", "replaceSelection", "text", "selectEntireText", "setSelectionRange", "range", "platform-ui"})
public final class XTextModelImpl
implements XTextModel {
    @NotNull
    private final MutableProperty<String> textState;
    @NotNull
    private FocusVM focusVM;
    @NotNull
    private SelectionVM selectionVM;
    @NotNull
    private final Property<Boolean> isEmpty;

    public XTextModelImpl(@NotNull MutableProperty<String> textState, @NotNull FocusVM focusVM) {
        Intrinsics.checkNotNullParameter(textState, (String)"textState");
        Intrinsics.checkNotNullParameter((Object)focusVM, (String)"focusVM");
        this.textState = textState;
        this.focusVM = focusVM;
        this.selectionVM = new SelectionVM();
        this.isEmpty = PropertyKt.toProperty(PropertyKt.map((Property)this.getTextState(), isEmpty.1.INSTANCE), Lifetime.Companion.getEternal(), ((CharSequence)this.getTextState().getValue()).length() == 0);
    }

    public /* synthetic */ XTextModelImpl(MutableProperty mutableProperty2, FocusVM focusVM, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            focusVM = FocusKt.focusVM();
        }
        this(mutableProperty2, focusVM);
    }

    @Override
    @NotNull
    public MutableProperty<String> getTextState() {
        return this.textState;
    }

    @Override
    @NotNull
    public FocusVM getFocusVM() {
        return this.focusVM;
    }

    @Override
    public void setFocusVM(@NotNull FocusVM focusVM) {
        Intrinsics.checkNotNullParameter((Object)focusVM, (String)"<set-?>");
        this.focusVM = focusVM;
    }

    public XTextModelImpl(@NotNull String initialText) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        this(PropertyKt.mutableProperty(initialText), null, 2, null);
    }

    public /* synthetic */ XTextModelImpl(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        this(string2);
    }

    @Override
    @NotNull
    public SelectionVM getSelectionVM() {
        return this.selectionVM;
    }

    @Override
    public void setSelectionVM(@NotNull SelectionVM selectionVM) {
        Intrinsics.checkNotNullParameter((Object)selectionVM, (String)"<set-?>");
        this.selectionVM = selectionVM;
    }

    @Override
    @NotNull
    public String getSelectedText() {
        String string2 = this.getTextState().getValue().substring(((TextRange)this.getSelectionVM().getSelection().getValue()).getStart(), TextRangeKt.getEnd((TextRange)this.getSelectionVM().getSelection().getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    @Override
    @NotNull
    public Property<Boolean> isEmpty() {
        return this.isEmpty;
    }

    private final int getLastIdx() {
        return this.getTextState().getValue().length();
    }

    @Override
    @NotNull
    public TextRange getSelectionRange() {
        return (TextRange)this.getSelectionVM().getSelection().getValue();
    }

    @Override
    public void setSelectionRange(@NotNull TextRange range3) {
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        this.getSelectionVM().setSelection(range3);
    }

    @Override
    public void replaceAll(@NotNull String result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.getTextState().setValue(result2);
    }

    @Override
    public void clear() {
        this.replaceAll("");
    }

    @Override
    public void replaceSelection(@NotNull String text2, boolean selectAfterReplaced) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.replaceRange(this.getSelectionRange(), text2, selectAfterReplaced);
    }

    private final void replaceRange(TextRange selectionToReplace, String result2, boolean selectAfterReplaced) {
        String text2 = this.getTextState().getValue();
        String string2 = text2.substring(0, selectionToReplace.getStart());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String prefix = string2 + result2;
        String string3 = text2.substring(TextRangeKt.getEnd(selectionToReplace));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String newText2 = prefix + string3;
        this.replaceAll(newText2);
        if (selectAfterReplaced) {
            this.getSelectionVM().setSelection(TextRangeKt.rangeBetween(prefix.length(), prefix.length()));
        }
    }

    private final boolean isSelectionAtPoint(int value2) {
        return Intrinsics.areEqual((Object)this.getSelectionRange(), (Object)TextRangeKt.rangeBetween(value2, value2));
    }

    @Override
    public boolean isSelectionAtStartOfContent() {
        return this.isSelectionAtPoint(0);
    }

    @Override
    public boolean isSelectionAtEndOfContent() {
        return this.isSelectionAtPoint(this.getLastIdx());
    }

    @Override
    public void moveCaretToEnd() {
        this.setSelectionRange(TextRangeKt.rangeBetween(this.getLastIdx(), this.getLastIdx()));
    }

    @Override
    public void selectEntireText() {
        this.setSelectionRange(TextRangeKt.rangeBetween(0, this.getLastIdx()));
    }
}

