/*
 * Decompiled with CFR 0.152.
 */
package runtime.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.text.ReplacementBuilder;
import runtime.text.StringTemplateKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a{\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00030\u00072\u0006\u0010\b\u001a\u0002H\u00022\u001d\u0010\t\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0002\b\u000b2\u001d\u0010\f\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0002\b\u000bH\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0084\u0001\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u001d\u0010\u000e\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u0010\u0012\u0004\u0012\u00020\u00010\u000f\u00a2\u0006\u0002\b\u000b2\u0006\u0010\b\u001a\u0002H\u00022\u001d\u0010\t\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0002\b\u000b2\u001d\u0010\f\u001a\u0019\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\u0011\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a;\u0010\u0000\u001a\u00020\u0005*\u00020\u00052*\u0010\u0006\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00150\u0014\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\u0002\u0010\u0016\u001a)\u0010\u0000\u001a\u00020\u0005*\u00020\u00052\u001d\u0010\b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0010\u0012\u0004\u0012\u00020\u00010\u000f\u00a2\u0006\u0002\b\u000b\u00a8\u0006\u0017"}, d2={"formatTemplate", "", "TBuilder", "TReplacement", "template", "", "replacements", "", "builder", "addReplacement", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "addPart", "(Ljava/lang/String;Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "replacementBuilder", "Lkotlin/Function1;", "Lruntime/text/ReplacementBuilder;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "getTemplateParts", "", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "platform-runtime"})
public final class StringTemplateKt {
    public static final <TBuilder, TReplacement> void formatTemplate(@NotNull String template, @NotNull Function1<? super ReplacementBuilder<TReplacement>, Unit> replacementBuilder, TBuilder builder, @NotNull Function2<? super TBuilder, ? super TReplacement, Unit> addReplacement, @NotNull Function2<? super TBuilder, ? super String, Unit> addPart) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(replacementBuilder, (String)"replacementBuilder");
        Intrinsics.checkNotNullParameter(addReplacement, (String)"addReplacement");
        Intrinsics.checkNotNullParameter(addPart, (String)"addPart");
        ReplacementBuilder replacementBuilder2 = new ReplacementBuilder();
        replacementBuilder.invoke(replacementBuilder2);
        StringTemplateKt.formatTemplate(template, replacementBuilder2.getReplacements(), builder, addReplacement, addPart);
    }

    private static final <TBuilder, TReplacement> void formatTemplate(String template, Map<String, ? extends TReplacement> replacements2, TBuilder builder, Function2<? super TBuilder, ? super TReplacement, Unit> addReplacement, Function2<? super TBuilder, ? super String, Unit> addPart) {
        List<String> parts = StringTemplateKt.getTemplateParts(template);
        for (String part : parts) {
            if (StringsKt.startsWith$default((String)part, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)part, (String)"}", (boolean)false, (int)2, null)) {
                String key2 = StringsKt.dropLast((String)StringsKt.drop((String)part, (int)1), (int)1);
                TReplacement replacement = replacements2.get(key2);
                if (replacement != null) {
                    addReplacement.invoke(builder, replacement);
                    continue;
                }
                addPart.invoke(builder, (Object)part);
                continue;
            }
            addPart.invoke(builder, (Object)part);
        }
    }

    @NotNull
    public static final String formatTemplate(@NotNull String $this$formatTemplate, @NotNull Function1<? super ReplacementBuilder<String>, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        StringBuilder resultBuilder = new StringBuilder();
        StringTemplateKt.formatTemplate($this$formatTemplate, builder, resultBuilder, (Function2)formatTemplate.1.INSTANCE, (Function2)formatTemplate.2.INSTANCE);
        String string2 = resultBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public static final String formatTemplate(@NotNull String $this$formatTemplate, Pair<String, String> ... replacements2) {
        Intrinsics.checkNotNullParameter((Object)$this$formatTemplate, (String)"<this>");
        Intrinsics.checkNotNullParameter(replacements2, (String)"replacements");
        StringBuilder resultBuilder = new StringBuilder();
        StringTemplateKt.formatTemplate($this$formatTemplate, MapsKt.toMap(replacements2), resultBuilder, (Function2)formatTemplate.3.INSTANCE, (Function2)formatTemplate.4.INSTANCE);
        String string2 = resultBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final List<String> getTemplateParts(String template) {
        List parts = new ArrayList();
        StringBuilder currentPartBuilder = new StringBuilder();
        int n = template.length();
        for (int i = 0; i < n; ++i) {
            char c = template.charAt(i);
            char c2 = c;
            if (c2 == '{') {
                String string2 = currentPartBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                parts.add(string2);
                StringsKt.clear((StringBuilder)currentPartBuilder);
                currentPartBuilder.append(c);
                continue;
            }
            if (c2 == '}') {
                currentPartBuilder.append(c);
                String string3 = currentPartBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                parts.add(string3);
                StringsKt.clear((StringBuilder)currentPartBuilder);
                continue;
            }
            currentPartBuilder.append(c);
        }
        if (((CharSequence)currentPartBuilder).length() > 0) {
            String string4 = currentPartBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
            parts.add(string4);
        }
        return parts;
    }
}

