/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.Maybe;
import runtime.reactive.Signal;
import runtime.reactive.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u0013\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lruntime/reactive/ValueSource;", "T", "Lruntime/reactive/Source;", "()V", "broadcastSignal", "Lruntime/reactive/Signal;", "value", "Lruntime/reactive/Maybe;", "maybeValue", "getMaybeValue", "()Lruntime/reactive/Maybe;", "setMaybeValue", "(Lruntime/reactive/Maybe;)V", "clearValue", "", "forEach", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "sink", "Lkotlin/Function1;", "notifyIfValue", "setValue", "(Ljava/lang/Object;)V", "platform-runtime"})
public final class ValueSource<T>
implements Source<T> {
    @NotNull
    private final Signal<T> broadcastSignal = Signal.Companion.create();
    @NotNull
    private Maybe<? extends T> maybeValue = Maybe.None.INSTANCE;

    @NotNull
    public final Maybe<T> getMaybeValue() {
        return this.maybeValue;
    }

    private final void setMaybeValue(Maybe<? extends T> value2) {
        this.maybeValue = value2;
        this.notifyIfValue();
    }

    private final void notifyIfValue() {
        Maybe<? extends T> maybe = this.maybeValue;
        Maybe.Just just2 = maybe instanceof Maybe.Just ? (Maybe.Just)maybe : null;
        if (just2 == null) {
            return;
        }
        Maybe.Just justValue = just2;
        this.broadcastSignal.fire(justValue.getValue());
    }

    public final void clearValue() {
        this.setMaybeValue(Maybe.None.INSTANCE);
    }

    public final void setValue(T value2) {
        this.setMaybeValue((Maybe)new Maybe.Just<T>(value2));
    }

    @Override
    public void forEach(@NotNull Lifetime lifetime, @NotNull Function1<? super T, Unit> sink2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(sink2, (String)"sink");
        this.broadcastSignal.forEach(lifetime, sink2);
        Maybe<? extends T> maybe = this.maybeValue;
        if (maybe instanceof Maybe.Just) {
            sink2.invoke(((Maybe.Just)maybe).getValue());
        }
    }

    @Override
    public void forEachWithPrevious(@NotNull Lifetime lifetime, @NotNull Function2<? super T, ? super T, Unit> consume) {
        Source.DefaultImpls.forEachWithPrevious(this, lifetime, consume);
    }
}

