/*
 * Decompiled with CFR 0.152.
 */
package runtime.date;

import java.time.temporal.WeekFields;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimePeriod;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import runtime.date.DateFormat;
import runtime.date.DateTimeMode;
import runtime.date.TimeOfDay;
import runtime.stringUtils.Symbols;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\r\u001a\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u001a\u0016\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b\u001a)\u0010\u0015\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0018\u001a&\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u001e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u001d\u001a\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0011\u001a\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001d\u001a\u000e\u0010 \u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010!\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b\u001a\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\b\u001a\u000e\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\b\u001a\n\u0010&\u001a\u00020'*\u00020\u001d\u001a\u001e\u0010(\u001a\u00020\u001d*\u00020\u00112\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u0006\u001a\u0012\u0010*\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010&\u001a\u00020'\"\u0019\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006+"}, d2={"DATE_LOCALE", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "getDATE_LOCALE", "()Ljava/util/Locale;", "dateTimeZoneForIdOrNull", "Lorg/joda/time/DateTimeZone;", "id", "", "formatDate", "epochMillis", "", "nowMillis", "(JLjava/lang/Long;)Ljava/lang/String;", "date", "Lkotlinx/datetime/LocalDate;", "now", "Lorg/joda/time/LocalDate;", "formatDateSpan", "from", "to", "formatDateTime", "mode", "Lruntime/date/DateTimeMode;", "(JLruntime/date/DateTimeMode;Ljava/lang/Long;)Ljava/lang/String;", "dateTime", "Lkotlinx/datetime/LocalDateTime;", "zone", "Lkotlinx/datetime/TimeZone;", "Lorg/joda/time/DateTime;", "formatFullDate", "formatFullDateTime", "formatTime", "formatTimeSpan", "setDefaultLocale", "", "name", "setDefaultTimeZone", "timeOfDay", "Lruntime/date/TimeOfDay;", "toDateTime", "timezone", "withTime", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Dates.kt\nruntime/date/DatesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class DatesKt {
    private static final Locale DATE_LOCALE = Locale.ENGLISH;

    public static final Locale getDATE_LOCALE() {
        return DATE_LOCALE;
    }

    @NotNull
    public static final String formatDate(long epochMillis, @Nullable Long nowMillis) {
        DateTime dateTime2;
        Long l = nowMillis;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            dateTime2 = new DateTime(it);
        } else {
            dateTime2 = new DateTime();
        }
        DateTime now = dateTime2;
        DateTime dateTime3 = new DateTime(epochMillis);
        LocalDate localDate = dateTime3.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        LocalDate localDate2 = now.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"toLocalDate(...)");
        return DatesKt.formatDate(localDate, localDate2);
    }

    public static /* synthetic */ String formatDate$default(long l, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = null;
        }
        return DatesKt.formatDate(l, l2);
    }

    @NotNull
    public static final String formatTime(long epochMillis) {
        DateTime dateTime2 = new DateTime(epochMillis);
        String string2 = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print(dateTime2.toLocalTime());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"print(...)");
        return string2;
    }

    @NotNull
    public static final String formatDate(@NotNull LocalDate date2, @NotNull LocalDate now) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (date2.getYear() == now.getYear()) {
            String string3 = DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print(date2);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"print(...)");
        } else {
            string2 = DatesKt.formatFullDate(date2);
        }
        return string2;
    }

    @NotNull
    public static final String formatDate(@NotNull kotlinx.datetime.LocalDate date2, @NotNull kotlinx.datetime.LocalDate now) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (date2.getYear() == now.getYear()) {
            String string3 = ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)date2).format(DateFormat.NO_YEAR_DATE_NON_BREAKING.getJavaFormatter());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string2 = DatesKt.formatFullDate(date2);
        }
        return string2;
    }

    @NotNull
    public static final String formatFullDate(@NotNull LocalDate dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        String string2 = DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"print(...)");
        return string2;
    }

    @NotNull
    public static final String formatFullDate(@NotNull kotlinx.datetime.LocalDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        String string2 = ConvertersKt.toJavaLocalDate((kotlinx.datetime.LocalDate)date2).format(DateFormat.DATE_NON_BREAKING.getJavaFormatter());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final String formatDateTime(long epochMillis, @NotNull DateTimeMode mode2, @Nullable Long nowMillis) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Long l = nowMillis;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            dateTime2 = new DateTime(it);
        } else {
            dateTime2 = new DateTime();
        }
        DateTime now = dateTime2;
        DateTime dateTime3 = new DateTime(epochMillis);
        return DatesKt.formatDateTime(dateTime3, mode2, now);
    }

    public static /* synthetic */ String formatDateTime$default(long l, DateTimeMode dateTimeMode, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeMode = DateTimeMode.DEFAULT;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        return DatesKt.formatDateTime(l, dateTimeMode, l2);
    }

    @NotNull
    public static final String formatDateTime(@NotNull DateTime dateTime2, @NotNull DateTimeMode mode2, @NotNull DateTime now) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Duration duration = new Duration(dateTime2, now);
        if (now.isBefore(dateTime2)) {
            String string2;
            if ((mode2.isDefault$platform_runtime() || mode2.isCompact$platform_runtime()) && Intrinsics.areEqual((Object)dateTime2.withTimeAtStartOfDay(), (Object)now.withTimeAtStartOfDay())) {
                String string3 = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print(dateTime2);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"print(...)");
            } else {
                String string4 = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"print(...)");
            }
            return string2;
        }
        if (mode2.isDefault$platform_runtime() && duration.getStandardMinutes() < 1L) {
            object = "just now";
        } else if (mode2.isDefault$platform_runtime() && duration.getStandardHours() < 1L) {
            object = duration.getStandardMinutes() + "m" + Symbols.Nbsp + "ago";
        } else if (mode2.isDefault$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.withTimeAtStartOfDay(), (Object)now.withTimeAtStartOfDay())) {
            String string5 = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print(dateTime2);
            object = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"print(...)");
        } else if (mode2.isDefault$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string6 = DateFormat.NO_YEAR_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
            object = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"print(...)");
        } else if (mode2.isAbsolute$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string7 = DateFormat.NO_YEAR_ABSOLUTE_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
            object = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"print(...)");
        } else if (mode2.isAbsolute$platform_runtime()) {
            String string8 = DateFormat.ABSOLUTE_DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
            object = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"print(...)");
        } else if (mode2.isCompact$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.dayOfYear(), (Object)now.dayOfYear()) && Intrinsics.areEqual((Object)dateTime2.year(), (Object)now.year())) {
            String string9 = DateFormat.HOURS_AND_MINUTES.getJodaTimeFormatter().print(dateTime2);
            object = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"print(...)");
        } else if (mode2.isCompact$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.weekOfWeekyear(), (Object)now.weekOfWeekyear())) {
            String string10 = DateFormat.WEEKDAY.getJodaTimeFormatter().print(dateTime2);
            object = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"print(...)");
        } else if (mode2.isCompact$platform_runtime() && (Intrinsics.areEqual((Object)dateTime2.year(), (Object)now.year()) || duration.getStandardDays() < 120L)) {
            String string11 = DateFormat.MONTH_DAY.getJodaTimeFormatter().print(dateTime2);
            object = string11;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"print(...)");
        } else if (mode2.isCompact$platform_runtime()) {
            String string12 = DateFormat.YEAR.getJodaTimeFormatter().print(dateTime2);
            object = string12;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"print(...)");
        } else if (mode2.isTable$platform_runtime()) {
            String string13 = DateFormat.DASHED_DATE_TIME.getJodaTimeFormatter().print(dateTime2);
            object = string13;
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"print(...)");
        } else {
            String string14 = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(dateTime2);
            object = string14;
            Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"print(...)");
        }
        return object;
    }

    @NotNull
    public static final String formatDateTime(@NotNull LocalDateTime dateTime2, @NotNull DateTimeMode mode2, @NotNull LocalDateTime now, @NotNull TimeZone zone) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        DateTimePeriod period = InstantJvmKt.periodUntil((Instant)TimeZoneKt.toInstant((LocalDateTime)dateTime2, (TimeZone)zone), (Instant)TimeZoneKt.toInstant((LocalDateTime)now, (TimeZone)zone), (TimeZone)zone);
        int periodMinutes = period.getHours() * 60 + period.getMinutes();
        if (now.compareTo(dateTime2) < 0) {
            String string2;
            if ((mode2.isDefault$platform_runtime() || mode2.isCompact$platform_runtime()) && Intrinsics.areEqual((Object)dateTime2.getDate(), (Object)now.getDate())) {
                String string3 = DateFormat.HOURS_AND_MINUTES.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                String string4 = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            }
            return string2;
        }
        if (mode2.isDefault$platform_runtime() && periodMinutes < 1) {
            object = "just now";
        } else if (mode2.isDefault$platform_runtime() && period.getHours() < 1) {
            object = periodMinutes + "m" + Symbols.Nbsp + "ago";
        } else if (mode2.isDefault$platform_runtime() && Intrinsics.areEqual((Object)dateTime2.getDate(), (Object)now.getDate())) {
            String string5 = DateFormat.HOURS_AND_MINUTES.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        } else if (mode2.isDefault$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string6 = DateFormat.NO_YEAR_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        } else if (mode2.isAbsolute$platform_runtime() && dateTime2.getYear() == now.getYear()) {
            String string7 = DateFormat.NO_YEAR_ABSOLUTE_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        } else if (mode2.isAbsolute$platform_runtime()) {
            String string8 = DateFormat.ABSOLUTE_DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
        } else if (mode2.isCompact$platform_runtime() && dateTime2.getDayOfYear() == now.getDayOfYear() && dateTime2.getYear() == now.getYear()) {
            String string9 = DateFormat.HOURS_AND_MINUTES.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
        } else if (mode2.isCompact$platform_runtime() && ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2).get(WeekFields.ISO.weekOfYear()) == ConvertersKt.toJavaLocalDateTime((LocalDateTime)now).get(WeekFields.ISO.weekOfYear())) {
            String string10 = DateFormat.WEEKDAY.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(...)");
        } else if (mode2.isCompact$platform_runtime() && (dateTime2.getYear() == now.getYear() || period.getDays() < 120)) {
            String string11 = DateFormat.MONTH_DAY.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string11;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
        } else if (mode2.isCompact$platform_runtime()) {
            String string12 = DateFormat.YEAR.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string12;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"format(...)");
        } else {
            String string13 = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
            object = string13;
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"format(...)");
        }
        return object;
    }

    @NotNull
    public static final String formatFullDateTime(long epochMillis) {
        String string2 = DateFormat.DATE_TIME_NON_BREAKING.getJodaTimeFormatter().print(epochMillis);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"print(...)");
        return string2;
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull DateTime dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        return DatesKt.formatFullDateTime(dateTime2.getMillis());
    }

    @NotNull
    public static final String formatFullDateTime(@NotNull LocalDateTime dateTime2) {
        Intrinsics.checkNotNullParameter((Object)dateTime2, (String)"dateTime");
        String string2 = DateFormat.DATE_TIME_NON_BREAKING.getJavaFormatter().format(ConvertersKt.toJavaLocalDateTime((LocalDateTime)dateTime2));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public static final void setDefaultTimeZone(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        java.util.TimeZone.setDefault(java.util.TimeZone.getTimeZone(name2));
    }

    @NotNull
    public static final String formatTimeSpan(long from, long to) {
        Object object;
        LocalDate nowDate = new LocalDate();
        LocalDate fromDate = new LocalDate(from);
        LocalDate toDate = new LocalDate(to);
        DateTimeFormatter mainFormat = nowDate.getYear() != fromDate.getYear() ? DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter() : DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter();
        if (fromDate.getYear() != toDate.getYear()) {
            object = mainFormat.print(fromDate) + "\u2009\u2013\u2009" + mainFormat.print(toDate);
        } else if (!Intrinsics.areEqual((Object)fromDate.monthOfYear(), (Object)toDate.monthOfYear())) {
            object = DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print(fromDate) + "\u2009\u2013\u2009" + mainFormat.print(toDate);
        } else if (fromDate.getDayOfMonth() != toDate.getDayOfMonth()) {
            object = DateFormat.DAY.getJodaTimeFormatter().print(fromDate) + "\u2013" + mainFormat.print(toDate);
        } else {
            String string2 = mainFormat.print(fromDate);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"print(...)");
        }
        return object;
    }

    public static final void setDefaultLocale(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
    }

    @Nullable
    public static final DateTimeZone dateTimeZoneForIdOrNull(@NotNull String id2) {
        DateTimeZone dateTimeZone;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        try {
            dateTimeZone = DateTimeZone.forID(id2);
        }
        catch (Throwable th) {
            dateTimeZone = null;
        }
        return dateTimeZone;
    }

    @NotNull
    public static final String formatDateSpan(long from, long to) {
        Object object;
        LocalDate start2 = new LocalDate(from);
        LocalDate end = new LocalDate(to);
        if (start2.getYear() == end.getYear() && start2.getDayOfYear() == end.getDayOfYear()) {
            String string2 = DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(start2);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"print(...)");
        } else {
            object = start2.getYear() == end.getYear() && start2.getMonthOfYear() == end.getMonthOfYear() ? DateFormat.DAY.getJodaTimeFormatter().print(start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(end) : (start2.getYear() == end.getYear() ? DateFormat.NO_YEAR_DATE_NON_BREAKING.getJodaTimeFormatter().print(start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(end) : DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(start2) + "\u2009\u2013\u2009" + DateFormat.DATE_NON_BREAKING.getJodaTimeFormatter().print(end));
        }
        return object;
    }

    @NotNull
    public static final DateTime toDateTime(@NotNull LocalDate $this$toDateTime, @NotNull TimeOfDay timeOfDay, @Nullable DateTimeZone timezone) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)$this$toDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeOfDay, (String)"timeOfDay");
        if (timeOfDay.getHours() == 24) {
            DateTime dateTime3 = $this$toDateTime.plusDays(1).toDateTimeAtStartOfDay(timezone);
            Intrinsics.checkNotNull((Object)dateTime3);
            dateTime2 = dateTime3;
        } else {
            Integer n = timeOfDay.getSeconds();
            LocalTime localTime = new LocalTime(timeOfDay.getHours(), timeOfDay.getMinutes(), n != null ? n : 0);
            DateTime dateTime4 = $this$toDateTime.toDateTime(localTime, timezone);
            Intrinsics.checkNotNull((Object)dateTime4);
            dateTime2 = dateTime4;
        }
        return dateTime2;
    }

    public static /* synthetic */ DateTime toDateTime$default(LocalDate localDate, TimeOfDay timeOfDay, DateTimeZone dateTimeZone, int n, Object object) {
        if ((n & 2) != 0) {
            dateTimeZone = null;
        }
        return DatesKt.toDateTime(localDate, timeOfDay, dateTimeZone);
    }

    @NotNull
    public static final DateTime withTime(@NotNull DateTime $this$withTime, @NotNull TimeOfDay timeOfDay) {
        DateTime dateTime2;
        Intrinsics.checkNotNullParameter((Object)$this$withTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)timeOfDay, (String)"timeOfDay");
        if (timeOfDay.getHours() == 24) {
            DateTime dateTime3 = $this$withTime.plusDays(1).withTimeAtStartOfDay();
            Intrinsics.checkNotNull((Object)dateTime3);
            dateTime2 = dateTime3;
        } else {
            Integer n = timeOfDay.getSeconds();
            LocalTime localTime = new LocalTime(timeOfDay.getHours(), timeOfDay.getMinutes(), n != null ? n : 0);
            DateTime dateTime4 = $this$withTime.withTime(localTime);
            Intrinsics.checkNotNull((Object)dateTime4);
            dateTime2 = dateTime4;
        }
        return dateTime2;
    }

    @NotNull
    public static final TimeOfDay timeOfDay(@NotNull DateTime $this$timeOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$timeOfDay, (String)"<this>");
        return new TimeOfDay($this$timeOfDay.getHourOfDay(), $this$timeOfDay.getMinuteOfHour(), null, 4, null);
    }
}

