/*
 * Decompiled with CFR 0.152.
 */
package runtime.container;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import runtime.container.Plugin;
import runtime.container.PluginDescriptor;
import runtime.json.JacksonConfiguration;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002\u001a\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"log", "Llibraries/klogging/KLogger;", "filename", "", "Ljava/net/URL;", "getFilename", "(Ljava/net/URL;)Ljava/lang/String;", "getJarsFromDirectory", "", "dir", "Ljava/io/File;", "jarsToExclude", "", "loadPluginDescriptor", "Lruntime/container/PluginDescriptor;", "pluginBootJars", "startsWithAnyOf", "", "prefixes", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nPluginDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginDescriptor.kt\nruntime/container/PluginDescriptorKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 jsonDsl.kt\nruntime/json/JsonDslKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,74:1\n11065#2:75\n11400#2,3:76\n357#3:79\n1747#4,3:80\n14#5:83\n*S KotlinDebug\n*F\n+ 1 PluginDescriptor.kt\nruntime/container/PluginDescriptorKt\n*L\n49#1:75\n49#1:76,3\n58#1:79\n70#1:80,3\n9#1:83\n*E\n"})
public final class PluginDescriptorKt {
    @NotNull
    private static final KLogger log;

    /*
     * WARNING - void declaration
     */
    private static final List<URL> getJarsFromDirectory(File dir, Set<String> jarsToExclude) {
        List list2;
        File[] fileArray = dir.listFiles((arg_0, arg_1) -> PluginDescriptorKt.getJarsFromDirectory$lambda$0(jarsToExclude, arg_0, arg_1));
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toURI().toURL());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PluginDescriptor loadPluginDescriptor(List<URL> pluginBootJars) {
        for (URL pluginJar : pluginBootJars) {
            try {
                Closeable closeable = new JarFile(pluginJar.getFile());
                Throwable throwable = null;
                try {
                    ZipEntry zipEntry;
                    JarFile jar = (JarFile)closeable;
                    boolean bl = false;
                    ZipEntry zipEntry2 = zipEntry = jar.getEntry("plugin.json");
                    if (zipEntry2 != null) {
                        PluginDescriptor pluginDescriptor;
                        Intrinsics.checkNotNull((Object)zipEntry2);
                        ZipEntry entry = zipEntry;
                        boolean bl2 = false;
                        Closeable closeable2 = jar.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            InputStream it = (InputStream)closeable2;
                            boolean bl3 = false;
                            boolean $i$f$getJackson = false;
                            ObjectMapper objectMapper = JacksonConfiguration.INSTANCE.getJackson();
                            Intrinsics.checkNotNull((Object)it);
                            Object object = objectMapper.readValue(ByteStreamsKt.readBytes((InputStream)it), PluginDescriptor.class);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                            pluginDescriptor = (PluginDescriptor)object;
                        }
                        catch (Throwable throwable3) {
                            try {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                                throw throwable4;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        PluginDescriptor pluginDescriptor2 = pluginDescriptor;
                        return pluginDescriptor2;
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Throwable th) {
                log.error(th, "Can not load plugin jar: " + pluginJar.getFile());
                throw th;
            }
        }
        return new PluginDescriptor(null, null, 3, null);
    }

    private static final boolean startsWithAnyOf(String $this$startsWithAnyOf, Set<String> prefixes) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = prefixes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)$this$startsWithAnyOf, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String getFilename(URL $this$filename) {
        String string2 = $this$filename.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFile(...)");
        return StringsKt.substringAfterLast$default((String)string2, (char)'/', null, (int)2, null);
    }

    private static final boolean getJarsFromDirectory$lambda$0(Set $jarsToExclude, File file2, String name2) {
        Intrinsics.checkNotNullParameter((Object)$jarsToExclude, (String)"$jarsToExclude");
        Intrinsics.checkNotNull((Object)name2);
        return StringsKt.endsWith((String)name2, (String)".jar", (boolean)true) && !$jarsToExclude.contains(name2);
    }

    public static final /* synthetic */ PluginDescriptor access$loadPluginDescriptor(List pluginBootJars) {
        return PluginDescriptorKt.loadPluginDescriptor(pluginBootJars);
    }

    public static final /* synthetic */ List access$getJarsFromDirectory(File dir, Set jarsToExclude) {
        return PluginDescriptorKt.getJarsFromDirectory(dir, jarsToExclude);
    }

    public static final /* synthetic */ String access$getFilename(URL $receiver) {
        return PluginDescriptorKt.getFilename($receiver);
    }

    public static final /* synthetic */ boolean access$startsWithAnyOf(String $receiver, Set prefixes) {
        return PluginDescriptorKt.startsWithAnyOf($receiver, prefixes);
    }

    static {
        boolean $i$f$logger = false;
        log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(Plugin.class));
    }
}

