/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.HasLatestStrategy;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class ChainResolver
extends AbstractResolver {
    private boolean returnFirst = false;
    private List<DependencyResolver> chain = new ArrayList<DependencyResolver>();
    private boolean dual;

    public void add(DependencyResolver resolver2) {
        this.chain.add(resolver2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data2) throws ParseException {
        data2 = new ResolveData(data2, this.doValidate(data2));
        ArrayList<Exception> errors2 = new ArrayList<Exception>();
        ResolvedModuleRevision resolved2 = data2.getCurrentResolvedModuleRevision();
        ResolvedModuleRevision mr = resolved2;
        if (mr == null) {
            Message.verbose(this.getName() + ": Checking cache for: " + dd);
            mr = this.findModuleInCache(dd, data2, true);
            if (mr != null) {
                Message.verbose(this.getName() + ": module revision found in cache: " + mr.getId());
                mr = this.forcedRevision(mr);
            }
        }
        for (DependencyResolver resolver2 : this.chain) {
            LatestStrategy oldLatest = this.setLatestIfRequired(resolver2, this.getLatestStrategy());
            try {
                ResolvedModuleRevision previouslyResolved = mr;
                data2.setCurrentResolvedModuleRevision(previouslyResolved);
                mr = resolver2.getDependency(dd, data2);
                if (mr != previouslyResolved && this.isReturnFirst()) {
                    mr = this.forcedRevision(mr);
                }
            }
            catch (Exception ex) {
                Message.verbose("problem occurred while resolving " + dd + " with " + resolver2, ex);
                errors2.add(ex);
            }
            finally {
                if (oldLatest != null) {
                    ChainResolver.setLatest(resolver2, oldLatest);
                }
            }
            this.checkInterrupted();
        }
        if (mr == null && !errors2.isEmpty()) {
            if (errors2.size() == 1) {
                Exception ex = (Exception)errors2.get(0);
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof ParseException) {
                    throw (ParseException)ex;
                }
                throw new RuntimeException(ex.toString(), ex);
            }
            StringBuilder err = new StringBuilder();
            for (Exception ex : errors2) {
                err.append("\t").append(StringUtils.getErrorMessage(ex)).append("\n");
            }
            err.setLength(err.length() - 1);
            throw new RuntimeException("several problems occurred while resolving " + dd + ":\n" + err);
        }
        if (resolved2 == mr) {
            return resolved2;
        }
        return this.resolvedRevision(mr);
    }

    private ResolvedModuleRevision resolvedRevision(ResolvedModuleRevision mr) {
        if (this.isDual() && mr != null) {
            return new ResolvedModuleRevision(mr.getResolver(), this, mr.getDescriptor(), mr.getReport(), mr.isForce());
        }
        return mr;
    }

    private ResolvedModuleRevision forcedRevision(ResolvedModuleRevision rmr) {
        if (rmr == null) {
            return null;
        }
        return new ResolvedModuleRevision(rmr.getResolver(), rmr.getArtifactResolver(), rmr.getDescriptor(), rmr.getReport(), true);
    }

    private LatestStrategy setLatestIfRequired(DependencyResolver resolver2, LatestStrategy latestStrategy) {
        String latestName = ChainResolver.getLatestStrategyName(resolver2);
        if (latestName != null && !"default".equals(latestName)) {
            LatestStrategy oldLatest = ChainResolver.getLatest(resolver2);
            ChainResolver.setLatest(resolver2, latestStrategy);
            return oldLatest;
        }
        return null;
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data2) {
        for (DependencyResolver resolver2 : this.chain) {
            ResolvedResource result2 = resolver2.findIvyFileRef(dd, data2);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    public Map<String, String>[] listTokenValues(String[] tokens2, Map<String, Object> criteria) {
        HashSet<Map<String, String>> result2 = new HashSet<Map<String, String>>();
        for (DependencyResolver resolver2 : this.chain) {
            Map<String, String>[] temp = resolver2.listTokenValues(tokens2, new HashMap<String, Object>(criteria));
            result2.addAll(Arrays.asList(temp));
        }
        return result2.toArray(new Map[result2.size()]);
    }

    @Override
    public void reportFailure() {
        for (DependencyResolver resolver2 : this.chain) {
            resolver2.reportFailure();
        }
    }

    @Override
    public void reportFailure(Artifact art) {
        for (DependencyResolver resolver2 : this.chain) {
            resolver2.reportFailure(art);
        }
    }

    @Override
    public DownloadReport download(Artifact[] artifacts, DownloadOptions options2) {
        ArrayList<Artifact> artifactsToDownload = new ArrayList<Artifact>(Arrays.asList(artifacts));
        DownloadReport report2 = new DownloadReport();
        for (DependencyResolver resolver2 : this.chain) {
            if (artifactsToDownload.isEmpty()) break;
            DownloadReport r = resolver2.download(artifactsToDownload.toArray(new Artifact[artifactsToDownload.size()]), options2);
            for (ArtifactDownloadReport adr : r.getArtifactsReports()) {
                if (adr.getDownloadStatus() == DownloadStatus.FAILED) continue;
                artifactsToDownload.remove(adr.getArtifact());
                report2.addArtifactReport(adr);
            }
        }
        for (Artifact art : artifactsToDownload) {
            ArtifactDownloadReport adr = new ArtifactDownloadReport(art);
            adr.setDownloadStatus(DownloadStatus.FAILED);
            report2.addArtifactReport(adr);
        }
        return report2;
    }

    public List<DependencyResolver> getResolvers() {
        return this.chain;
    }

    @Override
    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        this.getFirstResolver().publish(artifact, src, overwrite);
    }

    @Override
    public void abortPublishTransaction() throws IOException {
        this.getFirstResolver().abortPublishTransaction();
    }

    @Override
    public void beginPublishTransaction(ModuleRevisionId module2, boolean overwrite) throws IOException {
        this.getFirstResolver().beginPublishTransaction(module2, overwrite);
    }

    @Override
    public void commitPublishTransaction() throws IOException {
        this.getFirstResolver().commitPublishTransaction();
    }

    private DependencyResolver getFirstResolver() {
        if (this.chain.isEmpty()) {
            throw new IllegalStateException("invalid chain resolver with no sub resolver");
        }
        return this.chain.get(0);
    }

    public boolean isReturnFirst() {
        return this.returnFirst;
    }

    public void setReturnFirst(boolean returnFirst) {
        this.returnFirst = returnFirst;
    }

    @Override
    public void dumpSettings() {
        Message.verbose("\t" + this.getName() + " [chain] " + this.chain);
        Message.debug("\t\treturn first: " + this.isReturnFirst());
        Message.debug("\t\tdual: " + this.isDual());
        for (DependencyResolver resolver2 : this.chain) {
            Message.debug("\t\t-> " + resolver2.getName());
        }
    }

    @Override
    public boolean exists(Artifact artifact) {
        for (DependencyResolver resolver2 : this.chain) {
            if (!resolver2.exists(artifact)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArtifactOrigin locate(Artifact artifact) {
        for (DependencyResolver resolver2 : this.chain) {
            ArtifactOrigin origin2 = resolver2.locate(artifact);
            if (ArtifactOrigin.isUnknown(origin2)) continue;
            return origin2;
        }
        return ArtifactOrigin.unknown(artifact);
    }

    @Override
    public ArtifactDownloadReport download(ArtifactOrigin artifact, DownloadOptions options2) {
        for (DependencyResolver resolver2 : this.chain) {
            ArtifactDownloadReport adr = resolver2.download(artifact, options2);
            if (adr.getDownloadStatus() == DownloadStatus.FAILED) continue;
            return adr;
        }
        ArtifactDownloadReport adr = new ArtifactDownloadReport(artifact.getArtifact());
        adr.setDownloadStatus(DownloadStatus.FAILED);
        return adr;
    }

    private static void setLatest(DependencyResolver resolver2, LatestStrategy latest) {
        if (resolver2 instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver2);
            r.setLatestStrategy(latest);
        }
    }

    private static LatestStrategy getLatest(DependencyResolver resolver2) {
        if (resolver2 instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver2);
            return r.getLatestStrategy();
        }
        return null;
    }

    private static String getLatestStrategyName(DependencyResolver resolver2) {
        if (resolver2 instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver2);
            return r.getLatest();
        }
        return null;
    }

    public void setDual(boolean b) {
        this.dual = b;
    }

    public boolean isDual() {
        return this.dual;
    }

    public static class ResolvedModuleRevisionArtifactInfo
    implements ArtifactInfo {
        private ResolvedModuleRevision rmr;

        public ResolvedModuleRevisionArtifactInfo(ResolvedModuleRevision rmr) {
            this.rmr = rmr;
        }

        @Override
        public String getRevision() {
            return this.rmr.getId().getRevision();
        }

        @Override
        public long getLastModified() {
            return this.rmr.getPublicationDate().getTime();
        }
    }
}

