/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.util.Message;

public class LogReportOutputter
implements ReportOutputter {
    @Override
    public String getName() {
        return "console";
    }

    @Override
    public void output(ResolveReport report2, ResolutionCacheManager cacheMgr, ResolveOptions options2) throws IOException {
        ArtifactDownloadReport[] errors2;
        IvyNode[] unresolved;
        IvyNode[] evicted;
        IvySettings settings2 = IvyContext.getContext().getSettings();
        if (settings2.logModulesInUse() && "default".equals(options2.getLog())) {
            Message.info("\t:: modules in use:");
            ArrayList<IvyNode> dependencies = new ArrayList<IvyNode>(report2.getDependencies());
            Collections.sort(dependencies);
            if (dependencies.size() > 0) {
                Object[] confs = report2.getConfigurations();
                for (IvyNode node : dependencies) {
                    if (node.isCompletelyEvicted() || node.hasProblem()) continue;
                    ArrayList<Object> nodeConfs = new ArrayList<Object>(confs.length);
                    for (Object conf : confs) {
                        if (!report2.getConfigurationReport((String)conf).getModuleRevisionIds().contains(node.getResolvedId())) continue;
                        nodeConfs.add(conf);
                    }
                    Message.info("\t" + node + " from " + node.getModuleRevision().getResolver().getName() + " in " + nodeConfs);
                }
            }
        }
        if ((evicted = report2.getEvictedNodes()).length > 0 && "default".equals(options2.getLog())) {
            Message.info("\t:: evicted modules:");
            for (IvyNode evictedNode : evicted) {
                Collection<String> allEvictingNodes = evictedNode.getAllEvictingNodesDetails();
                if (allEvictingNodes == null) {
                    Message.info("\t" + evictedNode + " transitively in " + Arrays.asList(evictedNode.getEvictedConfs()));
                } else if (allEvictingNodes.isEmpty()) {
                    Message.info("\t" + evictedNode + " by [] (" + evictedNode.getAllEvictingConflictManagers() + ") in " + Arrays.asList(evictedNode.getEvictedConfs()));
                } else {
                    Message.info("\t" + evictedNode + " by " + allEvictingNodes + " in " + Arrays.asList(evictedNode.getEvictedConfs()));
                }
                for (String conf : evictedNode.getEvictedConfs()) {
                    IvyNodeEviction.EvictionData evictedData = evictedNode.getEvictedData(conf);
                    if (evictedData.getParent() == null) continue;
                    Message.verbose("\t  in " + evictedData.getParent() + " with " + evictedData.getConflictManager());
                }
            }
        }
        if ("default".equals(options2.getLog())) {
            char[] sep = new char[69];
            Arrays.fill(sep, '-');
            Message.rawinfo("\t" + new String(sep));
            Object line2 = new StringBuilder("\t");
            this.append((StringBuilder)line2, "", 18);
            this.append((StringBuilder)line2, "modules", 31);
            ((StringBuilder)line2).append("|");
            this.append((StringBuilder)line2, "artifacts", 15);
            ((StringBuilder)line2).append("|");
            Message.rawinfo(((StringBuilder)line2).toString());
            line2 = new StringBuilder("\t");
            this.append((StringBuilder)line2, "conf", 18);
            this.append((StringBuilder)line2, "number", 7);
            this.append((StringBuilder)line2, "search", 7);
            this.append((StringBuilder)line2, "dwnlded", 7);
            this.append((StringBuilder)line2, "evicted", 7);
            ((StringBuilder)line2).append("|");
            this.append((StringBuilder)line2, "number", 7);
            this.append((StringBuilder)line2, "dwnlded", 7);
            ((StringBuilder)line2).append("|");
            Message.rawinfo(((StringBuilder)line2).toString());
            Message.rawinfo("\t" + new String(sep));
            for (String conf : report2.getConfigurations()) {
                this.output(report2.getConfigurationReport(conf));
            }
            Message.rawinfo("\t" + new String(sep));
        }
        if ((unresolved = report2.getUnresolvedDependencies()).length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
            Message.warn("\t::          UNRESOLVED DEPENDENCIES         ::");
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
        }
        for (IvyNode anUnresolved : unresolved) {
            Message.warn("\t:: " + anUnresolved + ": " + anUnresolved.getProblemMessage());
        }
        if (unresolved.length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::\n");
        }
        if ((errors2 = report2.getFailedArtifactsReports()).length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
            Message.warn("\t::              FAILED DOWNLOADS            ::");
            Message.warn("\t:: ^ see resolution messages for details  ^ ::");
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::");
        }
        for (ArtifactDownloadReport error2 : errors2) {
            Message.warn("\t:: " + error2.getArtifact());
        }
        if (errors2.length > 0) {
            Message.warn("\t::::::::::::::::::::::::::::::::::::::::::::::\n");
        }
    }

    public void output(ConfigurationResolveReport report2) {
        StringBuilder line2 = new StringBuilder("\t");
        this.append(line2, report2.getConfiguration(), 18);
        this.append(line2, String.valueOf(report2.getNodesNumber()), 7);
        this.append(line2, String.valueOf(report2.getSearchedNodes().length), 7);
        this.append(line2, String.valueOf(report2.getDownloadedNodes().length), 7);
        this.append(line2, String.valueOf(report2.getEvictedNodes().length), 7);
        line2.append("|");
        this.append(line2, String.valueOf(report2.getArtifactsNumber()), 7);
        this.append(line2, String.valueOf(report2.getDownloadedArtifactsReports().length), 7);
        line2.append("|");
        Message.rawinfo(line2.toString());
    }

    private void append(StringBuilder line2, Object o, int limit) {
        String v = String.valueOf(o);
        if (v.length() >= limit) {
            v = v.substring(0, limit);
        } else {
            int missing = limit - v.length();
            int half = missing / 2;
            char[] c = new char[limit];
            Arrays.fill(c, ' ');
            System.arraycopy(v.toCharArray(), 0, c, missing - half, v.length());
            v = new String(c);
        }
        line2.append("|");
        line2.append(v);
    }
}

