/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.namespace;

import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;

public final class NameSpaceHelper {
    private NameSpaceHelper() {
    }

    public static DependencyDescriptor toSystem(DependencyDescriptor dd, Namespace ns) {
        return DefaultDependencyDescriptor.transformInstance(dd, ns);
    }

    public static DependencyDescriptor transform(DependencyDescriptor dd, NamespaceTransformer t, boolean fromSystem) {
        return DefaultDependencyDescriptor.transformInstance(dd, t, fromSystem);
    }

    public static ModuleDescriptor toSystem(ModuleDescriptor md, Namespace ns) {
        return DefaultModuleDescriptor.transformInstance(md, ns);
    }

    public static ResolvedModuleRevision toSystem(ResolvedModuleRevision rmr, Namespace ns) {
        if (ns.getToSystemTransformer().isIdentity()) {
            return rmr;
        }
        ModuleDescriptor md = NameSpaceHelper.toSystem(rmr.getDescriptor(), ns);
        if (md.equals(rmr.getDescriptor())) {
            return rmr;
        }
        return new ResolvedModuleRevision(rmr.getResolver(), rmr.getArtifactResolver(), md, NameSpaceHelper.transform(rmr.getReport(), ns.getToSystemTransformer()), rmr.isForce());
    }

    public static Artifact transform(Artifact artifact, NamespaceTransformer t) {
        if (t.isIdentity()) {
            return artifact;
        }
        ModuleRevisionId mrid = t.transform(artifact.getModuleRevisionId());
        if (artifact.getModuleRevisionId().equals(mrid)) {
            return artifact;
        }
        return new DefaultArtifact(mrid, artifact.getPublicationDate(), artifact.getName(), artifact.getType(), artifact.getExt(), artifact.getUrl(), artifact.getQualifiedExtraAttributes());
    }

    public static MetadataArtifactDownloadReport transform(MetadataArtifactDownloadReport report2, NamespaceTransformer t) {
        if (t.isIdentity()) {
            return report2;
        }
        MetadataArtifactDownloadReport madr = new MetadataArtifactDownloadReport(NameSpaceHelper.transform(report2.getArtifact(), t));
        madr.setSearched(report2.isSearched());
        madr.setDownloadStatus(report2.getDownloadStatus());
        madr.setDownloadDetails(report2.getDownloadDetails());
        madr.setArtifactOrigin(report2.getArtifactOrigin());
        madr.setDownloadTimeMillis(report2.getDownloadTimeMillis());
        madr.setOriginalLocalFile(report2.getOriginalLocalFile());
        madr.setLocalFile(report2.getLocalFile());
        madr.setSize(report2.getSize());
        return madr;
    }

    public static ArtifactId transform(ArtifactId artifactId, NamespaceTransformer t) {
        if (t.isIdentity()) {
            return artifactId;
        }
        ModuleId mid = NameSpaceHelper.transform(artifactId.getModuleId(), t);
        if (mid.equals(artifactId.getModuleId())) {
            return artifactId;
        }
        return new ArtifactId(mid, artifactId.getName(), artifactId.getType(), artifactId.getExt());
    }

    public static ModuleId transform(ModuleId mid, NamespaceTransformer t) {
        if (t.isIdentity()) {
            return mid;
        }
        return t.transform(new ModuleRevisionId(mid, "")).getModuleId();
    }

    public static String transformOrganisation(String org, NamespaceTransformer t) {
        return NameSpaceHelper.transform(new ModuleId(org, ""), t).getOrganisation();
    }
}

