/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;

public class RelativeURLRepository
extends URLRepository {
    private final URL baseUrl;
    private Map<String, Resource> resourcesCache = new HashMap<String, Resource>();

    public RelativeURLRepository() {
        this.baseUrl = null;
    }

    @Deprecated
    public RelativeURLRepository(URL baseUrl) {
        this(baseUrl, null);
    }

    public RelativeURLRepository(URL baseUrl, TimeoutConstraint timeoutConstraint) {
        super(timeoutConstraint);
        this.baseUrl = baseUrl;
    }

    @Override
    public Resource getResource(String source2) throws IOException {
        Resource res = this.resourcesCache.get(source2 = RelativeURLRepository.encode(source2));
        if (res == null) {
            URI uri;
            try {
                uri = new URI(source2);
            }
            catch (URISyntaxException e) {
                uri = null;
            }
            res = uri == null || uri.isAbsolute() ? new URLResource(new URL(source2), this.getTimeoutConstraint()) : new URLResource(new URL(this.baseUrl + source2), this.getTimeoutConstraint());
            this.resourcesCache.put(source2, res);
        }
        return res;
    }

    private static String encode(String source2) {
        return source2.trim().replaceAll(" ", "%20");
    }
}

