/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.text.ParseException;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.obr.xml.Capability;
import org.apache.ivy.osgi.obr.xml.CapabilityProperty;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class CapabilityAdapter {
    public static void adapt(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String name2;
        switch (name2 = capability.getName()) {
            case "package": {
                bundleInfo.addCapability(CapabilityAdapter.getExportPackage(bundleInfo, capability));
                break;
            }
            case "bundle": {
                break;
            }
            case "service": {
                bundleInfo.addCapability(CapabilityAdapter.getOSGiService(bundleInfo, capability));
                break;
            }
            default: {
                Message.warn("Unsupported capability '" + name2 + "' on the bundle '" + bundleInfo.getSymbolicName() + "'");
            }
        }
    }

    private static ExportPackage getExportPackage(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String pkgName = null;
        Version version = null;
        String uses = null;
        block10: for (CapabilityProperty property2 : capability.getProperties()) {
            String propName;
            switch (propName = property2.getName()) {
                case "package": {
                    pkgName = property2.getValue();
                    continue block10;
                }
                case "uses": {
                    uses = property2.getValue();
                    continue block10;
                }
                case "version": {
                    version = new Version(property2.getValue());
                    continue block10;
                }
            }
            Message.warn("Unsupported property '" + propName + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (pkgName == null) {
            throw new ParseException("No package name for the capability", 0);
        }
        ExportPackage exportPackage = new ExportPackage(pkgName, version);
        if (uses != null) {
            for (String use2 : StringUtils.splitToArray(uses)) {
                exportPackage.addUse(use2);
            }
        }
        return exportPackage;
    }

    private static BundleCapability getOSGiService(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String name2 = null;
        Version version = null;
        block8: for (CapabilityProperty property2 : capability.getProperties()) {
            String propName;
            switch (propName = property2.getName()) {
                case "service": {
                    name2 = property2.getValue();
                    continue block8;
                }
                case "version": {
                    version = new Version(property2.getValue());
                    continue block8;
                }
            }
            Message.warn("Unsupported property '" + propName + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (name2 == null) {
            throw new ParseException("No service name for the capability", 0);
        }
        return new BundleCapability("service", name2, version);
    }
}

