/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationGroup;
import org.apache.ivy.core.module.descriptor.ConfigurationIntersection;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.util.Checks;

public class DefaultDependencyDescriptor
implements DependencyDescriptor {
    private static final Pattern SELF_FALLBACK_PATTERN = Pattern.compile("@(\\+[^\\(]+)?(\\(.*\\))?");
    private static final Pattern THIS_FALLBACK_PATTERN = Pattern.compile("#(\\+[^\\(]+)?(\\(.*\\))?");
    private final ModuleRevisionId revId;
    private ModuleRevisionId dynamicRevId;
    private Map<String, List<String>> confs = new LinkedHashMap<String, List<String>>();
    private Map<String, Collection<DependencyArtifactDescriptor>> dependencyArtifacts;
    private Map<String, Collection<IncludeRule>> includeRules;
    private Map<String, Collection<ExcludeRule>> excludeRules;
    private boolean isForce;
    private boolean isChanging;
    private ModuleRevisionId parentId;
    private boolean isTransitive = true;
    private Namespace namespace = null;
    private final ModuleDescriptor md;
    private DependencyDescriptor asSystem = this;
    private ModuleRevisionId sourceModule;

    public static DependencyDescriptor transformInstance(DependencyDescriptor dd, Namespace ns) {
        NamespaceTransformer t = ns.getToSystemTransformer();
        if (t.isIdentity()) {
            return dd;
        }
        DefaultDependencyDescriptor newdd = DefaultDependencyDescriptor.transformInstance(dd, t, false);
        newdd.namespace = ns;
        return newdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultDependencyDescriptor transformInstance(DependencyDescriptor dd, NamespaceTransformer t, boolean fromSystem) {
        String[] moduleConfs;
        ModuleRevisionId transformParentId = t.transform(dd.getParentRevisionId());
        ModuleRevisionId transformMrid = t.transform(dd.getDependencyRevisionId());
        ModuleRevisionId transformDynamicMrid = t.transform(dd.getDynamicConstraintDependencyRevisionId());
        DefaultDependencyDescriptor newdd = new DefaultDependencyDescriptor(null, transformMrid, transformDynamicMrid, dd.isForce(), dd.isChanging(), dd.isTransitive());
        newdd.parentId = transformParentId;
        ModuleRevisionId sourceModule = dd.getSourceModule();
        if (sourceModule != null) {
            newdd.sourceModule = t.transform(sourceModule);
        }
        if ((moduleConfs = dd.getModuleConfigurations()).length == 1 && "*".equals(moduleConfs[0])) {
            if (!(dd instanceof DefaultDependencyDescriptor)) throw new IllegalArgumentException("dependency descriptor transformation does not support * module confs with descriptors which aren't DefaultDependencyDescriptor");
            DefaultDependencyDescriptor ddd = (DefaultDependencyDescriptor)dd;
            newdd.confs = new LinkedHashMap<String, List<String>>(ddd.confs);
            newdd.setExcludeRules(new LinkedHashMap<String, Collection<ExcludeRule>>(ddd.getExcludeRules()));
            newdd.setIncludeRules(new LinkedHashMap<String, Collection<IncludeRule>>(ddd.getIncludeRules()));
            newdd.setDependencyArtifacts(new LinkedHashMap<String, Collection<DependencyArtifactDescriptor>>(ddd.getDependencyArtifacts()));
        } else {
            for (String moduleConf : moduleConfs) {
                newdd.confs.put(moduleConf, new ArrayList<String>(Arrays.asList(dd.getDependencyConfigurations(moduleConf))));
                newdd.getExcludeRules().put(moduleConf, new ArrayList<ExcludeRule>(Arrays.asList(dd.getExcludeRules(moduleConf))));
                newdd.getIncludeRules().put(moduleConf, new ArrayList<IncludeRule>(Arrays.asList(dd.getIncludeRules(moduleConf))));
                newdd.getDependencyArtifacts().put(moduleConf, new ArrayList<DependencyArtifactDescriptor>(Arrays.asList(dd.getDependencyArtifacts(moduleConf))));
            }
        }
        if (!fromSystem) return newdd;
        newdd.asSystem = dd;
        return newdd;
    }

    private DefaultDependencyDescriptor(DefaultDependencyDescriptor dd, ModuleRevisionId revision) {
        Checks.checkNotNull(dd, "dd");
        Checks.checkNotNull(revision, "revision");
        if (!revision.getModuleId().equals(dd.getDependencyId())) {
            throw new IllegalArgumentException("new ModuleRevisionId MUST have the same ModuleId as original one. original = " + dd.getDependencyId() + " new = " + revision.getModuleId());
        }
        this.md = dd.md;
        this.parentId = dd.parentId;
        this.revId = revision;
        this.dynamicRevId = dd.dynamicRevId;
        this.isForce = dd.isForce;
        this.isChanging = dd.isChanging;
        this.isTransitive = dd.isTransitive;
        this.namespace = dd.namespace;
        this.confs.putAll(dd.confs);
        this.excludeRules = dd.excludeRules == null ? null : new LinkedHashMap<String, Collection<ExcludeRule>>(dd.excludeRules);
        this.includeRules = dd.includeRules == null ? null : new LinkedHashMap<String, Collection<IncludeRule>>(dd.includeRules);
        this.dependencyArtifacts = dd.dependencyArtifacts == null ? null : new LinkedHashMap<String, Collection<DependencyArtifactDescriptor>>(dd.dependencyArtifacts);
        this.sourceModule = dd.sourceModule;
    }

    public DefaultDependencyDescriptor(ModuleDescriptor md, ModuleRevisionId mrid, boolean force, boolean changing, boolean transitive) {
        this(md, mrid, mrid, force, changing, transitive);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId mrid, boolean force) {
        this(mrid, force, false);
    }

    public DefaultDependencyDescriptor(ModuleRevisionId mrid, boolean force, boolean changing) {
        this(null, mrid, mrid, force, changing, true);
    }

    public DefaultDependencyDescriptor(ModuleDescriptor md, ModuleRevisionId mrid, ModuleRevisionId dynamicConstraint, boolean force, boolean changing, boolean transitive) {
        Checks.checkNotNull(mrid, "mrid");
        Checks.checkNotNull(dynamicConstraint, "dynamicConstraint");
        this.md = md;
        this.revId = mrid;
        this.dynamicRevId = dynamicConstraint;
        this.isForce = force;
        this.isChanging = changing;
        this.isTransitive = transitive;
        this.sourceModule = md == null ? null : md.getModuleRevisionId();
    }

    @Override
    public ModuleId getDependencyId() {
        return this.getDependencyRevisionId().getModuleId();
    }

    @Override
    public ModuleRevisionId getDependencyRevisionId() {
        return this.revId;
    }

    @Override
    public ModuleRevisionId getDynamicConstraintDependencyRevisionId() {
        return this.dynamicRevId;
    }

    @Override
    public String[] getModuleConfigurations() {
        return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
    }

    @Override
    public String[] getDependencyConfigurations(String moduleConfiguration) {
        return this.getDependencyConfigurations(moduleConfiguration, moduleConfiguration);
    }

    @Override
    public String[] getDependencyConfigurations(String moduleConfiguration, String requestedConfiguration) {
        List<String> confsList;
        if (this.md != null) {
            Configuration c = this.md.getConfiguration(moduleConfiguration);
            if (c instanceof ConfigurationIntersection) {
                List<String> defConfs;
                ConfigurationIntersection intersection = (ConfigurationIntersection)c;
                HashSet<String> intersectedDepConfs = new HashSet<String>();
                for (String intersect2 : intersection.getIntersectedConfigurationNames()) {
                    Collection<String> depConfs = this.getDependencyConfigurationsIncludingExtending(intersect2, requestedConfiguration);
                    if (intersectedDepConfs.isEmpty()) {
                        intersectedDepConfs.addAll(depConfs);
                        continue;
                    }
                    if (intersectedDepConfs.contains("*")) {
                        intersectedDepConfs.remove("*");
                        intersectedDepConfs.addAll(depConfs);
                        continue;
                    }
                    if (depConfs.contains("*")) continue;
                    HashSet<String> intersectedDepConfsCopy = intersectedDepConfs;
                    intersectedDepConfs = new HashSet();
                    for (String intersectedDepConf : intersectedDepConfsCopy) {
                        if (!depConfs.contains(intersectedDepConf)) continue;
                        intersectedDepConfs.add(intersectedDepConf);
                    }
                }
                List<String> confsList2 = this.confs.get(moduleConfiguration);
                if (confsList2 != null) {
                    intersectedDepConfs.addAll(confsList2);
                }
                if (intersectedDepConfs.isEmpty() && (defConfs = this.confs.get("*")) != null) {
                    for (String mappedConf : defConfs) {
                        if (mappedConf != null && mappedConf.startsWith("@+")) {
                            return new String[]{moduleConfiguration + mappedConf.substring(1)};
                        }
                        if (mappedConf == null || !mappedConf.equals("@")) continue;
                        return new String[]{moduleConfiguration};
                    }
                }
                return intersectedDepConfs.toArray(new String[intersectedDepConfs.size()]);
            }
            if (c instanceof ConfigurationGroup) {
                ConfigurationGroup group = (ConfigurationGroup)c;
                HashSet<String> groupDepConfs = new HashSet<String>();
                for (String member : group.getMembersConfigurationNames()) {
                    Collection<String> depConfs = this.getDependencyConfigurationsIncludingExtending(member, requestedConfiguration);
                    groupDepConfs.addAll(depConfs);
                }
                return groupDepConfs.toArray(new String[groupDepConfs.size()]);
            }
        }
        if ((confsList = this.confs.get(moduleConfiguration)) == null) {
            confsList = this.confs.get("%");
        }
        List<String> defConfs = this.confs.get("*");
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        if (confsList != null) {
            ret.addAll(confsList);
        }
        if (defConfs != null) {
            ret.addAll(defConfs);
            List<String> excludedConfs = this.confs.get("!" + moduleConfiguration);
            if (excludedConfs != null) {
                ret.removeAll(excludedConfs);
            }
        }
        LinkedHashSet<String> replacedRet = new LinkedHashSet<String>();
        for (String c : ret) {
            String replacedConf = DefaultDependencyDescriptor.replaceSelfFallbackPattern(c, moduleConfiguration);
            if (replacedConf == null) {
                replacedConf = DefaultDependencyDescriptor.replaceThisFallbackPattern(c, requestedConfiguration);
            }
            if (replacedConf != null) {
                c = replacedConf;
            }
            replacedRet.add(c);
        }
        ret = replacedRet;
        if (ret.remove("*")) {
            StringBuilder r = new StringBuilder("*");
            for (String c : ret) {
                if (!c.startsWith("!")) continue;
                r.append(c);
            }
            return new String[]{r.toString()};
        }
        return ret.toArray(new String[ret.size()]);
    }

    private Collection<String> getDependencyConfigurationsIncludingExtending(String conf, String requestedConfiguration) {
        LinkedHashSet<String> allDepConfs = new LinkedHashSet<String>(Arrays.asList(this.getDependencyConfigurations(conf, requestedConfiguration)));
        Collection<Configuration> extendingConfs = Configuration.findConfigurationExtending(conf, this.md.getConfigurations());
        for (Configuration extendingConf : extendingConfs) {
            allDepConfs.addAll(Arrays.asList(this.getDependencyConfigurations(extendingConf.getName(), requestedConfiguration)));
        }
        return allDepConfs;
    }

    protected static String replaceSelfFallbackPattern(String conf, String moduleConfiguration) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(SELF_FALLBACK_PATTERN, conf, moduleConfiguration);
    }

    protected static String replaceThisFallbackPattern(String conf, String requestedConfiguration) {
        return DefaultDependencyDescriptor.replaceFallbackConfigurationPattern(THIS_FALLBACK_PATTERN, conf, requestedConfiguration);
    }

    protected static String replaceFallbackConfigurationPattern(Pattern pattern2, String conf, String moduleConfiguration) {
        Matcher matcher2 = pattern2.matcher(conf);
        if (matcher2.matches()) {
            String mappedConf = moduleConfiguration;
            if (matcher2.group(1) != null) {
                mappedConf = mappedConf + matcher2.group(1);
            }
            if (matcher2.group(2) != null) {
                mappedConf = mappedConf + matcher2.group(2);
            }
            return mappedConf;
        }
        return null;
    }

    @Override
    public String[] getDependencyConfigurations(String[] moduleConfigurations) {
        LinkedHashSet<String> confs = new LinkedHashSet<String>();
        for (String moduleConfiguration : moduleConfigurations) {
            confs.addAll(Arrays.asList(this.getDependencyConfigurations(moduleConfiguration)));
        }
        if (confs.contains("*")) {
            return new String[]{"*"};
        }
        return confs.toArray(new String[confs.size()]);
    }

    @Override
    public DependencyArtifactDescriptor[] getDependencyArtifacts(String moduleConfiguration) {
        Set<DependencyArtifactDescriptor> artifacts = this.getCollectionForConfiguration(moduleConfiguration, this.dependencyArtifacts);
        return artifacts.toArray(new DependencyArtifactDescriptor[artifacts.size()]);
    }

    @Override
    public IncludeRule[] getIncludeRules(String moduleConfiguration) {
        Set<IncludeRule> rules = this.getCollectionForConfiguration(moduleConfiguration, this.includeRules);
        return rules.toArray(new IncludeRule[rules.size()]);
    }

    @Override
    public ExcludeRule[] getExcludeRules(String moduleConfiguration) {
        Set<ExcludeRule> rules = this.getCollectionForConfiguration(moduleConfiguration, this.excludeRules);
        return rules.toArray(new ExcludeRule[rules.size()]);
    }

    private <T> Set<T> getCollectionForConfiguration(String moduleConfiguration, Map<String, Collection<T>> collectionMap) {
        if (collectionMap == null || collectionMap.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<T> artifacts = collectionMap.get(moduleConfiguration);
        Collection<T> defArtifacts = collectionMap.get("*");
        LinkedHashSet<T> ret = new LinkedHashSet<T>();
        if (artifacts != null) {
            ret.addAll(artifacts);
        }
        if (defArtifacts != null) {
            ret.addAll(defArtifacts);
        }
        return ret;
    }

    @Override
    public DependencyArtifactDescriptor[] getDependencyArtifacts(String[] moduleConfigurations) {
        LinkedHashSet<DependencyArtifactDescriptor> artifacts = new LinkedHashSet<DependencyArtifactDescriptor>();
        for (String moduleConfiguration : moduleConfigurations) {
            artifacts.addAll(Arrays.asList(this.getDependencyArtifacts(moduleConfiguration)));
        }
        return artifacts.toArray(new DependencyArtifactDescriptor[artifacts.size()]);
    }

    @Override
    public IncludeRule[] getIncludeRules(String[] moduleConfigurations) {
        LinkedHashSet<IncludeRule> rules = new LinkedHashSet<IncludeRule>();
        for (String moduleConfiguration : moduleConfigurations) {
            rules.addAll(Arrays.asList(this.getIncludeRules(moduleConfiguration)));
        }
        return rules.toArray(new IncludeRule[rules.size()]);
    }

    @Override
    public ExcludeRule[] getExcludeRules(String[] moduleConfigurations) {
        LinkedHashSet<ExcludeRule> rules = new LinkedHashSet<ExcludeRule>();
        for (String moduleConfiguration : moduleConfigurations) {
            rules.addAll(Arrays.asList(this.getExcludeRules(moduleConfiguration)));
        }
        return rules.toArray(new ExcludeRule[rules.size()]);
    }

    @Override
    public DependencyArtifactDescriptor[] getAllDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            return new DependencyArtifactDescriptor[0];
        }
        Set<DependencyArtifactDescriptor> ret = this.mergeAll(this.dependencyArtifacts);
        return ret.toArray(new DependencyArtifactDescriptor[ret.size()]);
    }

    @Override
    public IncludeRule[] getAllIncludeRules() {
        if (this.includeRules == null) {
            return new IncludeRule[0];
        }
        Set<IncludeRule> ret = this.mergeAll(this.includeRules);
        return ret.toArray(new IncludeRule[ret.size()]);
    }

    @Override
    public ExcludeRule[] getAllExcludeRules() {
        if (this.excludeRules == null) {
            return new ExcludeRule[0];
        }
        Set<ExcludeRule> ret = this.mergeAll(this.excludeRules);
        return ret.toArray(new ExcludeRule[ret.size()]);
    }

    private <T> Set<T> mergeAll(Map<String, Collection<T>> artifactsMap) {
        LinkedHashSet<T> ret = new LinkedHashSet<T>();
        for (Collection<T> artifacts : artifactsMap.values()) {
            ret.addAll(artifacts);
        }
        return ret;
    }

    public void addDependencyConfiguration(String masterConf, String depConf) {
        List<String> confsList;
        if (this.md != null && !"*".equals(masterConf) && !"%".equals(masterConf)) {
            Configuration config2 = masterConf.startsWith("!") ? this.md.getConfiguration(masterConf.substring(1)) : this.md.getConfiguration(masterConf);
            if (config2 == null) {
                throw new IllegalArgumentException("Cannot add dependency '" + this.revId + "' to configuration '" + masterConf + "' of module " + this.md.getModuleRevisionId() + " because this configuration doesn't exist!");
            }
            if (config2 instanceof ConfigurationGroup) {
                ConfigurationGroup group = (ConfigurationGroup)config2;
                for (String member : group.getMembersConfigurationNames()) {
                    this.addDependencyConfiguration(member, depConf);
                }
                return;
            }
        }
        if ((confsList = this.confs.get(masterConf)) == null) {
            confsList = new ArrayList<String>();
            this.confs.put(masterConf, confsList);
        }
        if (!confsList.contains(depConf)) {
            confsList.add(depConf);
        }
    }

    public void addDependencyArtifact(String masterConf, DependencyArtifactDescriptor dad) {
        this.addObjectToConfiguration(masterConf, dad, this.getDependencyArtifacts());
    }

    public void addIncludeRule(String masterConf, IncludeRule rule) {
        this.addObjectToConfiguration(masterConf, rule, this.getIncludeRules());
    }

    public void addExcludeRule(String masterConf, ExcludeRule rule) {
        this.addObjectToConfiguration(masterConf, rule, this.getExcludeRules());
    }

    private <T> void addObjectToConfiguration(String callerConf, T toAdd, Map<String, Collection<T>> confsMap) {
        Collection<T> col = confsMap.get(callerConf);
        if (col == null) {
            col = new ArrayList<T>();
            confsMap.put(callerConf, col);
        }
        col.add(toAdd);
    }

    @Override
    public boolean doesExclude(String[] moduleConfigurations, ArtifactId artifactId) {
        if (this.namespace != null) {
            artifactId = NameSpaceHelper.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        for (ExcludeRule rule : this.getExcludeRules(moduleConfigurations)) {
            if (!MatcherHelper.matches(rule.getMatcher(), rule.getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canExclude() {
        return this.excludeRules != null && !this.excludeRules.isEmpty();
    }

    public String toString() {
        return "dependency: " + this.revId + " " + this.confs;
    }

    @Override
    public boolean isForce() {
        return this.isForce;
    }

    @Override
    public ModuleRevisionId getParentRevisionId() {
        return this.md != null ? this.md.getResolvedModuleRevisionId() : this.parentId;
    }

    @Override
    public boolean isChanging() {
        return this.isChanging;
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String getAttribute(String attName) {
        return this.revId.getAttribute(attName);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.revId.getAttributes();
    }

    @Override
    public String getExtraAttribute(String attName) {
        return this.revId.getExtraAttribute(attName);
    }

    @Override
    public Map<String, String> getExtraAttributes() {
        return this.revId.getExtraAttributes();
    }

    @Override
    public Map<String, String> getQualifiedExtraAttributes() {
        return this.revId.getQualifiedExtraAttributes();
    }

    @Override
    public DependencyDescriptor asSystem() {
        return this.asSystem;
    }

    private void setDependencyArtifacts(Map<String, Collection<DependencyArtifactDescriptor>> dependencyArtifacts) {
        this.dependencyArtifacts = dependencyArtifacts;
    }

    private Map<String, Collection<DependencyArtifactDescriptor>> getDependencyArtifacts() {
        if (this.dependencyArtifacts == null) {
            this.dependencyArtifacts = new LinkedHashMap<String, Collection<DependencyArtifactDescriptor>>();
        }
        return this.dependencyArtifacts;
    }

    private void setIncludeRules(Map<String, Collection<IncludeRule>> includeRules) {
        this.includeRules = includeRules;
    }

    private Map<String, Collection<IncludeRule>> getIncludeRules() {
        if (this.includeRules == null) {
            this.includeRules = new LinkedHashMap<String, Collection<IncludeRule>>();
        }
        return this.includeRules;
    }

    private void setExcludeRules(Map<String, Collection<ExcludeRule>> excludeRules) {
        this.excludeRules = excludeRules;
    }

    private Map<String, Collection<ExcludeRule>> getExcludeRules() {
        if (this.excludeRules == null) {
            this.excludeRules = new LinkedHashMap<String, Collection<ExcludeRule>>();
        }
        return this.excludeRules;
    }

    @Override
    public ModuleRevisionId getSourceModule() {
        return this.sourceModule;
    }

    @Override
    public DependencyDescriptor clone(ModuleRevisionId revision) {
        return new DefaultDependencyDescriptor(this, revision);
    }
}

