/*
 * Decompiled with CFR 0.152.
 */
package libraries.io;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import libraries.io.CommonFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0004\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0010J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\u001d\u001a\u00020\u0004H\u0016J5\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010 \u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0$\u0012\u0004\u0012\u0002H\u001f0#H\u0002\u00a2\u0006\u0002\u0010%R\u0011\u0010\f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0016\u0010\t\u001a\n \u0015*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Llibraries/io/CommonFile;", "", "parent", "child", "", "(Llibraries/io/CommonFile;Ljava/lang/String;)V", "children", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "isDirectory", "", "()Z", "isEmpty", "name", "getName", "kotlin.jvm.PlatformType", "exists", "listFiles", "", "mkdirs", "", "toRelativeUnixPath", "base", "toString", "withFiles", "T", "maxDepth", "", "body", "Lkotlin/Function1;", "Lkotlin/sequences/Sequence;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "libraries-io"})
public final class CommonFile {
    private final Path path;

    public CommonFile(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.path = path2.toAbsolutePath();
    }

    public CommonFile(@NotNull CommonFile parent, @NotNull String child) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path path2 = parent.path.resolve(child);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this(path2);
    }

    public CommonFile(@NotNull String parent, String ... children2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)children2, (String)"children");
        Path path2 = Paths.get(parent, Arrays.copyOf(children2, children2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        this(path2);
    }

    @NotNull
    public final String getAbsolutePath() {
        return ((Object)this.path).toString();
    }

    public final boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    public final boolean isEmpty() {
        return (Boolean)this.withFiles(1, isEmpty.1.INSTANCE);
    }

    @NotNull
    public final String getName() {
        return ((Object)this.path.getFileName()).toString();
    }

    public final boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @NotNull
    public final String toRelativeUnixPath(@NotNull CommonFile base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        File file2 = this.path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        File file3 = base.path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
        return StringsKt.replace$default((String)FilesKt.toRelativeString((File)file2, (File)file3), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    public final void mkdirs() {
        Files.createDirectories(this.path, new FileAttribute[0]);
    }

    @NotNull
    public final Iterable<CommonFile> listFiles() {
        return (Iterable)this.withFiles(1, listFiles.1.INSTANCE);
    }

    @NotNull
    public String toString() {
        return this.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withFiles(int maxDepth, Function1<? super Sequence<? extends Path>, ? extends T> body) {
        Object object;
        AutoCloseable autoCloseable = Files.walk(this.path, maxDepth, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            object = body.invoke((Object)StreamsKt.asSequence((Stream)stream));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (T)object;
    }
}

