/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import libraries.collections.RangeUnionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B-\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u001b\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0086\u0002J\u0013\u0010\u001a\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u0014\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\u0014\u0010 \u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\nJ\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00028\u00002\u0006\u0010\"\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010#J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0002J\b\u0010&\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\nR\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Llibraries/collections/RangeUnion;", "T", "", "", "nextUp", "Lkotlin/Function1;", "nextDown", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "intersectionComparator", "Ljava/util/Comparator;", "Lkotlin/ranges/ClosedRange;", "myRanges", "", "ranges", "", "getRanges", "()Ljava/util/List;", "clear", "", "containingRange", "element", "(Ljava/lang/Comparable;)Lkotlin/ranges/ClosedRange;", "contains", "", "other", "(Ljava/lang/Comparable;)Z", "equals", "exclude", "range", "hashCode", "", "intersection", "intersects", "nextDownOrMin", "x", "(Ljava/lang/Comparable;)Ljava/lang/Comparable;", "nextUpOrMax", "toInsertPosition", "toString", "", "union", "libraries-collections"})
@SourceDebugExtension(value={"SMAP\nRangeUnion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RangeUnion.kt\nlibraries/collections/RangeUnion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public class RangeUnion<T extends Comparable<? super T>> {
    @NotNull
    private final Function1<T, T> nextUp;
    @NotNull
    private final Function1<T, T> nextDown;
    @NotNull
    private final List<ClosedRange<T>> myRanges;
    @NotNull
    private final List<ClosedRange<T>> ranges;
    @NotNull
    private final Comparator<ClosedRange<T>> intersectionComparator;

    public RangeUnion(@NotNull Function1<? super T, ? extends T> nextUp2, @NotNull Function1<? super T, ? extends T> nextDown2) {
        Intrinsics.checkNotNullParameter(nextUp2, (String)"nextUp");
        Intrinsics.checkNotNullParameter(nextDown2, (String)"nextDown");
        this.nextUp = nextUp2;
        this.nextDown = nextDown2;
        this.myRanges = new ArrayList();
        this.ranges = this.myRanges;
        this.intersectionComparator = RangeUnion::intersectionComparator$lambda$0;
    }

    @NotNull
    public List<ClosedRange<T>> getRanges() {
        return this.ranges;
    }

    private final T nextDownOrMin(T x) {
        Comparable nextDown2 = (Comparable)this.nextDown.invoke(x);
        return (T)(nextDown2.compareTo(x) < 0 ? nextDown2 : x);
    }

    private final T nextUpOrMax(T x) {
        Comparable nextUp2 = (Comparable)this.nextUp.invoke(x);
        return (T)(nextUp2.compareTo(x) > 0 ? nextUp2 : x);
    }

    public final void clear() {
        this.myRanges.clear();
    }

    public final boolean contains(@NotNull ClosedRange<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.isEmpty()) {
            return true;
        }
        int startPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)RangesKt.rangeTo(RangeUnionKt.getFirst(other), RangeUnionKt.getFirst(other)), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        int endPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)RangesKt.rangeTo(RangeUnionKt.getLast(other), RangeUnionKt.getLast(other)), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        return startPos >= 0 && startPos == endPos;
    }

    public final boolean contains(@NotNull T other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this.contains((T)RangesKt.rangeTo(other, other));
    }

    public final void exclude(@NotNull ClosedRange<T> range3) {
        Intrinsics.checkNotNullParameter(range3, (String)"range");
        if (range3.isEmpty()) {
            return;
        }
        int startPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)RangesKt.rangeTo(RangeUnionKt.getFirst(range3), RangeUnionKt.getFirst(range3)), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        int endPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)RangesKt.rangeTo(RangeUnionKt.getLast(range3), RangeUnionKt.getLast(range3)), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        int lastTouched = endPos < 0 ? this.toInsertPosition(endPos) - 1 : endPos;
        List<ClosedRange<T>> toEdit = this.myRanges.subList(this.toInsertPosition(startPos), lastTouched + 1);
        if (!((Collection)toEdit).isEmpty()) {
            T oldStart = RangeUnionKt.getFirst(toEdit.get(0));
            T oldEnd = RangeUnionKt.getLast((ClosedRange)CollectionsKt.last(toEdit));
            toEdit.clear();
            if (oldStart.compareTo(RangeUnionKt.getFirst(range3)) < 0) {
                toEdit.add(RangesKt.rangeTo(oldStart, (Comparable)((Comparable)this.nextDown.invoke(RangeUnionKt.getFirst(range3)))));
            }
            if (oldEnd.compareTo(RangeUnionKt.getLast(range3)) > 0) {
                toEdit.add(RangesKt.rangeTo((Comparable)((Comparable)this.nextUp.invoke(RangeUnionKt.getLast(range3))), oldEnd));
            }
        }
    }

    @NotNull
    public final List<ClosedRange<T>> intersection(@NotNull ClosedRange<T> range3) {
        Intrinsics.checkNotNullParameter(range3, (String)"range");
        List ret = new ArrayList();
        for (ClosedRange<T> x : this.myRanges) {
            ClosedRange<T> intersection = RangeUnionKt.intersectWith(x, range3);
            if (intersection.isEmpty()) continue;
            ret.add(intersection);
        }
        return ret;
    }

    @Nullable
    public final ClosedRange<T> containingRange(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        int ind = CollectionsKt.binarySearch$default(this.myRanges, (Object)RangesKt.rangeTo(element, element), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        return ind >= 0 ? this.myRanges.get(ind) : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void union(@NotNull ClosedRange<T> range3) {
        void it;
        void it2;
        Intrinsics.checkNotNullParameter(range3, (String)"range");
        if (range3.isEmpty()) {
            return;
        }
        T t = this.nextDownOrMin(RangeUnionKt.getFirst(range3));
        List<ClosedRange<T>> list2 = this.myRanges;
        boolean $i$a$-let-RangeUnion$union$startPos$22 = false;
        int startPos = CollectionsKt.binarySearch$default(list2, (Object)RangesKt.rangeTo((Comparable)it2, (Comparable)it2), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        T $i$a$-let-RangeUnion$union$startPos$22 = this.nextUpOrMax(RangeUnionKt.getLast(range3));
        list2 = this.myRanges;
        boolean bl = false;
        int endPos = CollectionsKt.binarySearch$default(list2, (Object)RangesKt.rangeTo((Comparable)it, (Comparable)it), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        int lastTouched = endPos < 0 ? this.toInsertPosition(endPos) - 1 : endPos;
        List<ClosedRange<T>> toEdit = this.myRanges.subList(this.toInsertPosition(startPos), lastTouched + 1);
        if (!((Collection)toEdit).isEmpty()) {
            T oldStart = RangeUnionKt.getFirst(toEdit.get(0));
            Object oldEnd = RangeUnionKt.getLast((ClosedRange)CollectionsKt.last(toEdit));
            toEdit.clear();
            toEdit.add(RangesKt.rangeTo((Comparable)ComparisonsKt.minOf(oldStart, RangeUnionKt.getFirst(range3)), (Comparable)ComparisonsKt.maxOf(oldEnd, RangeUnionKt.getLast(range3))));
        } else {
            toEdit.add(range3);
        }
    }

    public final boolean intersects(@NotNull ClosedRange<T> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.isEmpty()) {
            return false;
        }
        int startPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)RangesKt.rangeTo(RangeUnionKt.getFirst(other), RangeUnionKt.getFirst(other)), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        int endPos = CollectionsKt.binarySearch$default(this.myRanges, (Object)RangesKt.rangeTo(RangeUnionKt.getLast(other), RangeUnionKt.getLast(other)), this.intersectionComparator, (int)0, (int)0, (int)12, null);
        return startPos >= 0 || endPos >= 0 || this.toInsertPosition(endPos) - this.toInsertPosition(startPos) > 0;
    }

    @NotNull
    public String toString() {
        return "ClosedIntRanges" + CollectionsKt.joinToString$default((Iterable)this.myRanges, (CharSequence)",", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)56, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof RangeUnion && Intrinsics.areEqual(this.myRanges, ((RangeUnion)other).myRanges);
    }

    public int hashCode() {
        return ((Object)this.myRanges).hashCode();
    }

    private final int toInsertPosition(int x) {
        return x < 0 ? -x - 1 : x;
    }

    private static final int intersectionComparator$lambda$0(ClosedRange a, ClosedRange b) {
        Intrinsics.checkNotNull((Object)a);
        Intrinsics.checkNotNull((Object)b);
        return RangeUnionKt.intersects(a, b) ? 0 : RangeUnionKt.getFirst(a).compareTo(RangeUnionKt.getFirst(b));
    }
}

