/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review;

import circlet.client.api.TD_MemberProfile;
import circlet.workspaces.Workspace;
import com.intellij.collaboration.ui.toolwindow.ReviewTabsComponentFactory;
import com.intellij.openapi.project.Project;
import com.intellij.space.stats.SpaceClientStats;
import com.intellij.space.stats.SpaceClientStatsKt;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.utils.UtilitiesKt;
import com.intellij.space.vcs.review.SpaceReviewToolwindowEmptyComponent;
import com.intellij.space.vcs.review.create.SpaceCreateCodeReviewComponent;
import com.intellij.space.vcs.review.create.SpaceCreateMergeRequestComponent;
import com.intellij.space.vcs.review.create.patch.SpaceCreateMergeRequestFromChangesComponent;
import com.intellij.space.vcs.review.details.SpaceReviewDetailsPanelFactory;
import com.intellij.space.vcs.review.list.SpaceReviewListFactory;
import com.intellij.space.vcs.review.list.filters.SpaceReviewListFiltersPanelFactory;
import com.intellij.space.vcs.review.list.filters.SpaceReviewListQuickFilter;
import com.intellij.space.vcs.review.toolwindow.SpaceReviewTabViewModel;
import com.intellij.space.vcs.review.toolwindow.SpaceReviewToolWindowProjectViewModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.Property;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0003H\u0016J \u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory;", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTabsComponentFactory;", "Lcom/intellij/space/vcs/review/toolwindow/SpaceReviewTabViewModel;", "Lcom/intellij/space/vcs/review/toolwindow/SpaceReviewToolWindowProjectViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createEmptyTabContent", "Ljavax/swing/JComponent;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "createReviewListComponent", "projectVm", "createTabComponent", "tabVm", "onQuickReviewChange", "", "filter", "Lcom/intellij/space/vcs/review/list/filters/SpaceReviewListQuickFilter;", "intellij.space.vcs"})
public final class SpaceReviewTabComponentFactory
implements ReviewTabsComponentFactory<SpaceReviewTabViewModel, SpaceReviewToolWindowProjectViewModel> {
    @NotNull
    private final Project project;

    public SpaceReviewTabComponentFactory(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @NotNull
    public JComponent createEmptyTabContent(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        return new SpaceReviewToolwindowEmptyComponent(this.project, UtilitiesKt.nestedLifetime(cs));
    }

    @NotNull
    public JComponent createReviewListComponent(@NotNull CoroutineScope cs, @NotNull SpaceReviewToolWindowProjectViewModel projectVm2) {
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)projectVm2, (String)"projectVm");
        LifetimeSource tabLifetime = UtilitiesKt.nestedLifetime(cs);
        BorderLayoutPanel $this$createReviewListComponent_u24lambda_u240 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        JComponent filtersComponent2 = new SpaceReviewListFiltersPanelFactory(projectVm2.getListVm().getFiltersVm()).create(UtilitiesKt.coroutineScope$default(tabLifetime, null, 1, null), (Function1)new Function1<SpaceReviewListQuickFilter, Unit>(this, projectVm2){
            final /* synthetic */ SpaceReviewTabComponentFactory this$0;
            final /* synthetic */ SpaceReviewToolWindowProjectViewModel $projectVm;
            {
                this.this$0 = $receiver;
                this.$projectVm = $projectVm;
                super(1);
            }

            public final void invoke(@NotNull SpaceReviewListQuickFilter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SpaceReviewTabComponentFactory.access$onQuickReviewChange(this.this$0, it, this.$projectVm);
            }
        });
        JComponent reviewsList2 = SpaceReviewListFactory.INSTANCE.create(tabLifetime, projectVm2.getListVm());
        $this$createReviewListComponent_u24lambda_u240.addToTop((Component)filtersComponent2);
        $this$createReviewListComponent_u24lambda_u240.addToCenter((Component)reviewsList2);
        return (JComponent)borderLayoutPanel;
    }

    @NotNull
    public JComponent createTabComponent(@NotNull CoroutineScope cs, @NotNull SpaceReviewToolWindowProjectViewModel projectVm2, @NotNull SpaceReviewTabViewModel tabVm) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)projectVm2, (String)"projectVm");
        Intrinsics.checkNotNullParameter((Object)tabVm, (String)"tabVm");
        LifetimeSource tabLifetime = UtilitiesKt.nestedLifetime(cs);
        Workspace workspace2 = projectVm2.getWorkspace();
        SpaceReviewTabViewModel spaceReviewTabViewModel = tabVm;
        if (spaceReviewTabViewModel instanceof SpaceReviewTabViewModel.ReviewSelected) {
            jComponent = SpaceReviewDetailsPanelFactory.INSTANCE.create$intellij_space_vcs(this.project, cs, ((SpaceReviewTabViewModel.ReviewSelected)tabVm).getDetailsVm());
        } else if (spaceReviewTabViewModel instanceof SpaceReviewTabViewModel.CreateCommitSetReview) {
            jComponent = new SpaceCreateCodeReviewComponent(tabLifetime, projectVm2, ((SpaceReviewTabViewModel.CreateCommitSetReview)tabVm).getReviewVm()).getView();
        } else if (spaceReviewTabViewModel instanceof SpaceReviewTabViewModel.CreateMergeRequest) {
            jComponent = new SpaceCreateMergeRequestComponent(tabLifetime, projectVm2, (Property<TD_MemberProfile>)workspace2.getMe(), ((SpaceReviewTabViewModel.CreateMergeRequest)tabVm).getMergeRequestVm()).getView();
        } else if (spaceReviewTabViewModel instanceof SpaceReviewTabViewModel.CreateMergeRequestFromChanges) {
            jComponent = new SpaceCreateMergeRequestFromChangesComponent(cs, projectVm2, (Property<TD_MemberProfile>)workspace2.getMe(), ((SpaceReviewTabViewModel.CreateMergeRequestFromChanges)tabVm).getMergeRequestVm()).getView();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JComponent openedComponent = jComponent;
        return openedComponent;
    }

    private final void onQuickReviewChange(SpaceReviewListQuickFilter filter2, SpaceReviewToolWindowProjectViewModel projectVm2) {
        SpaceStatsCounterCollector.ReviewListQuickFilterType reviewListQuickFilterType;
        SpaceReviewListQuickFilter spaceReviewListQuickFilter = filter2;
        if (spaceReviewListQuickFilter instanceof SpaceReviewListQuickFilter.Open) {
            reviewListQuickFilterType = SpaceStatsCounterCollector.ReviewListQuickFilterType.OPEN;
        } else if (spaceReviewListQuickFilter instanceof SpaceReviewListQuickFilter.IncludesMyChanges) {
            reviewListQuickFilterType = SpaceStatsCounterCollector.ReviewListQuickFilterType.AUTHORED_BY_ME;
        } else if (spaceReviewListQuickFilter instanceof SpaceReviewListQuickFilter.NeedsMyAttention) {
            reviewListQuickFilterType = SpaceStatsCounterCollector.ReviewListQuickFilterType.NEEDS_MY_ATTENTION;
        } else if (spaceReviewListQuickFilter instanceof SpaceReviewListQuickFilter.NeedsMyReview) {
            reviewListQuickFilterType = SpaceStatsCounterCollector.ReviewListQuickFilterType.NEEDS_MY_REVIEW;
        } else if (spaceReviewListQuickFilter instanceof SpaceReviewListQuickFilter.AssignedToMe) {
            reviewListQuickFilterType = SpaceStatsCounterCollector.ReviewListQuickFilterType.ASSIGNED_TO_ME;
        } else if (spaceReviewListQuickFilter instanceof SpaceReviewListQuickFilter.Closed) {
            reviewListQuickFilterType = SpaceStatsCounterCollector.ReviewListQuickFilterType.CLOSED;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        SpaceStatsCounterCollector.ReviewListQuickFilterType filterType = reviewListQuickFilterType;
        SpaceClientStats.reportReviewListChangeQuickFilter-impl(SpaceClientStatsKt.getStats(projectVm2.getWorkspace().getClient()), projectVm2.getProjectInfo().getSpaceProject().getProject().getId(), filterType);
    }

    public static final /* synthetic */ void access$onQuickReviewChange(SpaceReviewTabComponentFactory $this, SpaceReviewListQuickFilter filter2, SpaceReviewToolWindowProjectViewModel projectVm2) {
        $this.onQuickReviewChange(filter2, projectVm2);
    }
}

