/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.diff;

import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.space.vcs.changes.SpaceChange;
import com.intellij.space.vcs.changes.SpaceChangeKt;
import com.intellij.space.vcs.diff.load.DiffData;
import com.intellij.space.vcs.diff.load.SpaceReviewDiffLoader;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0004J\r\u0010\u0017\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0018H\u0004J\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/space/vcs/diff/SpaceSimpleDiffRequestProducer;", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "commitHashes", "", "", "spaceChange", "Lcom/intellij/space/vcs/changes/SpaceChange;", "diffLoader", "Lcom/intellij/space/vcs/diff/load/SpaceReviewDiffLoader;", "(Ljava/util/List;Lcom/intellij/space/vcs/changes/SpaceChange;Lcom/intellij/space/vcs/diff/load/SpaceReviewDiffLoader;)V", "getCommitHashes", "()Ljava/util/List;", "getSpaceChange", "()Lcom/intellij/space/vcs/changes/SpaceChange;", "createSpaceDiffRequest", "Lcom/intellij/diff/requests/DiffRequest;", "diffData", "Lcom/intellij/space/vcs/diff/load/DiffData;", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getName", "getRequestTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "process", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.space.vcs"})
public class SpaceSimpleDiffRequestProducer
implements ChangeDiffRequestChain.Producer {
    @NotNull
    private final List<String> commitHashes;
    @NotNull
    private final SpaceChange spaceChange;
    @NotNull
    private final SpaceReviewDiffLoader diffLoader;

    public SpaceSimpleDiffRequestProducer(@NotNull List<String> commitHashes2, @NotNull SpaceChange spaceChange, @NotNull SpaceReviewDiffLoader diffLoader) {
        Intrinsics.checkNotNullParameter(commitHashes2, (String)"commitHashes");
        Intrinsics.checkNotNullParameter((Object)spaceChange, (String)"spaceChange");
        Intrinsics.checkNotNullParameter((Object)diffLoader, (String)"diffLoader");
        this.commitHashes = commitHashes2;
        this.spaceChange = spaceChange;
        this.diffLoader = diffLoader;
    }

    @NotNull
    protected final List<String> getCommitHashes() {
        return this.commitHashes;
    }

    @NotNull
    protected final SpaceChange getSpaceChange() {
        return this.spaceChange;
    }

    @NotNull
    public final FilePath getFilePath() {
        return SpaceChangeKt.getRelativePath(this.spaceChange);
    }

    @NotNull
    public final FileStatus getFileStatus() {
        return this.spaceChange.getFileStatus();
    }

    @NotNull
    public final String getName() {
        String string2 = SpaceChangeKt.getRelativePath(this.spaceChange).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        return string2;
    }

    @NotNull
    public final DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return !((Collection)this.commitHashes).isEmpty() ? this.createSpaceDiffRequest(this.diffLoader.loadDiffData(this.spaceChange, this.commitHashes)) : (DiffRequest)new LoadingDiffRequest("");
    }

    @NotNull
    public DiffRequest createSpaceDiffRequest(@NotNull DiffData diffData) {
        Intrinsics.checkNotNullParameter((Object)diffData, (String)"diffData");
        return (DiffRequest)new SimpleDiffRequest(this.getRequestTitle(), diffData.getContents(), diffData.getTitles());
    }

    @NotNull
    protected final String getRequestTitle() {
        String string2 = DiffRequestFactoryImpl.getTitle((FilePath)this.spaceChange.getOldFilePath(), (FilePath)this.spaceChange.getNewFilePath(), (String)" -> ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTitle(...)");
        return string2;
    }
}

