/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.clone;

import com.intellij.dvcs.DvcsRememberedInputs;
import com.intellij.dvcs.repo.ClonePathProvider;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.space.settings.CloneType;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.vcs.clone.SpaceCloneComponentKt;
import com.intellij.space.vcs.messages.SpaceVcsBundle;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.containers.ContainerUtil;
import git4idea.checkout.GitCheckoutListener;
import git4idea.remote.GitRememberedInputs;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0005H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/space/vcs/clone/SpaceCloneRepositoryDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "cloneUrls", "", "", "checkoutListener", "Lgit4idea/checkout/GitCheckoutListener;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lgit4idea/checkout/GitCheckoutListener;)V", "cloneUrl", "createDirectoryError", "Lcom/intellij/openapi/ui/ValidationInfo;", "directoryField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "repositoryDirectoryName", "settings", "Lcom/intellij/space/settings/SpaceSettings;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "doValidateAll", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceCloneRepositoryDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceCloneRepositoryDialog.kt\ncom/intellij/space/vcs/clone/SpaceCloneRepositoryDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n288#2,2:110\n*S KotlinDebug\n*F\n+ 1 SpaceCloneRepositoryDialog.kt\ncom/intellij/space/vcs/clone/SpaceCloneRepositoryDialog\n*L\n39#1:110,2\n*E\n"})
public final class SpaceCloneRepositoryDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final GitCheckoutListener checkoutListener;
    @NotNull
    private final TextFieldWithBrowseButton directoryField;
    @Nullable
    private ValidationInfo createDirectoryError;
    @NotNull
    private final SpaceSettings settings;
    @NotNull
    private final String cloneUrl;
    @NotNull
    private final String repositoryDirectoryName;

    /*
     * WARNING - void declaration
     */
    public SpaceCloneRepositoryDialog(@NotNull Project project2, @NotNull List<String> cloneUrls, @NotNull GitCheckoutListener checkoutListener) {
        String string2;
        Object v1;
        block6: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(cloneUrls, (String)"cloneUrls");
            Intrinsics.checkNotNullParameter((Object)checkoutListener, (String)"checkoutListener");
            super(true);
            this.project = project2;
            this.checkoutListener = checkoutListener;
            this.directoryField = new TextFieldWithBrowseButton();
            this.settings = SpaceSettings.Companion.getInstance();
            Iterable iterable = cloneUrls;
            SpaceCloneRepositoryDialog spaceCloneRepositoryDialog = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(switch (WhenMappings.$EnumSwitchMapping$0[this.settings.getCloneType().ordinal()]) {
                    case 1 -> StringsKt.startsWith$default((String)it, (String)"ssh", (boolean)false, (int)2, null);
                    case 2 -> StringsKt.startsWith$default((String)it, (String)"http", (boolean)false, (int)2, null);
                    default -> throw new NoWhenBranchMatchedException();
                })) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        if ((string2 = (String)v1) == null) {
            string2 = (String)CollectionsKt.first(cloneUrls);
        }
        spaceCloneRepositoryDialog.cloneUrl = string2;
        String string3 = ClonePathProvider.relativeDirectoryPathForVcsUrl((Project)this.project, (String)this.cloneUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"relativeDirectoryPathForVcsUrl(...)");
        this.repositoryDirectoryName = StringsKt.removeSuffix((String)string3, (CharSequence)".git");
        this.init();
        Object[] objectArray = new Object[]{this.repositoryDirectoryName};
        this.setTitle(SpaceVcsBundle.message("action.clone.space.repository.dialog.title", objectArray));
        this.setOKButtonText(VcsBundle.message((String)"clone.dialog.clone.button", (Object[])new Object[0]));
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setHideIgnored(false);
        this.directoryField.addBrowseFolderListener(DvcsBundle.message((String)"clone.destination.directory.browser.title", (Object[])new Object[0]), DvcsBundle.message((String)"clone.destination.directory.browser.description", (Object[])new Object[0]), this.project, fcd);
        this.directoryField.setTextFieldPreferredWidth(40);
        Path parentPath = Paths.get(ClonePathProvider.defaultParentDirectoryPath((Project)this.project, (DvcsRememberedInputs)GitRememberedInputs.getInstance()), new String[0]).toAbsolutePath();
        this.directoryField.setText(((Object)parentPath.resolve(this.repositoryDirectoryName)).toString());
        this.directoryField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                createDirectoryError = null;
                this.initValidation();
            }
        });
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ SpaceCloneRepositoryDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string2 = VcsBundle.message((String)"vcs.common.labels.directory", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ SpaceCloneRepositoryDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)SpaceCloneRepositoryDialog.access$getDirectoryField$p(this.this$0)).align((Align)AlignX.FILL.INSTANCE);
                    }
                }).bottomGap(BottomGap.SMALL);
            }
        }));
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        ArrayList list2 = new ArrayList();
        Collection collection = list2;
        String string2 = this.directoryField.getText();
        JTextField jTextField = this.directoryField.getTextField();
        Intrinsics.checkNotNull((Object)jTextField, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        ContainerUtil.addIfNotNull((Collection)collection, (Object)CloneDvcsValidationUtils.checkDirectory((String)string2, (JComponent)jTextField));
        ContainerUtil.addIfNotNull((Collection)list2, (Object)this.createDirectoryError);
        return list2;
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.applyFields();
            String string2 = this.directoryField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String directory = string2;
            this.createDirectoryError = CloneDvcsValidationUtils.createDestination((String)directory);
            if (this.createDirectoryError != null) {
                this.initValidation();
                return;
            }
            SpaceCloneComponentKt.doCloneSpaceRepo(this.project, this.cloneUrl, directory, this.checkoutListener);
            this.close(0);
        }
    }

    public static final /* synthetic */ TextFieldWithBrowseButton access$getDirectoryField$p(SpaceCloneRepositoryDialog $this) {
        return $this.directoryField;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloneType.values().length];
            try {
                nArray[CloneType.SSH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloneType.HTTPS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

