/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.changes;

import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.DiffPreviewController;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.changes.ui.AbstractChangesBrowserFilePathNode;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTree;
import com.intellij.openapi.vcs.changes.ui.AsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserStringNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesTreeModel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.vcs.changes.SpaceChange;
import com.intellij.space.vcs.changes.SpaceChangeKt;
import com.intellij.space.vcs.changes.SpaceRepository;
import com.intellij.space.vcs.review.SpaceReviewDataKeys;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u000245B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\fH\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006J\u0012\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u000e\u0010\"\u001a\u00020 2\u0006\u0010%\u001a\u00020\u001cJ\u001c\u0010&\u001a\u00020 2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020)0(H\u0002J\u0014\u0010*\u001a\u00020 2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u001c\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020-2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0014J&\u00100\u001a\u00020 *\u0002012\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00066"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTree;", "Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesTree;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_diffPreviewController", "Lcom/intellij/openapi/vcs/changes/DiffPreviewController;", "_selection", "Lruntime/reactive/MutableProperty;", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/space/vcs/changes/SpaceChange;", "changes", "", "changesTreeModel", "Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesTreeModel;", "getChangesTreeModel", "()Lcom/intellij/openapi/vcs/changes/ui/AsyncChangesTreeModel;", "diffPreview", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "getDiffPreview", "()Lcom/intellij/openapi/vcs/changes/DiffPreview;", "selection", "Lruntime/reactive/Property;", "getSelection", "()Lruntime/reactive/Property;", "getData", "", "dataId", "", "getSelectedNavigatableItems", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "installDiffPreview", "", "previewController", "selectFile", "toSelect", "Lcom/intellij/openapi/vcs/FilePath;", "spaceFilePath", "selectNodeBy", "predicate", "Lkotlin/Function1;", "", "setChanges", "updateTreeModel", "model", "Ljavax/swing/tree/DefaultTreeModel;", "treeStateStrategy", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree$TreeStateStrategy;", "addChanges", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "subtreeRoot", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "SpaceChangeNode", "SpaceRepositoryNode", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceChangesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceChangesTree.kt\ncom/intellij/space/vcs/changes/SpaceChangesTree\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,174:1\n37#2,2:175\n1603#3,9:177\n1855#3:186\n1856#3:188\n1612#3:189\n1549#3:190\n1620#3,3:191\n1477#3:194\n1502#3,3:195\n1505#3,3:205\n1#4:187\n372#5,7:198\n*S KotlinDebug\n*F\n+ 1 SpaceChangesTree.kt\ncom/intellij/space/vcs/changes/SpaceChangesTree\n*L\n100#1:175,2\n110#1:177,9\n110#1:186\n110#1:188\n110#1:189\n111#1:190\n111#1:191,3\n80#1:194\n80#1:195,3\n80#1:205,3\n110#1:187\n80#1:198,7\n*E\n"})
public final class SpaceChangesTree
extends AsyncChangesTree {
    @NotNull
    private List<SpaceChange> changes;
    @NotNull
    private final MutableProperty<ListSelection<SpaceChange>> _selection;
    @NotNull
    private final Property<ListSelection<SpaceChange>> selection;
    @Nullable
    private DiffPreviewController _diffPreviewController;
    @NotNull
    private final AsyncChangesTreeModel changesTreeModel;

    public SpaceChangesTree(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2, false, false);
        this.changes = CollectionsKt.emptyList();
        ListSelection listSelection = ListSelection.empty();
        Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"empty(...)");
        this._selection = PropertyKt.mutableProperty(listSelection);
        this.selection = this._selection;
        this.addTreeSelectionListener(arg_0 -> SpaceChangesTree._init_$lambda$1(this, arg_0));
        this.changesTreeModel = SimpleAsyncChangesTreeModel.Companion.create(arg_0 -> SpaceChangesTree.changesTreeModel$lambda$5(this, project2, arg_0));
    }

    @NotNull
    public final Property<ListSelection<SpaceChange>> getSelection() {
        return this.selection;
    }

    private final DiffPreview getDiffPreview() {
        DiffPreviewController diffPreviewController = this._diffPreviewController;
        return diffPreviewController != null ? diffPreviewController.getActivePreview() : null;
    }

    public final void setChanges(@NotNull List<SpaceChange> changes2) {
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        this.changes = changes2;
        this.rebuildTree();
    }

    public final void installDiffPreview(@NotNull DiffPreviewController previewController) {
        Intrinsics.checkNotNullParameter((Object)previewController, (String)"previewController");
        this.setDoubleClickHandler(arg_0 -> SpaceChangesTree.installDiffPreview$lambda$2(this, arg_0));
        this.setEnterKeyHandler(arg_0 -> SpaceChangesTree.installDiffPreview$lambda$3(this, arg_0));
        this._diffPreviewController = previewController;
    }

    protected void updateTreeModel(@NotNull DefaultTreeModel model2, @NotNull ChangesTree.TreeStateStrategy<?> treeStateStrategy) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(treeStateStrategy, (String)"treeStateStrategy");
        super.updateTreeModel(model2, treeStateStrategy);
        if (this.isSelectionEmpty() && !this.isEmpty()) {
            TreeUtil.selectFirstNode((JTree)((JTree)((Object)this)));
        }
    }

    @NotNull
    protected AsyncChangesTreeModel getChangesTreeModel() {
        return this.changesTreeModel;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            object = CollectionsKt.singleOrNull(this.getSelectedNavigatableItems());
        } else if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Collection $this$toTypedArray$iv = this.getSelectedNavigatableItems();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new OpenFileDescriptor[0]);
        } else {
            object = SpaceReviewDataKeys.INSTANCE.getREVIEW_CHANGES$intellij_space_vcs().is(dataId) ? VcsTreeModelData.selected((JTree)((JTree)((Object)this))).userObjects(SpaceChange.class) : (EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW.is(dataId) ? this.getDiffPreview() : VcsTreeModelData.getDataOrSuper((Project)this.getProject(), (JTree)((JTree)((Object)this)), (String)dataId, (Object)super.getData(dataId)));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OpenFileDescriptor> getSelectedNavigatableItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List list2 = VcsTreeModelData.selected((JTree)((JTree)((Object)this))).userObjects(SpaceChange.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"userObjects(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        VirtualFile virtualFile = $this$forEach$iv$iv$iv.iterator();
        while (virtualFile.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = virtualFile.next();
            boolean bl = false;
            SpaceChange changeNode = (SpaceChange)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)changeNode);
            if (SpaceChangeKt.getFilePath(changeNode).getVirtualFile() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new OpenFileDescriptor(this.getProject(), (VirtualFile)it));
        }
        return (List)destination$iv$iv;
    }

    public void selectFile(@Nullable FilePath toSelect) {
        this.selectNodeBy((Function1<? super SpaceChange, Boolean>)((Function1)new Function1<SpaceChange, Boolean>(toSelect){
            final /* synthetic */ FilePath $toSelect;
            {
                this.$toSelect = $toSelect;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SpaceChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)SpaceChangeKt.getFilePath(it), (Object)this.$toSelect);
            }
        }));
    }

    public final void selectFile(@NotNull String spaceFilePath) {
        Intrinsics.checkNotNullParameter((Object)spaceFilePath, (String)"spaceFilePath");
        this.selectNodeBy((Function1<? super SpaceChange, Boolean>)((Function1)new Function1<SpaceChange, Boolean>(spaceFilePath){
            final /* synthetic */ String $spaceFilePath;
            {
                this.$spaceFilePath = $spaceFilePath;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SpaceChange it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)SpaceChangeKt.getSpaceFilePath(it), (Object)this.$spaceFilePath);
            }
        }));
    }

    private final void selectNodeBy(Function1<? super SpaceChange, Boolean> predicate2) {
        this.invokeAfterRefresh(() -> SpaceChangesTree.selectNodeBy$lambda$9(this, predicate2));
    }

    private final void addChanges(TreeModelBuilder $this$addChanges, ChangesBrowserNode<?> subtreeRoot, List<SpaceChange> changes2) {
        for (SpaceChange change2 : changes2) {
            $this$addChanges.insertChangeNode((Object)SpaceChangeKt.getFilePath(change2), subtreeRoot, (ChangesBrowserNode)new SpaceChangeNode(change2));
        }
    }

    private static final SpaceChange lambda$1$lambda$0(Object it) {
        return it instanceof SpaceChange ? (SpaceChange)it : null;
    }

    private static final void _init_$lambda$1(SpaceChangesTree this$0, TreeSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ListSelection listSelection = VcsTreeModelData.getListSelectionOrAll((JTree)((JTree)((Object)this$0))).map(SpaceChangesTree::lambda$1$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"map(...)");
        ListSelection selection2 = listSelection;
        this$0._selection.setValue((ListSelection<SpaceChange>)selection2);
    }

    private static final boolean installDiffPreview$lambda$2(SpaceChangesTree this$0, MouseEvent e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            JTree jTree = (JTree)((Object)this$0);
            Intrinsics.checkNotNull((Object)e);
            if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)jTree, (MouseEvent)e)) {
                return false;
            }
            DiffPreview diffPreview = this$0.getDiffPreview();
            if (diffPreview == null) break block1;
            diffPreview.performDiffAction();
        }
        return true;
    }

    private static final boolean installDiffPreview$lambda$3(SpaceChangesTree this$0, KeyEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            DiffPreview diffPreview = this$0.getDiffPreview();
            if (diffPreview == null) break block0;
            diffPreview.performDiffAction();
        }
        return true;
    }

    private static final DefaultTreeModel changesTreeModel$lambda$5(SpaceChangesTree this$0, Project $project, ChangesGroupingPolicyFactory grouping) {
        boolean isSingleLocalRepository;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)grouping, (String)"grouping");
        List<SpaceChange> treeChanges = this$0.changes;
        if (treeChanges.isEmpty()) {
            return TreeModelBuilder.buildEmpty();
        }
        TreeModelBuilder builder = new TreeModelBuilder($project, grouping);
        Iterable $this$groupBy$iv = treeChanges;
        boolean $i$f$groupBy = false;
        Iterable object3 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : object3) {
            Object object;
            SpaceChange it = (SpaceChange)element$iv$iv;
            boolean bl = false;
            SpaceRepository key$iv$iv = it.getRepository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map changesByRepositories = destination$iv$iv;
        SpaceRepository spaceRepository = (SpaceRepository)CollectionsKt.singleOrNull((Iterable)changesByRepositories.keySet());
        boolean bl = isSingleLocalRepository = (spaceRepository != null ? spaceRepository.getMapping() : null) != null;
        if (isSingleLocalRepository) {
            ChangesBrowserNode changesBrowserNode = builder.myRoot;
            Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"myRoot");
            this$0.addChanges(builder, changesBrowserNode, treeChanges);
        } else {
            for (Map.Entry entry : changesByRepositories.entrySet()) {
                SpaceRepository changeRepository = (SpaceRepository)entry.getKey();
                List changes2 = (List)entry.getValue();
                SpaceRepositoryNode repositoryNode = new SpaceRepositoryNode(changeRepository.getName(), changeRepository.getMapping() != null);
                builder.insertSubtreeRoot((ChangesBrowserNode)repositoryNode);
                this$0.addChanges(builder, (ChangesBrowserNode)repositoryNode, changes2);
            }
        }
        return builder.build();
    }

    private static final boolean selectNodeBy$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void selectNodeBy$lambda$9(SpaceChangesTree this$0, Function1 $predicate) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$predicate, (String)"$predicate");
        TreeNode targetNode2 = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)this$0.getRoot())).traverse(TreeTraversal.POST_ORDER_DFS).find(arg_0 -> SpaceChangesTree.selectNodeBy$lambda$9$lambda$8((Function1)new Function1<TreeNode, Boolean>((Function1<? super SpaceChange, Boolean>)$predicate){
            final /* synthetic */ Function1<SpaceChange, Boolean> $predicate;
            {
                this.$predicate = $predicate;
                super(1);
            }

            @NotNull
            public final Boolean invoke(TreeNode it) {
                boolean bl;
                SpaceChange spaceChange = (SpaceChange)TreeUtil.getUserObject(SpaceChange.class, (Object)it);
                if (spaceChange != null) {
                    SpaceChange spaceChange2 = spaceChange;
                    bl = (Boolean)this.$predicate.invoke((Object)spaceChange2);
                } else {
                    bl = false;
                }
                return bl;
            }
        }, arg_0));
        if (targetNode2 != null) {
            TreeUtil.selectNode((JTree)((JTree)((Object)this$0)), (TreeNode)targetNode2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTree$SpaceChangeNode;", "Lcom/intellij/openapi/vcs/changes/ui/AbstractChangesBrowserFilePathNode;", "Lcom/intellij/space/vcs/changes/SpaceChange;", "spaceChange", "(Lcom/intellij/space/vcs/changes/SpaceChange;)V", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "userObject", "originPath", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "intellij.space.vcs"})
    private static final class SpaceChangeNode
    extends AbstractChangesBrowserFilePathNode<SpaceChange> {
        @NotNull
        private final SpaceChange spaceChange;

        public SpaceChangeNode(@NotNull SpaceChange spaceChange) {
            Intrinsics.checkNotNullParameter((Object)spaceChange, (String)"spaceChange");
            super((Object)spaceChange, spaceChange.getFileStatus());
            this.spaceChange = spaceChange;
        }

        @NotNull
        protected FilePath filePath(@NotNull SpaceChange userObject) {
            Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
            return SpaceChangeKt.getFilePath(userObject);
        }

        @Nullable
        protected FilePath originPath(@NotNull SpaceChange userObject) {
            Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
            return userObject.getNewFilePath() != null ? userObject.getOldFilePath() : null;
        }

        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            super.render(renderer2, selected2, expanded, hasFocus);
            if (this.spaceChange.getUnreachable()) {
                String hash = StringsKt.take((String)this.spaceChange.getGitCommitChange().getRevision(), (int)8);
                renderer2.append(FontUtil.spaceAndThinSpace());
                renderer2.append("[" + hash + "]");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/space/vcs/changes/SpaceChangesTree$SpaceRepositoryNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserStringNode;", "repositoryName", "", "inCurrentProject", "", "(Ljava/lang/String;Z)V", "getRepositoryName", "()Ljava/lang/String;", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "expanded", "hasFocus", "intellij.space.vcs"})
    private static final class SpaceRepositoryNode
    extends ChangesBrowserStringNode {
        @NotNull
        private final String repositoryName;
        private final boolean inCurrentProject;

        public SpaceRepositoryNode(@NlsSafe @NotNull String repositoryName, boolean inCurrentProject) {
            Intrinsics.checkNotNullParameter((Object)repositoryName, (String)"repositoryName");
            super(repositoryName);
            this.repositoryName = repositoryName;
            this.inCurrentProject = inCurrentProject;
            this.markAsHelperNode();
        }

        @NotNull
        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected2, boolean expanded, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            SimpleTextAttributes style = this.inCurrentProject ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
            renderer2.append(this.repositoryName, style);
        }
    }
}

