/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.actions;

import circlet.platform.client.KCircletClient;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceClientStats;
import com.intellij.space.stats.SpaceClientStatsKt;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.SpaceProjectContextKt;
import com.intellij.space.vcs.actions.CreateMergeRequestFromChangesAction;
import com.intellij.space.vcs.review.create.SpaceCreateReviewActionsKt;
import com.intellij.space.vcs.review.toolwindow.SpaceReviewToolWindowProjectViewModel;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016RJ\u0010\u0004\u001a4\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u0001 \u0007*\u0019\u0012\u000e\b\u0001\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR+\u0010\f\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u000f*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/intellij/space/vcs/actions/CreateMergeRequestFromChangesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "vcsChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getVcsChanges", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/vcs/changes/Change;", "vcsUnversioned", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/openapi/vcs/FilePath;", "Lorg/jetbrains/annotations/NotNull;", "getVcsUnversioned", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/util/containers/JBIterable;", "actionPerformed", "", "e", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "intellij.space.vcs"})
public final class CreateMergeRequestFromChangesAction
extends DumbAwareAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private CreateMergeRequestFromChangesAction() {
        super(SpaceBundle.message("review.create.new.merge.request.from.changes", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final JBIterable<FilePath> getVcsUnversioned(AnActionEvent $this$vcsUnversioned) {
        JBIterable jBIterable = JBIterable.from((Iterable)((Iterable)$this$vcsUnversioned.getData(ChangesListView.UNVERSIONED_FILE_PATHS_DATA_KEY)));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        return jBIterable;
    }

    private final Change[] getVcsChanges(AnActionEvent $this$vcsChanges) {
        return (Change[])$this$vcsChanges.getData(VcsDataKeys.CHANGES);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (SpaceCreateReviewActionsKt.getReviewToolWindowProjectVm(e) == null) {
            return;
        }
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        if (!presentation3.isEnabled()) {
            return;
        }
        if (!SpaceProjectContextKt.isSpaceProject(project3)) {
            presentation3.setEnabledAndVisible(false);
            return;
        }
        Change[] changeArray = this.getVcsChanges(e);
        if ((changeArray == null || changeArray.length == 0) && this.getVcsUnversioned(e).isEmpty()) {
            presentation3.setEnabled(false);
            return;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block4: {
            List changes2;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            JBIterable jBIterable = this.getVcsUnversioned(e).map(arg_0 -> CreateMergeRequestFromChangesAction.actionPerformed$lambda$0(actionPerformed.unversioned.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
            JBIterable unversioned2 = jBIterable;
            Object object = this.getVcsChanges(e);
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = CollectionsKt.emptyList();
            }
            if ((changes2 = CollectionsKt.plus((Collection)((Collection)object), (Iterable)((Iterable)unversioned2))).isEmpty()) {
                return;
            }
            String string2 = CreateMergeRequestFromChangesAction.Companion.extractCommitMessage(e);
            if (string2 == null) {
                string2 = "Fixup";
            }
            String commitMessage = string2;
            ToolWindow toolWindow = SpaceCreateReviewActionsKt.getReviewToolWindow(project3);
            if (toolWindow == null) break block4;
            ToolWindow it = toolWindow;
            boolean bl = false;
            it.activate(() -> CreateMergeRequestFromChangesAction.actionPerformed$lambda$2$lambda$1(it, e, commitMessage, changes2));
        }
    }

    private static final Change actionPerformed$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Change)$tmp0.invoke(p0);
    }

    private static final void actionPerformed$lambda$2$lambda$1(ToolWindow $it, AnActionEvent $e, String $commitMessage, List $changes) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        Intrinsics.checkNotNullParameter((Object)$commitMessage, (String)"$commitMessage");
        Intrinsics.checkNotNullParameter((Object)$changes, (String)"$changes");
        SpaceReviewToolWindowProjectViewModel spaceReviewToolWindowProjectViewModel = SpaceCreateReviewActionsKt.getReviewToolWindowProjectVm($it);
        if (spaceReviewToolWindowProjectViewModel == null) {
            return;
        }
        SpaceReviewToolWindowProjectViewModel reviewTabController = spaceReviewToolWindowProjectViewModel;
        String projectId2 = reviewTabController.getProjectInfo().getSpaceProject().getProject().getId();
        KCircletClient kCircletClient = SpaceClientStatsKt.getStats(reviewTabController.getWorkspace().getClient());
        String string2 = $e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPlace(...)");
        SpaceClientStats.reportOpenCreateReview-impl(kCircletClient, projectId2, SpaceStatsCounterCollector.CreateReviewType.MERGE_REQUEST_FROM_CHANGES, string2);
        reviewTabController.createMergeRequestFromChanges($commitMessage, $changes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/space/vcs/actions/CreateMergeRequestFromChangesAction$Companion;", "", "()V", "extractCommitMessage", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.space.vcs"})
    public static final class Companion {
        private Companion() {
        }

        private final String extractCommitMessage(AnActionEvent e) {
            String message2;
            String string2 = message2 = (String)e.getData(VcsDataKeys.PRESET_COMMIT_MESSAGE);
            if (string2 != null) {
                return string2;
            }
            List list2 = ShelvedChangesViewManager.getShelvedLists((DataContext)e.getDataContext());
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getShelvedLists(...)");
            List shelvedChangeLists = list2;
            if (!shelvedChangeLists.isEmpty()) {
                return ((ShelvedChangeList)shelvedChangeLists.get((int)0)).DESCRIPTION;
            }
            ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
            ChangeList[] changeListArray = changeLists;
            return !(changeListArray == null || changeListArray.length == 0) ? changeLists[0].getComment() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

