/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.packages;

import circlet.client.api.ProjectIdentifier;
import circlet.client.api.packages.PackageRepositoryIdentifier;
import com.intellij.space.packages.SpaceRepositoryReference;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"pathRegex", "Lkotlin/text/Regex;", "pathWithSlash", "", "Ljava/net/URL;", "getPathWithSlash", "(Ljava/net/URL;)Ljava/lang/String;", "getRepositoryReferenceFromUrl", "Lcom/intellij/space/packages/SpaceRepositoryReference;", "repoType", "url", "isSpacePackageUrl", "", "intellij.space"})
public final class SpacePackagesUrlUtilsKt {
    @NotNull
    private static final Regex pathRegex = new Regex(".*/p/(?<project>[\\w-]+)/(?<repository>[\\w-]+)");

    public static final boolean isSpacePackageUrl(@NotNull String url2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        try {
            URL parsedUrl = new URL(url2);
            bl = pathRegex.matchEntire((CharSequence)SpacePackagesUrlUtilsKt.getPathWithSlash(parsedUrl)) != null;
        }
        catch (MalformedURLException malformedURLException) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final SpaceRepositoryReference getRepositoryReferenceFromUrl(@NotNull String repoType, @NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)repoType, (String)"repoType");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        MatchResult match2 = pathRegex.matchEntire((CharSequence)SpacePackagesUrlUtilsKt.getPathWithSlash(new URL(url2)));
        Object object = match2;
        if (object == null || (object = object.getGroups()) == null || (object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)object, (String)"project")) == null || (object = object.getValue()) == null) {
            throw new IllegalArgumentException("Provided URL is not a Space package repo URL");
        }
        Object projectKey = object;
        Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match2.getGroups(), (String)"repository");
        if (object2 == null || (object2 = object2.getValue()) == null) {
            throw new IllegalArgumentException("Provided URL is not a Space package repo URL");
        }
        Object repoKey = object2;
        return new SpaceRepositoryReference(new ProjectIdentifier.Key((String)projectKey), new PackageRepositoryIdentifier.TypeAndName(repoType, (String)repoKey));
    }

    private static final String getPathWithSlash(URL $this$pathWithSlash) {
        String string2 = $this$pathWithSlash.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        char[] cArray = new char[]{'/'};
        return "/" + StringsKt.trim((String)string2, (char[])cArray);
    }
}

