/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway;

import com.intellij.space.gateway.AbstractSpaceGatewayContext;
import com.intellij.space.gateway.SpaceKt;
import com.intellij.space.gateway.ui.SpaceGatewayConnectorView;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.api.GatewayConnectorAction;
import com.jetbrains.gateway.api.GatewayConnectorView;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/space/gateway/AbstractSpaceGatewayConnector;", "Lcom/jetbrains/gateway/api/GatewayConnector;", "()V", "context", "Lcom/intellij/space/gateway/AbstractSpaceGatewayContext;", "getContext", "()Lcom/intellij/space/gateway/AbstractSpaceGatewayContext;", "createView", "Lcom/jetbrains/gateway/api/GatewayConnectorView;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Lcom/intellij/space/gateway/RdLifetime;", "getActionText", "", "getDescription", "getTitle", "isAvailable", "", "userWasConnectedToSpace", "OpenSpaceTabConnectorAction", "intellij.space.gateway"})
public abstract class AbstractSpaceGatewayConnector
implements GatewayConnector {
    public AbstractSpaceGatewayConnector() {
        this.getContext().connectionService();
    }

    @NotNull
    public abstract AbstractSpaceGatewayContext getContext();

    @NotNull
    public String getTitle() {
        return this.getContext().bundle().message("connector.title", new Object[0]);
    }

    @NotNull
    public String getActionText() {
        return this.getContext().bundle().message("connector.action.text", new Object[0]);
    }

    @NotNull
    public String getDescription() {
        return this.getContext().bundle().message("connector.description", new Object[0]);
    }

    @NotNull
    public GatewayConnectorView createView(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        return this.userWasConnectedToSpace() ? (GatewayConnectorView)new OpenSpaceTabConnectorAction() : (GatewayConnectorView)new SpaceGatewayConnectorView(SpaceKt.spaceLifetime(lifetime), this.getContext());
    }

    public boolean isAvailable() {
        return true;
    }

    private final boolean userWasConnectedToSpace() {
        return this.getContext().settings().getServerSettings().getEnabled();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/gateway/AbstractSpaceGatewayConnector$OpenSpaceTabConnectorAction;", "Lcom/jetbrains/gateway/api/GatewayConnectorAction;", "(Lcom/intellij/space/gateway/AbstractSpaceGatewayConnector;)V", "invoke", "", "intellij.space.gateway"})
    private final class OpenSpaceTabConnectorAction
    implements GatewayConnectorAction {
        public void invoke() {
            AbstractSpaceGatewayConnector.this.getContext().getNavigation().showMainGatewayConnectorScreen();
        }
    }
}

