/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.LocalTime;

public class LocalTimeSerializer
extends JodaDateSerializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;

    public LocalTimeSerializer() {
        this(FormatConfig.DEFAULT_LOCAL_TIMEONLY_PRINTER, 0);
    }

    public LocalTimeSerializer(JacksonJodaDateFormat format2) {
        this(format2, 0);
    }

    public LocalTimeSerializer(JacksonJodaDateFormat format2, int shapeOverride) {
        super(LocalTime.class, format2, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, 3, shapeOverride);
    }

    public LocalTimeSerializer withFormat(JacksonJodaDateFormat formatter2, int shapeOverride) {
        return new LocalTimeSerializer(formatter2, shapeOverride);
    }

    public void serialize(LocalTime value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        if (this._serializationShape(provider2) == 1) {
            gen.writeString(this._format.createFormatter(provider2).print(value2));
            return;
        }
        gen.writeStartArray();
        gen.writeNumber(value2.hourOfDay().get());
        gen.writeNumber(value2.minuteOfHour().get());
        gen.writeNumber(value2.secondOfMinute().get());
        gen.writeNumber(value2.millisOfSecond().get());
        gen.writeEndArray();
    }
}

