/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaDateSerializerBase;
import java.io.IOException;
import org.joda.time.DateTime;

public class DateTimeSerializer
extends JodaDateSerializerBase<DateTime> {
    private static final long serialVersionUID = 1L;

    public DateTimeSerializer() {
        this(FormatConfig.DEFAULT_DATETIME_PRINTER, 0);
    }

    public DateTimeSerializer(JacksonJodaDateFormat format2) {
        this(format2, 0);
    }

    public DateTimeSerializer(JacksonJodaDateFormat format2, int shapeOverride) {
        super(DateTime.class, format2, SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, 2, shapeOverride);
    }

    public DateTimeSerializer withFormat(JacksonJodaDateFormat formatter2, int shapeOverride) {
        return new DateTimeSerializer(formatter2, shapeOverride);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, DateTime value2) {
        return value2.getMillis() == 0L;
    }

    public void serialize(DateTime value2, JsonGenerator gen, SerializerProvider provider2) throws IOException {
        boolean numeric;
        boolean bl = numeric = this._serializationShape(provider2) != 1;
        if (!this.writeWithZoneId(provider2)) {
            if (numeric) {
                gen.writeNumber(value2.getMillis());
            } else {
                gen.writeString(this._format.createFormatter(provider2).print(value2));
            }
        } else {
            if (numeric) {
                gen.writeNumber(value2.getMillis());
                return;
            }
            StringBuilder sb = new StringBuilder(40).append(this._format.createFormatter(provider2).withOffsetParsed().print(value2));
            sb = sb.append('[').append(value2.getZone()).append(']');
            gen.writeString(sb.toString());
        }
    }
}

