/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo.remind;

import circlet.client.api.TD_MemberProfile;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.client.KCircletClient;
import circlet.todo.TodoPostponeDateCalculator;
import circlet.todo.remind.RemindMeItemsProvider;
import circlet.todo.remind.TodoMoreMenuButtonItem;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.Property;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J2\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcirclet/todo/remind/RemindMeItemsProviderImpl;", "Lcirclet/todo/remind/RemindMeItemsProvider;", "client", "Lcirclet/platform/client/KCircletClient;", "me", "Lruntime/reactive/Property;", "Lcirclet/client/api/TD_MemberProfile;", "(Lcirclet/platform/client/KCircletClient;Lruntime/reactive/Property;)V", "getClient", "()Lcirclet/platform/client/KCircletClient;", "getMe", "()Lruntime/reactive/Property;", "getItems", "", "Lcirclet/todo/remind/TodoMoreMenuButtonItem;", "currentTime", "Lcirclet/platform/api/KotlinXDateTime;", "Lcirclet/platform/api/ADateTime;", "inTodo", "", "scheduled", "withDevTool", "app-state"})
public final class RemindMeItemsProviderImpl
implements RemindMeItemsProvider {
    @NotNull
    private final KCircletClient client;
    @NotNull
    private final Property<TD_MemberProfile> me;

    public RemindMeItemsProviderImpl(@NotNull KCircletClient client2, @NotNull Property<TD_MemberProfile> me2) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter(me2, (String)"me");
        this.client = client2;
        this.me = me2;
    }

    @NotNull
    public final KCircletClient getClient() {
        return this.client;
    }

    @NotNull
    public final Property<TD_MemberProfile> getMe() {
        return this.me;
    }

    @Override
    @Deprecated(message="Use TodoListVm.remindMeOptions")
    @NotNull
    public List<TodoMoreMenuButtonItem> getItems(@NotNull KotlinXDateTime currentTime, boolean inTodo, boolean scheduled, boolean withDevTool) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        KotlinXDate tom = ADateJvmKt.toDate(ADateJvmKt.plusDays(currentTime, 1));
        KotlinXDate nextWeek = new TodoPostponeDateCalculator().nextWeek(ADateJvmKt.toDate(currentTime));
        Object[] objectArray = new TodoMoreMenuButtonItem[]{new TodoMoreMenuButtonItem.Action("In 20 minutes", null, ADateJvmKt.plusMinutes(currentTime, 20)), new TodoMoreMenuButtonItem.Action("In 1 hour", null, ADateJvmKt.plusHours(currentTime, 1)), new TodoMoreMenuButtonItem.Action("Tomorrow at 9:00", tom, ADateJvmKt.plusHours(ADateJvmKt.toDateTimeAtStartOfDay(tom), 9)), new TodoMoreMenuButtonItem.Action("Next week at 9:00", nextWeek, ADateJvmKt.plusHours(ADateJvmKt.toDateTimeAtStartOfDay(nextWeek), 9))};
        List res = CollectionsKt.mutableListOf((Object[])objectArray);
        if (withDevTool) {
            res.add(new TodoMoreMenuButtonItem.Action("[dev] In 1 minute", null, ADateJvmKt.plusSeconds(currentTime, 60)));
        }
        if (inTodo && scheduled) {
            res.add(TodoMoreMenuButtonItem.Separator.INSTANCE);
            res.add(TodoMoreMenuButtonItem.Remove.INSTANCE);
        }
        return res;
    }
}

