/*
 * Decompiled with CFR 0.152.
 */
package circlet.principals;

import circlet.client.api.CApplicationPrincipalDetails;
import circlet.client.api.CBuiltInServicePrincipalDetails;
import circlet.client.api.CPrincipalDetails;
import circlet.client.api.CUserPrincipalDetails;
import circlet.client.api.CUserWithEmailPrincipalDetails;
import circlet.principals.ProjectPrincipal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.batchSource.SortableItem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\b\u0010\u0016\u001a\u00020\rH\u0002J\t\u0010\u0017\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcirclet/principals/WeightedPrincipal;", "Lruntime/batchSource/SortableItem;", "principal", "Lcirclet/principals/ProjectPrincipal;", "(Lcirclet/principals/ProjectPrincipal;)V", "key", "", "Lcirclet/platform/api/TID;", "getKey", "()Ljava/lang/String;", "getPrincipal", "()Lcirclet/principals/ProjectPrincipal;", "weight", "", "getWeight", "()I", "component1", "copy", "equals", "", "other", "", "getPrincipalWeight", "hashCode", "toString", "app-state"})
public final class WeightedPrincipal
implements SortableItem {
    @NotNull
    private final ProjectPrincipal principal;
    @NotNull
    private final String key;
    private final int weight;

    public WeightedPrincipal(@NotNull ProjectPrincipal principal) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.principal = principal;
        CPrincipalDetails details = this.principal.getPrincipal().getDetails();
        if (details instanceof CUserPrincipalDetails) {
            string2 = ((CUserPrincipalDetails)details).getUser().getId();
        } else if (details instanceof CApplicationPrincipalDetails) {
            string2 = ((CApplicationPrincipalDetails)details).getApp().getId();
        } else if (details instanceof CBuiltInServicePrincipalDetails) {
            string2 = ((CBuiltInServicePrincipalDetails)details).getKey();
            if (string2 == null) {
                string2 = ((CBuiltInServicePrincipalDetails)details).getName();
            }
        } else {
            string2 = details instanceof CUserWithEmailPrincipalDetails ? ((CUserWithEmailPrincipalDetails)details).getEmail() : "";
        }
        this.key = string2;
        this.weight = this.getPrincipalWeight();
    }

    @NotNull
    public final ProjectPrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    private final int getPrincipalWeight() {
        CPrincipalDetails cPrincipalDetails = this.principal.getPrincipal().getDetails();
        return cPrincipalDetails instanceof CUserPrincipalDetails ? 2 : (cPrincipalDetails instanceof CApplicationPrincipalDetails ? 1 : 0);
    }

    @NotNull
    public final ProjectPrincipal component1() {
        return this.principal;
    }

    @NotNull
    public final WeightedPrincipal copy(@NotNull ProjectPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return new WeightedPrincipal(principal);
    }

    public static /* synthetic */ WeightedPrincipal copy$default(WeightedPrincipal weightedPrincipal, ProjectPrincipal projectPrincipal, int n, Object object) {
        if ((n & 1) != 0) {
            projectPrincipal = weightedPrincipal.principal;
        }
        return weightedPrincipal.copy(projectPrincipal);
    }

    @NotNull
    public String toString() {
        return "WeightedPrincipal(principal=" + this.principal + ")";
    }

    public int hashCode() {
        return this.principal.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WeightedPrincipal)) {
            return false;
        }
        WeightedPrincipal weightedPrincipal = (WeightedPrincipal)other;
        return Intrinsics.areEqual((Object)this.principal, (Object)weightedPrincipal.principal);
    }
}

