/*
 * Decompiled with CFR 0.152.
 */
package circlet.planning;

import circlet.client.api.IssueIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcirclet/planning/IssueIdentifierResolver;", "", "()V", "idPrefix", "", "keyPrefix", "resolve", "Lcirclet/client/api/IssueIdentifier;", "issueAsString", "planning-api"})
public final class IssueIdentifierResolver {
    @NotNull
    public static final IssueIdentifierResolver INSTANCE = new IssueIdentifierResolver();
    @NotNull
    private static final String idPrefix = "id:";
    @NotNull
    private static final String keyPrefix = "key:";

    private IssueIdentifierResolver() {
    }

    @NotNull
    public final IssueIdentifier resolve(@NotNull String issueAsString) {
        IssueIdentifier issueIdentifier;
        Intrinsics.checkNotNullParameter((Object)issueAsString, (String)"issueAsString");
        if (StringsKt.startsWith((String)issueAsString, (String)idPrefix, (boolean)true)) {
            String string2 = issueAsString.substring(idPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            issueIdentifier = new IssueIdentifier.Id(string2);
        } else if (StringsKt.startsWith((String)issueAsString, (String)keyPrefix, (boolean)true)) {
            String string3 = issueAsString.substring(keyPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            issueIdentifier = new IssueIdentifier.Key(string3);
        } else {
            issueIdentifier = new IssueIdentifier.Id(issueAsString);
        }
        return issueIdentifier;
    }
}

