/*
 * Decompiled with CFR 0.152.
 */
package circlet.planning;

import circlet.client.api.IssueIdentifier;
import circlet.client.api.ProjectIdentifier;
import circlet.client.api.search.IssueSearchExpression;
import circlet.common.permissions.CreateBoard;
import circlet.common.permissions.EditBoardContent;
import circlet.common.permissions.ManageBoard;
import circlet.common.permissions.ViewBoard;
import circlet.planning.BacklogIdentifier;
import circlet.planning.BacklogTypeIn;
import circlet.planning.BoardBacklog;
import circlet.planning.BoardColumns;
import circlet.planning.BoardIdentifier;
import circlet.planning.BoardIssueInputField;
import circlet.planning.BoardRecord;
import circlet.planning.BoardSprintsFilterValue;
import circlet.planning.BoardWidgetRecord;
import circlet.planning.InitialIssueBoardState;
import circlet.planning.Issue;
import circlet.planning.IssueBoardSelectorValue;
import circlet.planning.Issues;
import circlet.planning.PlanningTag;
import circlet.planning.SprintIdentifier;
import circlet.planning.SprintLaunch;
import circlet.planning.SprintRecord;
import circlet.planning.SwimlaneRecord;
import circlet.platform.api.Api;
import circlet.platform.api.KOption;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.Ref;
import circlet.platform.api.annotations.DefaultParameterValues;
import circlet.platform.api.annotations.Http;
import circlet.platform.api.annotations.HttpApi;
import circlet.platform.api.annotations.HttpApiDeprecated;
import circlet.platform.api.annotations.HttpApiDoc;
import circlet.platform.api.annotations.Rest;
import circlet.platform.api.annotations.Rights;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.ApiFlag;
import platform.common.ApiFlagAnnotation;
import platform.common.ApiFlags;
import platform.common.SpaceOnPremiseVersions;
import runtime.batch.Batch;
import runtime.batch.BatchInfo;

@HttpApi(resource="")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\bg\u0018\u00002\u00020\u0001:\u0002\u0098\u0001J!\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ!\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J?\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ-\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0019\u0010 \u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u0019\u0010$\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J-\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u001d0'2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J?\u0010,\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ?\u0010.\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ?\u0010/\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ1\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\b\u00102\u001a\u0004\u0018\u00010\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J3\u00104\u001a\b\u0012\u0004\u0012\u0002050\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u000f2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108JU\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u001d2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u000f2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u000f2\n\u0010;\u001a\u00060<j\u0002`=2\n\u0010>\u001a\u00060<j\u0002`=2\b\b\u0002\u0010?\u001a\u00020@H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010AJ+\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u001d2\u0006\u00106\u001a\u00020\u000f2\n\u0010\n\u001a\u00060\u000fj\u0002`\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJE\u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020F0\u001d0'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\b\b\u0002\u0010H\u001a\u00020\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010IJI\u0010J\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u000205\u0018\u00010\u001d\u0012\f\u0012\n\u0012\u0004\u0012\u00020:\u0018\u00010\u001d0K2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010L\u001a\u0004\u0018\u00010\u000f2\b\u0010M\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J+\u0010N\u001a\n\u0012\u0004\u0012\u000205\u0018\u00010\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010L\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010OJG\u0010P\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u001d0'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\n\b\u0003\u0010H\u001a\u0004\u0018\u00010\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010RJ3\u0010S\u001a\n\u0012\u0004\u0012\u00020:\u0018\u00010\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010M\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJG\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\u001d0'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\n\b\u0003\u0010H\u001a\u0004\u0018\u00010\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010RJ1\u0010W\u001a\b\u0012\u0004\u0012\u00020X0'2\u0006\u00101\u001a\u00020\u00182\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010)\u001a\u00020*H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010[J7\u0010\\\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u001d0'2\u0006\u00101\u001a\u00020\u00182\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010)\u001a\u00020*H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010[J\u001f\u0010]\u001a\b\u0012\u0004\u0012\u0002050\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J1\u0010^\u001a\b\u0012\u0004\u0012\u00020_0'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\b\u0010`\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010aJ1\u0010b\u001a\b\u0012\u0004\u0012\u00020c0'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\b\u0010`\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010aJ+\u0010d\u001a\u00020e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010f\u001a\u00020\u00072\b\b\u0002\u0010g\u001a\u00020\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010hJ+\u0010i\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010j\u001a\u00020\u001a2\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010kJ7\u0010l\u001a\u00020m2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010L\u001a\u0004\u0018\u00010\u000f2\b\u0010M\u001a\u0004\u0018\u00010\u000f2\b\u0010n\u001a\u0004\u0018\u00010eH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010oJ7\u0010p\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u001d0'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\b\u0010`\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010aJE\u0010q\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\u001d0'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010`\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010rJO\u0010s\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020:0\u001d0'2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010`\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010t\u001a\u00020\u001aH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010uJ!\u0010v\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ!\u0010w\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ%\u0010x\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J?\u0010y\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010z\u001a\u00020\u00032\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010{J9\u0010|\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010}J?\u0010~\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ9\u0010\u007f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u001d0'2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\t\b\u0002\u0010\u0080\u0001\u001a\u00020\u001aH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0081\u0001J(\u0010\u0082\u0001\u001a\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u001d0\u0083\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0084\u0001J)\u0010\u0085\u0001\u001a\u0010\u0012\u000b\u0012\t\u0012\u0005\u0012\u00030\u0086\u00010\u001d0\u0083\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0084\u0001J\u00ac\u0001\u0010\u0087\u0001\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u000f2\u0011\b\u0002\u00107\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0088\u00012\u0012\b\u0002\u0010\u0089\u0001\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0088\u00012\f\b\u0002\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\u0012\b\u0002\u0010\u008c\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u008d\u0001\u0018\u00010\u00162\u0015\b\u0002\u0010\u008e\u0001\u001a\u000e\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0018\u00010\u00162\u0015\b\u0002\u0010\u008f\u0001\u001a\u000e\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0018\u00010\u00162\f\b\u0003\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u0001H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0092\u0001J1\u0010\u0093\u0001\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0094\u0001Jb\u0010\u0095\u0001\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\b\u00106\u001a\u0004\u0018\u00010\u000f2\u0011\b\u0002\u00107\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0088\u00012\u000e\u0010;\u001a\n\u0018\u00010<j\u0004\u0018\u0001`=2\u000e\u0010>\u001a\n\u0018\u00010<j\u0004\u0018\u0001`=2\b\u0010?\u001a\u0004\u0018\u00010@H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0096\u0001J(\u0010\u0097\u0001\u001a\u00020\u00032\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\b\u00106\u001a\u0004\u0018\u00010\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010D\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0099\u0001"}, d2={"Lcirclet/planning/Boards;", "Lcirclet/platform/api/Api;", "addIssueToBoard", "", "issue", "Lcirclet/client/api/IssueIdentifier;", "board", "Lcirclet/planning/BoardIdentifier;", "(Lcirclet/client/api/IssueIdentifier;Lcirclet/planning/BoardIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addIssueToSprint", "sprint", "Lcirclet/planning/SprintIdentifier;", "(Lcirclet/client/api/IssueIdentifier;Lcirclet/planning/SprintIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addIssueToSwimlane", "swimlane", "", "Lcirclet/platform/api/TID;", "(Lcirclet/client/api/IssueIdentifier;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addIssuesToBacklogs", "project", "Lcirclet/client/api/ProjectIdentifier;", "issues", "", "backlogs", "Lcirclet/planning/BacklogIdentifier;", "notifySubscribers", "", "(Lcirclet/client/api/ProjectIdentifier;Ljava/util/List;Ljava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "allTagsInSprint", "Lcirclet/platform/api/Ref;", "Lcirclet/planning/PlanningTag;", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/planning/SprintIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "archiveBoard", "(Lcirclet/planning/BoardIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "archiveBoardInProject", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/planning/BoardIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "archiveSprint", "(Lcirclet/planning/SprintIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "boardIssues", "Lruntime/batch/Batch;", "Lcirclet/planning/Issue;", "batchInfo", "Lruntime/batch/BatchInfo;", "(Lcirclet/planning/BoardIdentifier;Lruntime/batch/BatchInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bulkAddIssuesSprints", "sprints", "bulkRemoveIssuesSprints", "bulkUpdateIssuesSprints", "changeIssuePositionInBacklog", "backlog", "anchorIssue", "(Lcirclet/planning/BacklogIdentifier;Ljava/util/List;Lcirclet/client/api/IssueIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBoardInProject", "Lcirclet/planning/BoardRecord;", "name", "description", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSprint", "Lcirclet/planning/SprintRecord;", "from", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "to", "launch", "Lcirclet/planning/SprintLaunch;", "(Lcirclet/planning/BoardIdentifier;Ljava/lang/String;Ljava/lang/String;Lcirclet/platform/api/KotlinXDate;Lcirclet/platform/api/KotlinXDate;Lcirclet/planning/SprintLaunch;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSwimlane", "Lcirclet/planning/SwimlaneRecord;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBacklogs", "Lcirclet/planning/BoardBacklog;", "backlogIds", "withDeleted", "(Lcirclet/client/api/ProjectIdentifier;Lruntime/batch/BatchInfo;Ljava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBoardAndSprintOrDefault", "Lkotlin/Pair;", "boardNameOrId", "sprintNameOrId", "findBoardOrGetFirstStarred", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBoards", "boardsNamesOrIds", "(Lcirclet/client/api/ProjectIdentifier;Lruntime/batch/BatchInfo;Ljava/util/List;Ljava/lang/Boolean;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSprintOrGetCurrent", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/planning/BoardIdentifier;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSprints", "sprintsNamesOrIds", "getBacklogIssueLazyRefs", "Lcirclet/planning/Issues$LazyIssueRef;", "userSearchExpression", "Lcirclet/client/api/search/IssueSearchExpression;", "(Lcirclet/planning/BacklogIdentifier;Lcirclet/client/api/search/IssueSearchExpression;Lruntime/batch/BatchInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBacklogIssueRefs", "getBoard", "getBoardSelectorValues", "Lcirclet/planning/IssueBoardSelectorValue;", "query", "(Lcirclet/client/api/ProjectIdentifier;Lruntime/batch/BatchInfo;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBoardsAndSprintsInProject", "Lcirclet/planning/BoardSprintsFilterValue;", "getSprintsCount", "", "boardId", "withArchived", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/planning/BoardIdentifier;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launchPlannedSprint", "moveUnresolvedIssuesFromCurrentSprint", "(Lcirclet/planning/SprintIdentifier;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "preloadBoardAndIssues", "Lcirclet/planning/InitialIssueBoardState;", "limit", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "projectBoards", "projectSprints", "(Lcirclet/client/api/ProjectIdentifier;Lruntime/batch/BatchInfo;Lcirclet/planning/BoardIdentifier;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "projectSprintsInternal", "withDefaultSprints", "(Lcirclet/client/api/ProjectIdentifier;Lruntime/batch/BatchInfo;Lcirclet/planning/BoardIdentifier;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeIssueFromBoard", "removeIssueFromSprint", "removeIssueFromSwimlane", "removeIssuesFromBacklogs", "removeSwimlane", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setBacklogsToIssue", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/IssueIdentifier;Ljava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setBacklogsToIssues", "sprintIssues", "unresolvedOnly", "(Lcirclet/planning/SprintIdentifier;Lruntime/batch/BatchInfo;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "starredBoards", "", "(Lcirclet/client/api/ProjectIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "starredBoardsWidgets", "Lcirclet/planning/BoardWidgetRecord;", "updateBoard", "Lcirclet/platform/api/KOption;", "swimlaneKey", "columns", "Lcirclet/planning/BoardColumns;", "issueFields", "Lcirclet/planning/BoardIssueInputField;", "memberOwners", "teamOwners", "backlogType", "Lcirclet/planning/BacklogTypeIn;", "(Lcirclet/planning/BoardIdentifier;Ljava/lang/String;Lcirclet/platform/api/KOption;Lcirclet/platform/api/KOption;Lcirclet/planning/BoardColumns;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcirclet/planning/BacklogTypeIn;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateIssueSprints", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/IssueIdentifier;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateSprint", "(Lcirclet/planning/SprintIdentifier;Ljava/lang/String;Lcirclet/platform/api/KOption;Lcirclet/platform/api/KotlinXDate;Lcirclet/platform/api/KotlinXDate;Lcirclet/planning/SprintLaunch;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateSwimlane", "Flags", "planning-api"})
public interface Boards
extends Api {
    @Rest.Create(path="projects/{project}/planning/boards")
    @HttpApiDoc(doc="Create a new issue board in a project. The user will become the owner of the board.")
    @Rights(rights={CreateBoard.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="description", defaultValue="null")})
    @Nullable
    public Object createBoardInProject(@NotNull ProjectIdentifier var1, @NotNull String var2, @Nullable String var3, @NotNull Continuation<? super Ref<BoardRecord>> var4);

    @Rest.Query(path="projects/{project}/planning/boards")
    @HttpApiDoc(doc="Search existing boards in a project")
    @Rights(rights={ViewBoard.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object projectBoards(@NotNull ProjectIdentifier var1, @NotNull BatchInfo var2, @Nullable String var3, @NotNull Continuation<? super Batch<Ref<BoardRecord>>> var4);

    @Rest.Get(path="projects/planning/boards/{board}")
    @HttpApiDoc(doc="Get a board by identifier")
    @Rights(rights={ViewBoard.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getBoard(@NotNull BoardIdentifier var1, @NotNull Continuation<? super Ref<BoardRecord>> var2);

    @Rest.Query(path="projects/{project}/planning/boards/starred", displayName="Get all starred boards")
    @HttpApiDoc(doc="Get all starred boards in a project")
    @Rights(rights={ViewBoard.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object starredBoards(@NotNull ProjectIdentifier var1, @NotNull Continuation<? super Ref<BoardRecord>[]> var2);

    @Rest.Update(path="projects/planning/boards/{board}")
    @HttpApiDoc(doc="Update an existing board. This operation can be performed by board owners or other members who are granted permission to manage boards in a project.")
    @Rights(rights={ManageBoard.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="name", defaultValue="null"), @DefaultParameterValues.Param(name="description", defaultValue="_"), @DefaultParameterValues.Param(name="swimlaneKey", defaultValue="_"), @DefaultParameterValues.Param(name="columns", defaultValue="null"), @DefaultParameterValues.Param(name="issueFields", defaultValue="null"), @DefaultParameterValues.Param(name="memberOwners", defaultValue="null"), @DefaultParameterValues.Param(name="teamOwners", defaultValue="null"), @DefaultParameterValues.Param(name="backlogType", defaultValue="null")})
    @Nullable
    public Object updateBoard(@NotNull BoardIdentifier var1, @Nullable String var2, @NotNull KOption<String> var3, @NotNull KOption<String> var4, @Nullable BoardColumns var5, @Nullable List<? extends BoardIssueInputField> var6, @Nullable List<String> var7, @Nullable List<String> var8, @ApiFlagAnnotation(cls=Flags.Backlog.class) @Nullable BacklogTypeIn var9, @NotNull Continuation<? super Unit> var10);

    @Rest.Delete(path="projects/planning/boards/{board}", displayName="Delete board")
    @HttpApiDoc(doc="Delete an existing board. This operation can be performed by board owners or other members who are granted permission to manage boards in a project.")
    @Rights(rights={ManageBoard.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object archiveBoard(@NotNull BoardIdentifier var1, @NotNull Continuation<? super Unit> var2);

    @Rest.Delete(path="projects/{project}/planning/boards/{board}/archive", displayName="Archive board")
    @HttpApiDoc(doc="Archive an existing board. This operation can be performed by board owners or other members who are granted permission to manage boards in a project.")
    @Rights(rights={ManageBoard.class})
    @HttpApiDeprecated(message="Use DELETE /projects/planning/boards/{board} instead", since="2021-12-22")
    @Deprecated(message="Use archiveBoard(board) instead", replaceWith=@ReplaceWith(expression="archiveBoard(board)", imports={}))
    @DefaultParameterValues(params={})
    @Nullable
    public Object archiveBoardInProject(@NotNull ProjectIdentifier var1, @NotNull BoardIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Rights(rights={ViewBoard.class})
    @Nullable
    public Object findBoardOrGetFirstStarred(@NotNull ProjectIdentifier var1, @Nullable String var2, @NotNull Continuation<? super Ref<BoardRecord>> var3);

    @Rights(rights={ViewBoard.class})
    @Nullable
    public Object findBoards(@NotNull ProjectIdentifier var1, @NotNull BatchInfo var2, @NotNull List<String> var3, @ApiFlagAnnotation(cls=Flags.SearchBoardWithDeleted.class) @Nullable Boolean var4, @NotNull Continuation<? super Batch<Ref<BoardRecord>>> var5);

    @Rest.Create(path="projects/planning/boards/sprints")
    @HttpApiDoc(doc="Create a new sprint in a board. This operation can be performed by board owners or other members who are granted permission to manage boards in a project.")
    @Rights(rights={ManageBoard.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="description", defaultValue="null"), @DefaultParameterValues.Param(name="launch", defaultValue="_")})
    @Nullable
    public Object createSprint(@NotNull BoardIdentifier var1, @NotNull String var2, @Nullable String var3, @NotNull KotlinXDate var4, @NotNull KotlinXDate var5, @NotNull SprintLaunch var6, @NotNull Continuation<? super Ref<SprintRecord>> var7);

    @Rest.Query(path="projects/{project}/planning/boards/sprints")
    @HttpApiDoc(doc="Search existing sprints in a project")
    @Rights(rights={ViewBoard.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="board", defaultValue="null"), @DefaultParameterValues.Param(name="query", defaultValue="null")})
    @Nullable
    public Object projectSprints(@NotNull ProjectIdentifier var1, @NotNull BatchInfo var2, @Nullable BoardIdentifier var3, @Nullable String var4, @NotNull Continuation<? super Batch<Ref<SprintRecord>>> var5);

    @Rest.Update(path="projects/planning/boards/sprints/{sprint}")
    @HttpApiDoc(doc="Update an existing sprint in a board. This operation can be performed by board owners or other members who are granted permission to manage boards in a project.")
    @Rights(rights={ManageBoard.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="description", defaultValue="_")})
    @Nullable
    public Object updateSprint(@NotNull SprintIdentifier var1, @Nullable String var2, @NotNull KOption<String> var3, @Nullable KotlinXDate var4, @Nullable KotlinXDate var5, @Nullable SprintLaunch var6, @NotNull Continuation<? super Unit> var7);

    @Http.Post(path="projects/planning/boards/sprints/{sprint}/launch", displayName="Launch planned sprint")
    @HttpApiDoc(doc="Launch a planned sprint. This operation can be performed by board owners or other members who are granted permission to manage boards in a project.")
    @Rights(rights={ManageBoard.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="notifySubscribers", defaultValue="true")})
    @Nullable
    public Object launchPlannedSprint(@NotNull SprintIdentifier var1, boolean var2, boolean var3, @NotNull Continuation<? super Unit> var4);

    @Rest.Delete(path="projects/planning/boards/sprints/{sprint}/archive", displayName="Archive sprint")
    @HttpApiDoc(doc="Archive closed or planned sprint. This operation can be performed by board owners or other members who are granted permission to manage boards in a project.")
    @Rights(rights={ManageBoard.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object archiveSprint(@NotNull SprintIdentifier var1, @NotNull Continuation<? super Unit> var2);

    @Nullable
    public Object projectSprintsInternal(@NotNull ProjectIdentifier var1, @NotNull BatchInfo var2, @Nullable BoardIdentifier var3, @Nullable String var4, boolean var5, @NotNull Continuation<? super Batch<Ref<SprintRecord>>> var6);

    @Rights(rights={ViewBoard.class})
    @Nullable
    public Object findSprintOrGetCurrent(@NotNull ProjectIdentifier var1, @NotNull BoardIdentifier var2, @Nullable String var3, @NotNull Continuation<? super Ref<SprintRecord>> var4);

    @Rights(rights={ViewBoard.class})
    @ApiFlagAnnotation(cls=Flags.FindBoardAndSprintOrDefault.class)
    @Nullable
    public Object findBoardAndSprintOrDefault(@NotNull ProjectIdentifier var1, @Nullable String var2, @Nullable String var3, @NotNull Continuation<? super Pair<Ref<BoardRecord>, Ref<SprintRecord>>> var4);

    @Rights(rights={ViewBoard.class})
    @ApiFlagAnnotation(cls=Flags.BoardsV2.class)
    @Nullable
    public Object preloadBoardAndIssues(@NotNull ProjectIdentifier var1, @Nullable String var2, @Nullable String var3, @Nullable Integer var4, @NotNull Continuation<? super InitialIssueBoardState> var5);

    @Rights(rights={ViewBoard.class})
    @Nullable
    public Object findSprints(@NotNull ProjectIdentifier var1, @NotNull BatchInfo var2, @NotNull List<String> var3, @ApiFlagAnnotation(cls=Flags.SearchBoardWithDeleted.class) @Nullable Boolean var4, @NotNull Continuation<? super Batch<Ref<SprintRecord>>> var5);

    @Rights(rights={ManageBoard.class})
    @Nullable
    public Object createSwimlane(@NotNull String var1, @NotNull String var2, @NotNull Continuation<? super Ref<SwimlaneRecord>> var3);

    @Rights(rights={ManageBoard.class})
    @Nullable
    public Object removeSwimlane(@NotNull String var1, @NotNull Continuation<? super Unit> var2);

    @Rights(rights={ManageBoard.class})
    @Nullable
    public Object updateSwimlane(@NotNull String var1, @Nullable String var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Create(path="projects/planning/boards/sprints/{sprint}/issues/{issue}", displayName="Add issue to sprint")
    @HttpApiDoc(doc="Add an existing issue in a project to a sprint")
    @Rights(rights={EditBoardContent.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object addIssueToSprint(@NotNull IssueIdentifier var1, @NotNull SprintIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Delete(path="projects/planning/boards/sprints/{sprint}/issues/{issue}", displayName="Remove issue from sprint")
    @HttpApiDoc(doc="Remove an existing issue in a project from a sprint.")
    @Rights(rights={EditBoardContent.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object removeIssueFromSprint(@NotNull IssueIdentifier var1, @NotNull SprintIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Create(path="projects/planning/boards/{board}/issues/{issue}", displayName="Add issue to board")
    @HttpApiDoc(doc="Add an existing issue in a project to a board or its current sprint")
    @Rights(rights={EditBoardContent.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object addIssueToBoard(@NotNull IssueIdentifier var1, @NotNull BoardIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Delete(path="projects/planning/boards/{board}/issues/{issue}", displayName="Remove issue from board")
    @HttpApiDoc(doc="Remove an existing issue in a project from a board or all of its sprints")
    @Rights(rights={EditBoardContent.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object removeIssueFromBoard(@NotNull IssueIdentifier var1, @NotNull BoardIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Rest.Query(path="projects/planning/boards/{board}/issues", displayName="Get all issues on board")
    @HttpApiDoc(doc="Fetch issues from the board across all its non-archived sprints")
    @Rights(rights={ViewBoard.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object boardIssues(@NotNull BoardIdentifier var1, @NotNull BatchInfo var2, @NotNull Continuation<? super Batch<Ref<Issue>>> var3);

    @Rest.Query(path="projects/planning/boards/sprints/{sprint}/issues", displayName="Get all issues in sprint")
    @HttpApiDoc(doc="Fetch issues from an existing non-archived sprint")
    @Rights(rights={ViewBoard.class})
    @DefaultParameterValues(params={@DefaultParameterValues.Param(name="unresolvedOnly", defaultValue="false")})
    @Nullable
    public Object sprintIssues(@NotNull SprintIdentifier var1, @NotNull BatchInfo var2, boolean var3, @NotNull Continuation<? super Batch<Ref<Issue>>> var4);

    @Rights(rights={EditBoardContent.class})
    @ApiFlagAnnotation(cls=Flags.Backlog.class)
    @Nullable
    public Object setBacklogsToIssue(@NotNull ProjectIdentifier var1, @NotNull IssueIdentifier var2, @NotNull List<? extends BacklogIdentifier> var3, boolean var4, @NotNull Continuation<? super Unit> var5);

    @Rights(rights={EditBoardContent.class})
    @ApiFlagAnnotation(cls=Flags.Backlog.class)
    @Nullable
    public Object setBacklogsToIssues(@NotNull ProjectIdentifier var1, @NotNull List<? extends IssueIdentifier> var2, @NotNull List<? extends BacklogIdentifier> var3, boolean var4, @NotNull Continuation<? super Unit> var5);

    @Rights(rights={EditBoardContent.class})
    @ApiFlagAnnotation(cls=Flags.Backlog.class)
    @Nullable
    public Object addIssuesToBacklogs(@NotNull ProjectIdentifier var1, @NotNull List<? extends IssueIdentifier> var2, @NotNull List<? extends BacklogIdentifier> var3, boolean var4, @NotNull Continuation<? super Unit> var5);

    @Rights(rights={EditBoardContent.class})
    @ApiFlagAnnotation(cls=Flags.Backlog.class)
    @Nullable
    public Object removeIssuesFromBacklogs(@NotNull ProjectIdentifier var1, @NotNull List<? extends IssueIdentifier> var2, @NotNull List<? extends BacklogIdentifier> var3, boolean var4, @NotNull Continuation<? super Unit> var5);

    @ApiFlagAnnotation(cls=Flags.BacklogIssueIdList.class)
    @Nullable
    public Object getBacklogIssueRefs(@NotNull BacklogIdentifier var1, @Nullable IssueSearchExpression var2, @NotNull BatchInfo var3, @NotNull Continuation<? super Batch<Ref<Issue>>> var4);

    @ApiFlagAnnotation(cls=Flags.BacklogIssueIdList.class)
    @Nullable
    public Object getBacklogIssueLazyRefs(@NotNull BacklogIdentifier var1, @Nullable IssueSearchExpression var2, @NotNull BatchInfo var3, @NotNull Continuation<? super Batch<Issues.LazyIssueRef>> var4);

    @ApiFlagAnnotation(cls=Flags.BacklogChangeIssuePosition.class)
    @Nullable
    public Object changeIssuePositionInBacklog(@NotNull BacklogIdentifier var1, @NotNull List<? extends IssueIdentifier> var2, @Nullable IssueIdentifier var3, @NotNull Continuation<? super Unit> var4);

    @Rights(rights={EditBoardContent.class})
    @Nullable
    public Object updateIssueSprints(@NotNull ProjectIdentifier var1, @NotNull IssueIdentifier var2, @NotNull List<? extends SprintIdentifier> var3, @NotNull Continuation<? super Unit> var4);

    @Nullable
    public Object bulkUpdateIssuesSprints(@NotNull ProjectIdentifier var1, @NotNull List<? extends IssueIdentifier> var2, @NotNull List<? extends SprintIdentifier> var3, boolean var4, @NotNull Continuation<? super Unit> var5);

    @Nullable
    public Object bulkAddIssuesSprints(@NotNull ProjectIdentifier var1, @NotNull List<? extends IssueIdentifier> var2, @NotNull List<? extends SprintIdentifier> var3, boolean var4, @NotNull Continuation<? super Unit> var5);

    @Nullable
    public Object bulkRemoveIssuesSprints(@NotNull ProjectIdentifier var1, @NotNull List<? extends IssueIdentifier> var2, @NotNull List<? extends SprintIdentifier> var3, boolean var4, @NotNull Continuation<? super Unit> var5);

    @Rights(rights={EditBoardContent.class})
    @Nullable
    public Object addIssueToSwimlane(@NotNull IssueIdentifier var1, @NotNull String var2, @NotNull Continuation<? super Unit> var3);

    @Rights(rights={EditBoardContent.class})
    @Nullable
    public Object removeIssueFromSwimlane(@NotNull IssueIdentifier var1, @NotNull String var2, @NotNull Continuation<? super Unit> var3);

    @Rights(rights={ViewBoard.class})
    @Nullable
    public Object starredBoardsWidgets(@NotNull ProjectIdentifier var1, @NotNull Continuation<? super Ref<BoardWidgetRecord>[]> var2);

    @Rights(rights={ViewBoard.class})
    @Nullable
    public Object getBoardsAndSprintsInProject(@NotNull ProjectIdentifier var1, @NotNull BatchInfo var2, @Nullable String var3, @NotNull Continuation<? super Batch<? extends BoardSprintsFilterValue>> var4);

    @Rights(rights={ViewBoard.class})
    @Nullable
    public Object getSprintsCount(@NotNull ProjectIdentifier var1, @NotNull BoardIdentifier var2, boolean var3, @NotNull Continuation<? super Integer> var4);

    @Rights(rights={ViewBoard.class})
    @ApiFlagAnnotation(cls=Flags.BoardSelectorValues.class)
    @Nullable
    public Object getBoardSelectorValues(@NotNull ProjectIdentifier var1, @NotNull BatchInfo var2, @Nullable String var3, @NotNull Continuation<? super Batch<? extends IssueBoardSelectorValue>> var4);

    @Rights(rights={ViewBoard.class})
    @ApiFlagAnnotation(cls=Flags.AllTagsInSprint.class)
    @Nullable
    public Object allTagsInSprint(@NotNull ProjectIdentifier var1, @NotNull SprintIdentifier var2, @NotNull Continuation<? super List<Ref<PlanningTag>>> var3);

    @Rights(rights={ViewBoard.class})
    @ApiFlagAnnotation(cls=Flags.FindBacklogs.class)
    @Nullable
    public Object findBacklogs(@NotNull ProjectIdentifier var1, @NotNull BatchInfo var2, @NotNull List<? extends BacklogIdentifier> var3, boolean var4, @NotNull Continuation<? super Batch<Ref<BoardBacklog>>> var5);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static /* synthetic */ Object createBoardInProject$default(Boards boards, ProjectIdentifier projectIdentifier2, String string2, String string3, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createBoardInProject");
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            return boards.createBoardInProject(projectIdentifier2, string2, string3, (Continuation<? super Ref<BoardRecord>>)continuation);
        }

        public static /* synthetic */ Object updateBoard$default(Boards boards, BoardIdentifier boardIdentifier, String string2, KOption kOption, KOption kOption2, BoardColumns boardColumns, List list2, List list3, List list4, BacklogTypeIn backlogTypeIn, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateBoard");
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                kOption = KOption.Companion.none();
            }
            if ((n & 8) != 0) {
                kOption2 = KOption.Companion.none();
            }
            if ((n & 0x10) != 0) {
                boardColumns = null;
            }
            if ((n & 0x20) != 0) {
                list2 = null;
            }
            if ((n & 0x40) != 0) {
                list3 = null;
            }
            if ((n & 0x80) != 0) {
                list4 = null;
            }
            if ((n & 0x100) != 0) {
                backlogTypeIn = null;
            }
            return boards.updateBoard(boardIdentifier, string2, kOption, kOption2, boardColumns, list2, list3, list4, backlogTypeIn, (Continuation<? super Unit>)continuation);
        }

        @Rest.Delete(path="projects/{project}/planning/boards/{board}/archive", displayName="Archive board")
        @HttpApiDoc(doc="Archive an existing board. This operation can be performed by board owners or other members who are granted permission to manage boards in a project.")
        @Rights(rights={ManageBoard.class})
        @HttpApiDeprecated(message="Use DELETE /projects/planning/boards/{board} instead", since="2021-12-22")
        @Deprecated(message="Use archiveBoard(board) instead", replaceWith=@ReplaceWith(expression="archiveBoard(board)", imports={}))
        @DefaultParameterValues(params={})
        @Nullable
        public static Object archiveBoardInProject(@NotNull Boards $this, @NotNull ProjectIdentifier project2, @NotNull BoardIdentifier board, @NotNull Continuation<? super Unit> $completion) {
            Object object = $this.archiveBoard(board, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        public static /* synthetic */ Object findBoards$default(Boards boards, ProjectIdentifier projectIdentifier2, BatchInfo batchInfo, List list2, Boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBoards");
            }
            if ((n & 8) != 0) {
                bl = null;
            }
            return boards.findBoards(projectIdentifier2, batchInfo, list2, bl, (Continuation<? super Batch<Ref<BoardRecord>>>)continuation);
        }

        public static /* synthetic */ Object createSprint$default(Boards boards, BoardIdentifier boardIdentifier, String string2, String string3, KotlinXDate kotlinXDate, KotlinXDate kotlinXDate2, SprintLaunch sprintLaunch, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createSprint");
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 0x20) != 0) {
                sprintLaunch = SprintLaunch.Manual.INSTANCE;
            }
            return boards.createSprint(boardIdentifier, string2, string3, kotlinXDate, kotlinXDate2, sprintLaunch, (Continuation<? super Ref<SprintRecord>>)continuation);
        }

        public static /* synthetic */ Object projectSprints$default(Boards boards, ProjectIdentifier projectIdentifier2, BatchInfo batchInfo, BoardIdentifier boardIdentifier, String string2, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: projectSprints");
            }
            if ((n & 4) != 0) {
                boardIdentifier = null;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            return boards.projectSprints(projectIdentifier2, batchInfo, boardIdentifier, string2, (Continuation<? super Batch<Ref<SprintRecord>>>)continuation);
        }

        public static /* synthetic */ Object updateSprint$default(Boards boards, SprintIdentifier sprintIdentifier, String string2, KOption kOption, KotlinXDate kotlinXDate, KotlinXDate kotlinXDate2, SprintLaunch sprintLaunch, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateSprint");
            }
            if ((n & 4) != 0) {
                kOption = KOption.Companion.none();
            }
            return boards.updateSprint(sprintIdentifier, string2, kOption, kotlinXDate, kotlinXDate2, sprintLaunch, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object launchPlannedSprint$default(Boards boards, SprintIdentifier sprintIdentifier, boolean bl, boolean bl2, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: launchPlannedSprint");
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            return boards.launchPlannedSprint(sprintIdentifier, bl, bl2, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object projectSprintsInternal$default(Boards boards, ProjectIdentifier projectIdentifier2, BatchInfo batchInfo, BoardIdentifier boardIdentifier, String string2, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: projectSprintsInternal");
            }
            if ((n & 4) != 0) {
                boardIdentifier = null;
            }
            if ((n & 8) != 0) {
                string2 = null;
            }
            if ((n & 0x10) != 0) {
                bl = true;
            }
            return boards.projectSprintsInternal(projectIdentifier2, batchInfo, boardIdentifier, string2, bl, (Continuation<? super Batch<Ref<SprintRecord>>>)continuation);
        }

        public static /* synthetic */ Object findSprints$default(Boards boards, ProjectIdentifier projectIdentifier2, BatchInfo batchInfo, List list2, Boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findSprints");
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            return boards.findSprints(projectIdentifier2, batchInfo, list2, bl, (Continuation<? super Batch<Ref<SprintRecord>>>)continuation);
        }

        public static /* synthetic */ Object sprintIssues$default(Boards boards, SprintIdentifier sprintIdentifier, BatchInfo batchInfo, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sprintIssues");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return boards.sprintIssues(sprintIdentifier, batchInfo, bl, (Continuation<? super Batch<Ref<Issue>>>)continuation);
        }

        public static /* synthetic */ Object setBacklogsToIssue$default(Boards boards, ProjectIdentifier projectIdentifier2, IssueIdentifier issueIdentifier, List list2, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setBacklogsToIssue");
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return boards.setBacklogsToIssue(projectIdentifier2, issueIdentifier, list2, bl, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object setBacklogsToIssues$default(Boards boards, ProjectIdentifier projectIdentifier2, List list2, List list3, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setBacklogsToIssues");
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return boards.setBacklogsToIssues(projectIdentifier2, list2, list3, bl, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object addIssuesToBacklogs$default(Boards boards, ProjectIdentifier projectIdentifier2, List list2, List list3, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addIssuesToBacklogs");
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return boards.addIssuesToBacklogs(projectIdentifier2, list2, list3, bl, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object removeIssuesFromBacklogs$default(Boards boards, ProjectIdentifier projectIdentifier2, List list2, List list3, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeIssuesFromBacklogs");
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return boards.removeIssuesFromBacklogs(projectIdentifier2, list2, list3, bl, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object bulkUpdateIssuesSprints$default(Boards boards, ProjectIdentifier projectIdentifier2, List list2, List list3, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bulkUpdateIssuesSprints");
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return boards.bulkUpdateIssuesSprints(projectIdentifier2, list2, list3, bl, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object bulkAddIssuesSprints$default(Boards boards, ProjectIdentifier projectIdentifier2, List list2, List list3, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bulkAddIssuesSprints");
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return boards.bulkAddIssuesSprints(projectIdentifier2, list2, list3, bl, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object bulkRemoveIssuesSprints$default(Boards boards, ProjectIdentifier projectIdentifier2, List list2, List list3, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bulkRemoveIssuesSprints");
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            return boards.bulkRemoveIssuesSprints(projectIdentifier2, list2, list3, bl, (Continuation<? super Unit>)continuation);
        }

        public static /* synthetic */ Object getSprintsCount$default(Boards boards, ProjectIdentifier projectIdentifier2, BoardIdentifier boardIdentifier, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSprintsCount");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            return boards.getSprintsCount(projectIdentifier2, boardIdentifier, bl, (Continuation<? super Integer>)continuation);
        }

        public static /* synthetic */ Object findBacklogs$default(Boards boards, ProjectIdentifier projectIdentifier2, BatchInfo batchInfo, List list2, boolean bl, Continuation continuation, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBacklogs");
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            return boards.findBacklogs(projectIdentifier2, batchInfo, list2, bl, (Continuation<? super Batch<Ref<BoardBacklog>>>)continuation);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u0003\u0004\u0005\u0006\u0007\b\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\f"}, d2={"Lcirclet/planning/Boards$Flags;", "Lplatform/common/ApiFlags;", "()V", "AllTagsInSprint", "Backlog", "BacklogChangeIssuePosition", "BacklogIssueIdList", "BoardSelectorValues", "BoardsV2", "FindBacklogs", "FindBoardAndSprintOrDefault", "SearchBoardWithDeleted", "planning-api"})
    public static final class Flags
    extends ApiFlags {
        @NotNull
        public static final Flags INSTANCE = new Flags();

        private Flags() {
            super("boards");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$AllTagsInSprint;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class AllTagsInSprint
        extends ApiFlag {
            @NotNull
            public static final AllTagsInSprint INSTANCE = new AllTagsInSprint();

            private AllTagsInSprint() {
                super(1, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_1());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$Backlog;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class Backlog
        extends ApiFlag {
            @NotNull
            public static final Backlog INSTANCE = new Backlog();

            private Backlog() {
                super(5, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_3());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$BacklogChangeIssuePosition;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class BacklogChangeIssuePosition
        extends ApiFlag {
            @NotNull
            public static final BacklogChangeIssuePosition INSTANCE = new BacklogChangeIssuePosition();

            private BacklogChangeIssuePosition() {
                super(8, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_3());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$BacklogIssueIdList;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class BacklogIssueIdList
        extends ApiFlag {
            @NotNull
            public static final BacklogIssueIdList INSTANCE = new BacklogIssueIdList();

            private BacklogIssueIdList() {
                super(7, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_3());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$BoardSelectorValues;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class BoardSelectorValues
        extends ApiFlag {
            @NotNull
            public static final BoardSelectorValues INSTANCE = new BoardSelectorValues();

            private BoardSelectorValues() {
                super(6, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_3());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$BoardsV2;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class BoardsV2
        extends ApiFlag {
            @NotNull
            public static final BoardsV2 INSTANCE = new BoardsV2();

            private BoardsV2() {
                super(3, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_2());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$FindBacklogs;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class FindBacklogs
        extends ApiFlag {
            @NotNull
            public static final FindBacklogs INSTANCE = new FindBacklogs();

            private FindBacklogs() {
                super(9, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_3());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$FindBoardAndSprintOrDefault;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class FindBoardAndSprintOrDefault
        extends ApiFlag {
            @NotNull
            public static final FindBoardAndSprintOrDefault INSTANCE = new FindBoardAndSprintOrDefault();

            private FindBoardAndSprintOrDefault() {
                super(2, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_1());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/planning/Boards$Flags$SearchBoardWithDeleted;", "Lplatform/common/ApiFlag;", "()V", "planning-api"})
        public static final class SearchBoardWithDeleted
        extends ApiFlag {
            @NotNull
            public static final SearchBoardWithDeleted INSTANCE = new SearchBoardWithDeleted();

            private SearchBoardWithDeleted() {
                super(4, INSTANCE, SpaceOnPremiseVersions.INSTANCE.getObsolete_v2023_2());
            }
        }
    }
}

