/*
 * Decompiled with CFR 0.152.
 */
package circlet.electron;

import circlet.electron.DownloadItemController;
import circlet.electron.DownloadItemInfo;
import circlet.electron.DownloadItemState;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.coroutines.extra.LifetimeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.reactive.PropertyKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010$\u001a\u00020\nJ\u0006\u0010%\u001a\u00020\nJ\u0006\u0010&\u001a\u00020\nJ\u0006\u0010'\u001a\u00020\nR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0014\u00a8\u0006("}, d2={"Lcirclet/electron/DownloadItemVm;", "", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "controller", "Lcirclet/electron/DownloadItemController;", "item", "Lcirclet/electron/DownloadItemInfo;", "onPathDefined", "Lkotlin/Function1;", "", "(Llibraries/coroutines/extra/Lifetime;Lcirclet/electron/DownloadItemController;Lcirclet/electron/DownloadItemInfo;Lkotlin/jvm/functions/Function1;)V", "alertLifetime", "Llibraries/coroutines/extra/LifetimeSource;", "getAlertLifetime", "()Llibraries/coroutines/extra/LifetimeSource;", "errorMessage", "Lruntime/reactive/MutableProperty;", "", "getErrorMessage", "()Lruntime/reactive/MutableProperty;", "fileName", "getFileName", "itemId", "getItemId", "()Ljava/lang/String;", "path", "getPath", "receivedBytes", "", "getReceivedBytes", "state", "Lcirclet/electron/DownloadItemState;", "getState", "totalBytes", "getTotalBytes", "cancelItem", "openInFolder", "pauseItem", "resumeItem", "app-state"})
public final class DownloadItemVm {
    @NotNull
    private final DownloadItemController controller;
    @NotNull
    private final String itemId;
    @NotNull
    private final MutableProperty<String> fileName;
    @NotNull
    private final MutableProperty<String> path;
    @NotNull
    private final MutableProperty<Long> totalBytes;
    @NotNull
    private final MutableProperty<Long> receivedBytes;
    @NotNull
    private final MutableProperty<DownloadItemState> state;
    @NotNull
    private final MutableProperty<String> errorMessage;
    @NotNull
    private final LifetimeSource alertLifetime;

    public DownloadItemVm(@NotNull Lifetime lifetime, @NotNull DownloadItemController controller, @NotNull DownloadItemInfo item2, final @NotNull Function1<? super DownloadItemVm, Unit> onPathDefined) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        Intrinsics.checkNotNullParameter(onPathDefined, (String)"onPathDefined");
        this.controller = controller;
        this.itemId = item2.getId();
        this.fileName = PropertyKt.mutableProperty(item2.getFileName());
        this.path = PropertyKt.mutableProperty(item2.getPath());
        this.totalBytes = PropertyKt.mutableProperty(item2.getTotalBytes());
        this.receivedBytes = PropertyKt.mutableProperty(item2.getReceivedBytes());
        this.state = PropertyKt.mutableProperty(item2.isPaused() ? DownloadItemState.Paused : DownloadItemState.Created);
        this.errorMessage = PropertyKt.mutableProperty(null);
        this.alertLifetime = LifetimeUtilsKt.nested(lifetime);
        this.path.forEachWithPrevious(lifetime, (Function2<String, String, Unit>)((Function2)new Function2<String, String, Unit>(){

            public final void invoke(@Nullable String prev, @NotNull String curr) {
                Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
                CharSequence charSequence = prev;
                if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !StringsKt.isBlank((CharSequence)curr)) {
                    onPathDefined.invoke((Object)this);
                    this.resumeItem();
                }
            }
        }));
    }

    @NotNull
    public final String getItemId() {
        return this.itemId;
    }

    @NotNull
    public final MutableProperty<String> getFileName() {
        return this.fileName;
    }

    @NotNull
    public final MutableProperty<String> getPath() {
        return this.path;
    }

    @NotNull
    public final MutableProperty<Long> getTotalBytes() {
        return this.totalBytes;
    }

    @NotNull
    public final MutableProperty<Long> getReceivedBytes() {
        return this.receivedBytes;
    }

    @NotNull
    public final MutableProperty<DownloadItemState> getState() {
        return this.state;
    }

    @NotNull
    public final MutableProperty<String> getErrorMessage() {
        return this.errorMessage;
    }

    @NotNull
    public final LifetimeSource getAlertLifetime() {
        return this.alertLifetime;
    }

    public final void pauseItem() {
        if (this.state.getValue() == DownloadItemState.Created || this.state.getValue() == DownloadItemState.InProgress) {
            this.state.setValue(DownloadItemState.Paused);
            this.controller.pause(this.itemId);
        }
    }

    public final void cancelItem() {
        if (!this.state.getValue().isTerminal()) {
            this.state.setValue(DownloadItemState.Cancelled);
            this.controller.cancel(this.itemId);
        }
    }

    public final void resumeItem() {
        if (this.state.getValue() == DownloadItemState.Paused) {
            this.state.setValue(DownloadItemState.InProgress);
            this.controller.resume(this.itemId);
        }
    }

    public final void openInFolder() {
        if (this.state.getValue() == DownloadItemState.Completed) {
            this.controller.openInFolder(this.path.getValue());
        }
    }
}

