/*
 * Decompiled with CFR 0.152.
 */
package circlet.documents;

import circlet.client.api.DocumentFolder;
import circlet.client.api.DocumentLocation;
import circlet.client.api.DocumentsFolderLocation;
import circlet.client.api.DocumentsLocation;
import circlet.client.api.DocumentsTabsLocation;
import circlet.client.api.FolderIdentifier;
import circlet.client.api.Navigator;
import circlet.client.api.documents.DocumentsSearchHighlights;
import circlet.common.documents.DocumentPermissionChecker;
import circlet.common.documents.DocumentPermissions;
import circlet.common.documents.FolderPermissionChecker;
import circlet.common.documents.FolderPermissions;
import circlet.documents.DocumentsTreeItemKt;
import circlet.documents.SharedFolderPermissions;
import circlet.platform.api.Ref;
import circlet.platform.client.ArenaManagerKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.Lifetimed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellableKt;
import runtime.reactive.Property;
import runtime.reactive.PropertyKt;
import runtime.reactive.XTrackableLifetimed;
import runtime.routing.Location;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006#$%&'(B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u0019H&J\u0013\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\u0014\u0010\u001e\u001a\u00020\u00192\n\u0010\u001f\u001a\u00060\u0010j\u0002` H&J\b\u0010!\u001a\u00020\"H\u0016R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007\u0082\u0001\u0002)*\u00a8\u0006+"}, d2={"Lcirclet/documents/DocumentsTreeItem;", "Llibraries/coroutines/extra/Lifetimed;", "()V", "documentsLocation", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentsLocation;", "getDocumentsLocation", "()Lruntime/reactive/Property;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "getDocumentsTabsLocation", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "key", "", "getKey", "()Ljava/lang/String;", "location", "Lruntime/routing/Location;", "getLocation", "name", "getName", "canDrag", "", "canDropInto", "equals", "other", "", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "hashCode", "", "Document", "Folder", "ItemsContainer", "ItemsContainerWithFolder", "RootFolder", "SharedWithMe", "Lcirclet/documents/DocumentsTreeItem$Document;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainer;", "app-state"})
public abstract class DocumentsTreeItem
implements Lifetimed {
    private DocumentsTreeItem() {
    }

    @NotNull
    public abstract String getKey();

    @NotNull
    public abstract Property<String> getName();

    @NotNull
    public abstract Property<DocumentsLocation> getDocumentsLocation();

    @NotNull
    public abstract Property<DocumentsTabsLocation> getDocumentsTabsLocation();

    @NotNull
    public abstract Property<Location> getLocation();

    @Nullable
    public abstract DocumentsSearchHighlights getHighlights();

    public abstract boolean canDrag();

    public abstract boolean canDropInto();

    public abstract boolean hasParent(@NotNull String var1);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocumentsTreeItem)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getKey(), (Object)((DocumentsTreeItem)other).getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public /* synthetic */ DocumentsTreeItem(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0014\u0010%\u001a\u00020#2\n\u0010&\u001a\u00060\u0017j\u0002`'H\u0016J\b\u0010(\u001a\u00020\u0017H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0011R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0011\u00a8\u0006)"}, d2={"Lcirclet/documents/DocumentsTreeItem$Document;", "Lcirclet/documents/DocumentsTreeItem;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "document", "Lruntime/reactive/Property;", "Lcirclet/client/api/Document;", "documentsLocation", "Lcirclet/client/api/DocumentsLocation;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "permissionsChecker", "Lcirclet/common/documents/DocumentPermissionChecker;", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lcirclet/client/api/documents/DocumentsSearchHighlights;)V", "getDocument", "()Lruntime/reactive/Property;", "getDocumentsLocation", "getDocumentsTabsLocation", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "key", "", "getKey", "()Ljava/lang/String;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "location", "Lcirclet/client/api/DocumentLocation;", "getLocation", "name", "getName", "getPermissionsChecker", "canDrag", "", "canDropInto", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "toString", "app-state"})
    public static final class Document
    extends DocumentsTreeItem {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Property<circlet.client.api.Document> document;
        @NotNull
        private final Property<DocumentsLocation> documentsLocation;
        @NotNull
        private final Property<DocumentsTabsLocation> documentsTabsLocation;
        @NotNull
        private final Property<DocumentPermissionChecker> permissionsChecker;
        @Nullable
        private final DocumentsSearchHighlights highlights;
        @NotNull
        private final Property<String> name;
        @NotNull
        private final Property<DocumentLocation> location;

        public Document(@NotNull Lifetime lifetime, @NotNull Property<circlet.client.api.Document> document2, @NotNull Property<? extends DocumentsLocation> documentsLocation, @NotNull Property<? extends DocumentsTabsLocation> documentsTabsLocation, @NotNull Property<? extends DocumentPermissionChecker> permissionsChecker, @Nullable DocumentsSearchHighlights highlights) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(document2, (String)"document");
            Intrinsics.checkNotNullParameter(documentsLocation, (String)"documentsLocation");
            Intrinsics.checkNotNullParameter(documentsTabsLocation, (String)"documentsTabsLocation");
            Intrinsics.checkNotNullParameter(permissionsChecker, (String)"permissionsChecker");
            super(null);
            this.lifetime = lifetime;
            this.document = document2;
            this.documentsLocation = documentsLocation;
            this.documentsTabsLocation = documentsTabsLocation;
            this.permissionsChecker = permissionsChecker;
            this.highlights = highlights;
            this.name = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, String>(this){
                final /* synthetic */ Document this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    return $this$derived.getLive(this.this$0.getDocument()).notEmptyTitle();
                }
            }, 1, null);
            this.location = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, DocumentLocation>(this){
                final /* synthetic */ Document this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final DocumentLocation invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    return Navigator.INSTANCE.getDocuments().document($this$derived.getLive(this.this$0.getDocument()));
                }
            }, 1, null);
        }

        public /* synthetic */ Document(Lifetime lifetime, Property property2, Property property3, Property property4, Property property5, DocumentsSearchHighlights documentsSearchHighlights, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                documentsSearchHighlights = null;
            }
            this(lifetime, property2, property3, property4, property5, documentsSearchHighlights);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final Property<circlet.client.api.Document> getDocument() {
            return this.document;
        }

        @Override
        @NotNull
        public Property<DocumentsLocation> getDocumentsLocation() {
            return this.documentsLocation;
        }

        @Override
        @NotNull
        public Property<DocumentsTabsLocation> getDocumentsTabsLocation() {
            return this.documentsTabsLocation;
        }

        @NotNull
        public final Property<DocumentPermissionChecker> getPermissionsChecker() {
            return this.permissionsChecker;
        }

        @Override
        @Nullable
        public DocumentsSearchHighlights getHighlights() {
            return this.highlights;
        }

        @Override
        @NotNull
        public String getKey() {
            return "d-" + this.document.getValue().getId();
        }

        @Override
        @NotNull
        public Property<String> getName() {
            return this.name;
        }

        @NotNull
        public Property<DocumentLocation> getLocation() {
            return this.location;
        }

        @Override
        public boolean canDrag() {
            return DocumentPermissions.INSTANCE.canBeMoved(this.permissionsChecker.getValue());
        }

        @Override
        public boolean canDropInto() {
            return false;
        }

        @Override
        public boolean hasParent(@NotNull String folderId) {
            Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
            Ref<DocumentFolder> ref2 = this.document.getValue().getFolderRef();
            return ref2 != null ? DocumentsTreeItemKt.access$hasParent(ref2, folderId) : false;
        }

        @NotNull
        public String toString() {
            return this.getName().getValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010,\u001a\u00020\u0011H\u0016J\b\u0010-\u001a\u00020\u0011H\u0016J\u0014\u0010.\u001a\u00020\u00112\n\u0010/\u001a\u00060!j\u0002`0H\u0016J\b\u00101\u001a\u00020!H\u0016R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0013R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020!0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0013R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0013\u00a8\u00062"}, d2={"Lcirclet/documents/DocumentsTreeItem$Folder;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainerWithFolder;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "folder", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentFolder;", "documentsLocation", "Lcirclet/client/api/DocumentsLocation;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "permissionsChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lcirclet/client/api/documents/DocumentsSearchHighlights;)V", "deleted", "", "getDeleted", "()Lruntime/reactive/Property;", "description", "Lcirclet/client/api/Document;", "getDescription", "getDocumentsLocation", "getDocumentsTabsLocation", "getFolder", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "identifier", "Lcirclet/client/api/FolderIdentifier$Id;", "getIdentifier", "()Lcirclet/client/api/FolderIdentifier$Id;", "key", "", "getKey", "()Ljava/lang/String;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "location", "Lcirclet/client/api/DocumentsFolderLocation;", "getLocation", "name", "getName", "getPermissionsChecker", "canDrag", "canDropInto", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "toString", "app-state"})
    public static final class Folder
    extends ItemsContainerWithFolder {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Property<DocumentFolder> folder;
        @NotNull
        private final Property<DocumentsLocation> documentsLocation;
        @NotNull
        private final Property<DocumentsTabsLocation> documentsTabsLocation;
        @NotNull
        private final Property<FolderPermissionChecker> permissionsChecker;
        @Nullable
        private final DocumentsSearchHighlights highlights;
        @NotNull
        private final Property<String> name;
        @NotNull
        private final FolderIdentifier.Id identifier;
        @NotNull
        private final Property<DocumentsFolderLocation> location;
        @NotNull
        private final Property<circlet.client.api.Document> description;
        @NotNull
        private final Property<Boolean> deleted;

        public Folder(@NotNull Lifetime lifetime, @NotNull Property<DocumentFolder> folder, @NotNull Property<? extends DocumentsLocation> documentsLocation, @NotNull Property<? extends DocumentsTabsLocation> documentsTabsLocation, @NotNull Property<? extends FolderPermissionChecker> permissionsChecker, @Nullable DocumentsSearchHighlights highlights) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(folder, (String)"folder");
            Intrinsics.checkNotNullParameter(documentsLocation, (String)"documentsLocation");
            Intrinsics.checkNotNullParameter(documentsTabsLocation, (String)"documentsTabsLocation");
            Intrinsics.checkNotNullParameter(permissionsChecker, (String)"permissionsChecker");
            super(null);
            this.lifetime = lifetime;
            this.folder = folder;
            this.documentsLocation = documentsLocation;
            this.documentsTabsLocation = documentsTabsLocation;
            this.permissionsChecker = permissionsChecker;
            this.highlights = highlights;
            this.name = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, String>(this){
                final /* synthetic */ Folder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    return $this$derived.getLive(this.this$0.getFolder()).getName();
                }
            }, 1, null);
            this.identifier = new FolderIdentifier.Id(this.getFolder().getValue().getId());
            this.location = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, DocumentsFolderLocation>(this){
                final /* synthetic */ Folder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final DocumentsFolderLocation invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    return DocumentsLocation.DefaultImpls.folder$default(Navigator.INSTANCE.getDocuments(), $this$derived.getLive(this.this$0.getFolder()).getAlias(), null, 2, null);
                }
            }, 1, null);
            this.description = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, circlet.client.api.Document>(this){
                final /* synthetic */ Folder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final circlet.client.api.Document invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Ref<circlet.client.api.Document> ref2;
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    Ref<circlet.client.api.Document> ref3 = $this$derived.getLive(this.this$0.getFolder()).getCover();
                    if (ref3 != null && (ref3 = ArenaManagerKt.property(ref3)) != null && (ref3 = (circlet.client.api.Document)$this$derived.getLive(ref3)) != null) {
                        Ref<circlet.client.api.Document> ref4;
                        Ref<circlet.client.api.Document> it = ref4 = ref3;
                        boolean bl = false;
                        ref2 = !((circlet.client.api.Document)((Object)it)).getArchived() ? ref4 : null;
                    } else {
                        ref2 = null;
                    }
                    return ref2;
                }
            }, 1, null);
            this.deleted = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, Boolean>(this){
                final /* synthetic */ Folder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    return $this$derived.getLive(this.this$0.getFolder()).getArchived();
                }
            }, 1, null);
        }

        public /* synthetic */ Folder(Lifetime lifetime, Property property2, Property property3, Property property4, Property property5, DocumentsSearchHighlights documentsSearchHighlights, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                documentsSearchHighlights = null;
            }
            this(lifetime, property2, property3, property4, property5, documentsSearchHighlights);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @Override
        @NotNull
        public Property<DocumentFolder> getFolder() {
            return this.folder;
        }

        @Override
        @NotNull
        public Property<DocumentsLocation> getDocumentsLocation() {
            return this.documentsLocation;
        }

        @Override
        @NotNull
        public Property<DocumentsTabsLocation> getDocumentsTabsLocation() {
            return this.documentsTabsLocation;
        }

        @Override
        @NotNull
        public Property<FolderPermissionChecker> getPermissionsChecker() {
            return this.permissionsChecker;
        }

        @Override
        @Nullable
        public DocumentsSearchHighlights getHighlights() {
            return this.highlights;
        }

        @Override
        @NotNull
        public String getKey() {
            return DocumentsTreeItemKt.treeKey(this.getFolder().getValue());
        }

        @Override
        @NotNull
        public Property<String> getName() {
            return this.name;
        }

        @Override
        @NotNull
        public FolderIdentifier.Id getIdentifier() {
            return this.identifier;
        }

        @Override
        @NotNull
        public Property<DocumentsFolderLocation> getLocation() {
            return this.location;
        }

        @Override
        public boolean canDrag() {
            return FolderPermissions.INSTANCE.canBeMoved(this.getPermissionsChecker().getValue());
        }

        @Override
        public boolean canDropInto() {
            return FolderPermissions.INSTANCE.canMoveTo(this.getPermissionsChecker().getValue());
        }

        @Override
        public boolean hasParent(@NotNull String folderId) {
            Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
            return DocumentsTreeItemKt.access$hasParent(this.getFolder().getValue(), folderId);
        }

        @Override
        @NotNull
        public Property<circlet.client.api.Document> getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Property<Boolean> getDeleted() {
            return this.deleted;
        }

        @NotNull
        public String toString() {
            return this.getName().getValue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcirclet/documents/DocumentsTreeItem$ItemsContainer;", "Lcirclet/documents/DocumentsTreeItem;", "()V", "deleted", "Lruntime/reactive/Property;", "", "getDeleted", "()Lruntime/reactive/Property;", "description", "Lcirclet/client/api/Document;", "getDescription", "identifier", "Lcirclet/client/api/FolderIdentifier;", "getIdentifier", "()Lcirclet/client/api/FolderIdentifier;", "location", "Lcirclet/client/api/DocumentsFolderLocation;", "getLocation", "permissionsChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "getPermissionsChecker", "Lcirclet/documents/DocumentsTreeItem$ItemsContainerWithFolder;", "Lcirclet/documents/DocumentsTreeItem$SharedWithMe;", "app-state"})
    public static abstract class ItemsContainer
    extends DocumentsTreeItem {
        private ItemsContainer() {
            super(null);
        }

        @NotNull
        public abstract Property<DocumentsFolderLocation> getLocation();

        @NotNull
        public abstract Property<FolderPermissionChecker> getPermissionsChecker();

        @NotNull
        public abstract FolderIdentifier getIdentifier();

        @NotNull
        public abstract Property<circlet.client.api.Document> getDescription();

        @NotNull
        public abstract Property<Boolean> getDeleted();

        public /* synthetic */ ItemsContainer(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lcirclet/documents/DocumentsTreeItem$ItemsContainerWithFolder;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainer;", "()V", "folder", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentFolder;", "getFolder", "()Lruntime/reactive/Property;", "Lcirclet/documents/DocumentsTreeItem$Folder;", "Lcirclet/documents/DocumentsTreeItem$RootFolder;", "app-state"})
    public static abstract class ItemsContainerWithFolder
    extends ItemsContainer {
        private ItemsContainerWithFolder() {
            super(null);
        }

        @NotNull
        public abstract Property<DocumentFolder> getFolder();

        public /* synthetic */ ItemsContainerWithFolder(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u00017BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\b\u0010,\u001a\u00020\u000fH\u0016J\b\u0010-\u001a\u00020\u000fH\u0016J\u0013\u0010.\u001a\u00020\u000f2\b\u0010/\u001a\u0004\u0018\u000100H\u0096\u0002J\u0014\u00101\u001a\u00020\u000f2\n\u00102\u001a\u00060!j\u0002`3H\u0016J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020!H\u0016R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0011R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020!0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0011R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0011\u00a8\u00068"}, d2={"Lcirclet/documents/DocumentsTreeItem$RootFolder;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainerWithFolder;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "folder", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentFolder;", "documentsLocation", "Lcirclet/client/api/DocumentsLocation;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "permissionsChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;Lruntime/reactive/Property;)V", "deleted", "", "getDeleted", "()Lruntime/reactive/Property;", "description", "Lcirclet/client/api/Document;", "getDescription", "getDocumentsLocation", "getDocumentsTabsLocation", "getFolder", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "identifier", "Lcirclet/client/api/FolderIdentifier;", "getIdentifier", "()Lcirclet/client/api/FolderIdentifier;", "key", "", "getKey", "()Ljava/lang/String;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "location", "Lcirclet/client/api/DocumentsFolderLocation;", "getLocation", "name", "getName", "getPermissionsChecker", "canDrag", "canDropInto", "equals", "other", "", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "hashCode", "", "toString", "Companion", "app-state"})
    public static final class RootFolder
    extends ItemsContainerWithFolder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Property<DocumentFolder> folder;
        @NotNull
        private final Property<DocumentsLocation> documentsLocation;
        @NotNull
        private final Property<DocumentsTabsLocation> documentsTabsLocation;
        @NotNull
        private final Property<FolderPermissionChecker> permissionsChecker;
        @NotNull
        private final String key;
        @NotNull
        private final Property<String> name;
        @NotNull
        private final Property<DocumentsFolderLocation> location;
        @NotNull
        private final FolderIdentifier identifier;
        @Nullable
        private final DocumentsSearchHighlights highlights;
        @NotNull
        private final Property<circlet.client.api.Document> description;
        @NotNull
        private final Property<Boolean> deleted;
        @NotNull
        public static final String ID = "root-folder";
        @NotNull
        public static final String NAME_IN_TREE = "Documents";

        public RootFolder(@NotNull Lifetime lifetime, @NotNull Property<DocumentFolder> folder, @NotNull Property<? extends DocumentsLocation> documentsLocation, @NotNull Property<? extends DocumentsTabsLocation> documentsTabsLocation, @NotNull Property<? extends FolderPermissionChecker> permissionsChecker) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(folder, (String)"folder");
            Intrinsics.checkNotNullParameter(documentsLocation, (String)"documentsLocation");
            Intrinsics.checkNotNullParameter(documentsTabsLocation, (String)"documentsTabsLocation");
            Intrinsics.checkNotNullParameter(permissionsChecker, (String)"permissionsChecker");
            super(null);
            this.lifetime = lifetime;
            this.folder = folder;
            this.documentsLocation = documentsLocation;
            this.documentsTabsLocation = documentsTabsLocation;
            this.permissionsChecker = permissionsChecker;
            this.key = ID;
            this.name = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, String>(this){
                final /* synthetic */ RootFolder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    return $this$derived.getLive(this.this$0.getFolder()).getName();
                }
            }, 1, null);
            this.location = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, DocumentsFolderLocation>(this){
                final /* synthetic */ RootFolder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final DocumentsFolderLocation invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    return $this$derived.getLive(this.this$0.getDocumentsTabsLocation()).getFolders();
                }
            }, 1, null);
            this.identifier = FolderIdentifier.Root.INSTANCE;
            this.description = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, circlet.client.api.Document>(this){
                final /* synthetic */ RootFolder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final circlet.client.api.Document invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Ref<circlet.client.api.Document> ref2;
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    Ref<circlet.client.api.Document> ref3 = $this$derived.getLive(this.this$0.getFolder()).getCover();
                    if (ref3 != null && (ref3 = ArenaManagerKt.property(ref3)) != null && (ref3 = (circlet.client.api.Document)$this$derived.getLive(ref3)) != null) {
                        Ref<circlet.client.api.Document> ref4;
                        Ref<circlet.client.api.Document> it = ref4 = ref3;
                        boolean bl = false;
                        ref2 = !((circlet.client.api.Document)((Object)it)).getArchived() ? ref4 : null;
                    } else {
                        ref2 = null;
                    }
                    return ref2;
                }
            }, 1, null);
            this.deleted = PropertyKt.property(false);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @Override
        @NotNull
        public Property<DocumentFolder> getFolder() {
            return this.folder;
        }

        @Override
        @NotNull
        public Property<DocumentsLocation> getDocumentsLocation() {
            return this.documentsLocation;
        }

        @Override
        @NotNull
        public Property<DocumentsTabsLocation> getDocumentsTabsLocation() {
            return this.documentsTabsLocation;
        }

        @Override
        @NotNull
        public Property<FolderPermissionChecker> getPermissionsChecker() {
            return this.permissionsChecker;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Property<String> getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Property<DocumentsFolderLocation> getLocation() {
            return this.location;
        }

        @Override
        @NotNull
        public FolderIdentifier getIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        public DocumentsSearchHighlights getHighlights() {
            return this.highlights;
        }

        @Override
        public boolean canDrag() {
            return false;
        }

        @Override
        public boolean canDropInto() {
            return FolderPermissions.INSTANCE.canMoveTo(this.getPermissionsChecker().getValue());
        }

        @Override
        public boolean hasParent(@NotNull String folderId) {
            Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
            return false;
        }

        @Override
        @NotNull
        public Property<circlet.client.api.Document> getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Property<Boolean> getDeleted() {
            return this.deleted;
        }

        @NotNull
        public String toString() {
            return this.getName().getValue();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof RootFolder && Intrinsics.areEqual((Object)((RootFolder)other).getKey(), (Object)this.getKey());
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcirclet/documents/DocumentsTreeItem$RootFolder$Companion;", "", "()V", "ID", "", "NAME_IN_TREE", "app-state"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0001/B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010)\u001a\u00020\u000bH\u0016J\b\u0010*\u001a\u00020\u000bH\u0016J\u0014\u0010+\u001a\u00020\u000b2\n\u0010,\u001a\u00060\u001cj\u0002`-H\u0016J\b\u0010.\u001a\u00020\u001cH\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\rR\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\r\u00a8\u00060"}, d2={"Lcirclet/documents/DocumentsTreeItem$SharedWithMe;", "Lcirclet/documents/DocumentsTreeItem$ItemsContainer;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "documentsLocation", "Lruntime/reactive/Property;", "Lcirclet/client/api/DocumentsLocation;", "documentsTabsLocation", "Lcirclet/client/api/DocumentsTabsLocation;", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/Property;Lruntime/reactive/Property;)V", "deleted", "", "getDeleted", "()Lruntime/reactive/Property;", "description", "", "getDescription", "getDocumentsLocation", "getDocumentsTabsLocation", "highlights", "Lcirclet/client/api/documents/DocumentsSearchHighlights;", "getHighlights", "()Lcirclet/client/api/documents/DocumentsSearchHighlights;", "identifier", "Lcirclet/client/api/FolderIdentifier;", "getIdentifier", "()Lcirclet/client/api/FolderIdentifier;", "key", "", "getKey", "()Ljava/lang/String;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "location", "Lcirclet/client/api/DocumentsFolderLocation;", "getLocation", "name", "getName", "permissionsChecker", "Lcirclet/common/documents/FolderPermissionChecker;", "getPermissionsChecker", "canDrag", "canDropInto", "hasParent", "folderId", "Lcirclet/platform/api/TID;", "toString", "Companion", "app-state"})
    public static final class SharedWithMe
    extends ItemsContainer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final Property<DocumentsLocation> documentsLocation;
        @NotNull
        private final Property<DocumentsTabsLocation> documentsTabsLocation;
        @NotNull
        private final String key;
        @NotNull
        private final Property<String> name;
        @NotNull
        private final Property<DocumentsFolderLocation> location;
        @NotNull
        private final Property<FolderPermissionChecker> permissionsChecker;
        @NotNull
        private final FolderIdentifier identifier;
        @Nullable
        private final DocumentsSearchHighlights highlights;
        @NotNull
        private final Property description;
        @NotNull
        private final Property<Boolean> deleted;
        @NotNull
        public static final String ID = "shared-with-me";
        @NotNull
        public static final String NAME = "Shared with me";

        public SharedWithMe(@NotNull Lifetime lifetime, @NotNull Property<? extends DocumentsLocation> documentsLocation, @NotNull Property<? extends DocumentsTabsLocation> documentsTabsLocation) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(documentsLocation, (String)"documentsLocation");
            Intrinsics.checkNotNullParameter(documentsTabsLocation, (String)"documentsTabsLocation");
            super(null);
            this.lifetime = lifetime;
            this.documentsLocation = documentsLocation;
            this.documentsTabsLocation = documentsTabsLocation;
            this.key = ID;
            this.name = PropertyKt.property(NAME);
            this.location = CellableKt.derived$default(this, false, (Function1)new Function1<XTrackableLifetimed, DocumentsFolderLocation>(this){
                final /* synthetic */ SharedWithMe this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final DocumentsFolderLocation invoke(@NotNull XTrackableLifetimed $this$derived) {
                    Intrinsics.checkNotNullParameter((Object)$this$derived, (String)"$this$derived");
                    return $this$derived.getLive(this.this$0.getDocumentsTabsLocation()).getFolders().getSharedWithMe();
                }
            }, 1, null);
            this.permissionsChecker = PropertyKt.property(SharedFolderPermissions.INSTANCE);
            this.identifier = FolderIdentifier.SharedWithMe.INSTANCE;
            this.description = PropertyKt.property(null);
            this.deleted = PropertyKt.property(false);
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            return this.lifetime;
        }

        @Override
        @NotNull
        public Property<DocumentsLocation> getDocumentsLocation() {
            return this.documentsLocation;
        }

        @Override
        @NotNull
        public Property<DocumentsTabsLocation> getDocumentsTabsLocation() {
            return this.documentsTabsLocation;
        }

        @Override
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public Property<String> getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Property<DocumentsFolderLocation> getLocation() {
            return this.location;
        }

        @Override
        @NotNull
        public Property<FolderPermissionChecker> getPermissionsChecker() {
            return this.permissionsChecker;
        }

        @Override
        @NotNull
        public FolderIdentifier getIdentifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        public DocumentsSearchHighlights getHighlights() {
            return this.highlights;
        }

        @Override
        public boolean canDrag() {
            return false;
        }

        @Override
        public boolean canDropInto() {
            return false;
        }

        @Override
        public boolean hasParent(@NotNull String folderId) {
            Intrinsics.checkNotNullParameter((Object)folderId, (String)"folderId");
            return false;
        }

        @NotNull
        public Property getDescription() {
            return this.description;
        }

        @Override
        @NotNull
        public Property<Boolean> getDeleted() {
            return this.deleted;
        }

        @NotNull
        public String toString() {
            return ID;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcirclet/documents/DocumentsTreeItem$SharedWithMe$Companion;", "", "()V", "ID", "", "NAME", "app-state"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

