/*
 * Decompiled with CFR 0.152.
 */
package circlet.code.gitlab;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcirclet/code/gitlab/GitLabCommonUtil;", "", "()V", "httpPrefix", "", "sshPrefix", "getGitLabWebhookPageURL", "repoUrl", "isGitLabRepository", "", "url", "parseGitlabURLSafe", "Lcirclet/code/gitlab/GitLabCommonUtil$GitLabRepoName;", "parseRepoName", "name", "GitLabRepoName", "code-common"})
@SourceDebugExtension(value={"SMAP\nGitLabCommonUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabCommonUtil.kt\ncirclet/code/gitlab/GitLabCommonUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1#2:36\n*E\n"})
public final class GitLabCommonUtil {
    @NotNull
    public static final GitLabCommonUtil INSTANCE = new GitLabCommonUtil();
    @NotNull
    private static final String httpPrefix = "https://gitlab.com/";
    @NotNull
    private static final String sshPrefix = "git@gitlab.com:";

    private GitLabCommonUtil() {
    }

    public final boolean isGitLabRepository(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        return this.parseGitlabURLSafe(url2) != null;
    }

    @Nullable
    public final GitLabRepoName parseGitlabURLSafe(@NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        if (StringsKt.startsWith$default((String)url2, (String)httpPrefix, (boolean)false, (int)2, null)) {
            return this.parseRepoName(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)url2, (CharSequence)httpPrefix), (CharSequence)".git"));
        }
        if (StringsKt.startsWith$default((String)url2, (String)sshPrefix, (boolean)false, (int)2, null)) {
            return this.parseRepoName(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)url2, (CharSequence)sshPrefix), (CharSequence)".git"));
        }
        return null;
    }

    @NotNull
    public final String getGitLabWebhookPageURL(@NotNull String repoUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)repoUrl, (String)"repoUrl");
        GitLabRepoName gitLabRepoName = this.parseGitlabURLSafe(repoUrl);
        if (gitLabRepoName != null) {
            GitLabRepoName it = gitLabRepoName;
            boolean bl = false;
            string2 = it.getOwner() + "/" + it.getRepository();
        } else {
            string2 = null;
        }
        return httpPrefix + string2 + "/-/hooks";
    }

    private final GitLabRepoName parseRepoName(String name2) {
        return new GitLabRepoName(StringsKt.substringBeforeLast((String)name2, (String)"/", (String)""), StringsKt.substringAfterLast$default((String)name2, (String)"/", null, (int)2, null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcirclet/code/gitlab/GitLabCommonUtil$GitLabRepoName;", "", "owner", "", "repository", "(Ljava/lang/String;Ljava/lang/String;)V", "getOwner", "()Ljava/lang/String;", "getRepository", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "code-common"})
    public static final class GitLabRepoName {
        @NotNull
        private final String owner;
        @NotNull
        private final String repository;

        public GitLabRepoName(@NotNull String owner, @NotNull String repository) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            this.owner = owner;
            this.repository = repository;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        @NotNull
        public final String getRepository() {
            return this.repository;
        }

        @NotNull
        public final String component1() {
            return this.owner;
        }

        @NotNull
        public final String component2() {
            return this.repository;
        }

        @NotNull
        public final GitLabRepoName copy(@NotNull String owner, @NotNull String repository) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            return new GitLabRepoName(owner, repository);
        }

        public static /* synthetic */ GitLabRepoName copy$default(GitLabRepoName gitLabRepoName, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = gitLabRepoName.owner;
            }
            if ((n & 2) != 0) {
                string3 = gitLabRepoName.repository;
            }
            return gitLabRepoName.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "GitLabRepoName(owner=" + this.owner + ", repository=" + this.repository + ")";
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + this.repository.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GitLabRepoName)) {
                return false;
            }
            GitLabRepoName gitLabRepoName = (GitLabRepoName)other;
            if (!Intrinsics.areEqual((Object)this.owner, (Object)gitLabRepoName.owner)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.repository, (Object)gitLabRepoName.repository);
        }
    }
}

