/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.richText;

import circlet.client.api.richText.RtBlockNode;
import circlet.client.api.richText.RtBlockUnfurl;
import circlet.client.api.richText.RtBlockquote;
import circlet.client.api.richText.RtBreak;
import circlet.client.api.richText.RtBulletList;
import circlet.client.api.richText.RtCode;
import circlet.client.api.richText.RtDocument;
import circlet.client.api.richText.RtDocumentMark;
import circlet.client.api.richText.RtDocumentVisitorKt;
import circlet.client.api.richText.RtEmoji;
import circlet.client.api.richText.RtHeading;
import circlet.client.api.richText.RtHorizontalRule;
import circlet.client.api.richText.RtImage;
import circlet.client.api.richText.RtInlineNode;
import circlet.client.api.richText.RtInlineNodeWithMarks;
import circlet.client.api.richText.RtListItem;
import circlet.client.api.richText.RtMention;
import circlet.client.api.richText.RtOrderedList;
import circlet.client.api.richText.RtParagraph;
import circlet.client.api.richText.RtTable;
import circlet.client.api.richText.RtTableCell;
import circlet.client.api.richText.RtTableHeader;
import circlet.client.api.richText.RtTableRow;
import circlet.client.api.richText.RtTableRowContent;
import circlet.client.api.richText.RtText;
import circlet.client.api.richText.RtUnfurl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.klogging.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 L2\u00020\u0001:\u0001LB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0004H\u0016J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u00020\u00042\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00042\u0006\u0010:\u001a\u00020;H\u0016J2\u0010@\u001a\u00020\u00042\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00060'2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00060C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00040EH\u0002J.\u0010F\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060C2\u0006\u0010G\u001a\u00020H2\u0012\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040JH\u0002J\u0012\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00060'*\u00020(H\u0002\u00a8\u0006M"}, d2={"Lcirclet/client/api/richText/RtDocumentVisitor;", "", "()V", "onMarkEnd", "", "mark", "Lcirclet/client/api/richText/RtDocumentMark;", "onMarkStart", "visitBlockNode", "blockNode", "Lcirclet/client/api/richText/RtBlockNode;", "visitBlockUnfurl", "unfurl", "Lcirclet/client/api/richText/RtBlockUnfurl;", "visitBlockquote", "blockquote", "Lcirclet/client/api/richText/RtBlockquote;", "visitBreak", "visitBulletList", "list", "Lcirclet/client/api/richText/RtBulletList;", "visitCodeBlock", "code", "Lcirclet/client/api/richText/RtCode;", "visitDocument", "document", "Lcirclet/client/api/richText/RtDocument;", "visitEmoji", "emoji", "Lcirclet/client/api/richText/RtEmoji;", "visitHeading", "heading", "Lcirclet/client/api/richText/RtHeading;", "visitHorizontalRule", "visitImage", "image", "Lcirclet/client/api/richText/RtImage;", "visitInlineNodes", "children", "", "Lcirclet/client/api/richText/RtInlineNode;", "visitInlineUnfurl", "Lcirclet/client/api/richText/RtUnfurl;", "visitListItem", "listItem", "Lcirclet/client/api/richText/RtListItem;", "visitMention", "mention", "Lcirclet/client/api/richText/RtMention;", "visitOrderedList", "Lcirclet/client/api/richText/RtOrderedList;", "visitParagraph", "paragraph", "Lcirclet/client/api/richText/RtParagraph;", "visitTable", "table", "Lcirclet/client/api/richText/RtTable;", "visitTd", "content", "Lcirclet/client/api/richText/RtTableRowContent;", "visitText", "text", "", "visitTh", "withMarks", "requiredMarks", "openedMarks", "", "block", "Lkotlin/Function0;", "closeMarksDownTo", "index", "", "onClose", "Lkotlin/Function1;", "getSortedMarks", "Companion", "client-api"})
@SourceDebugExtension(value={"SMAP\nRtDocumentVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtDocumentVisitor.kt\ncirclet/client/api/richText/RtDocumentVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1855#2,2:178\n1855#2,2:180\n1855#2,2:182\n1855#2,2:184\n1855#2,2:186\n1855#2:188\n1855#2,2:189\n1856#2:191\n1855#2,2:192\n1855#2,2:194\n1855#2,2:196\n1864#2,3:198\n*S KotlinDebug\n*F\n+ 1 RtDocumentVisitor.kt\ncirclet/client/api/richText/RtDocumentVisitor\n*L\n9#1:178,2\n38#1:180,2\n43#1:182,2\n48#1:184,2\n53#1:186,2\n70#1:188\n71#1:189,2\n70#1:191\n82#1:192,2\n88#1:194,2\n99#1:196,2\n129#1:198,3\n*E\n"})
public class RtDocumentVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void visitDocument(@NotNull RtDocument document2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Iterable $this$forEach$iv = document2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public final void visitBlockNode(@NotNull RtBlockNode blockNode) {
        Intrinsics.checkNotNullParameter((Object)blockNode, (String)"blockNode");
        RtBlockNode rtBlockNode = blockNode;
        if (rtBlockNode instanceof RtHeading) {
            this.visitHeading((RtHeading)blockNode);
        } else if (rtBlockNode instanceof RtParagraph) {
            this.visitParagraph((RtParagraph)blockNode);
        } else if (rtBlockNode instanceof RtBulletList) {
            this.visitBulletList((RtBulletList)blockNode);
        } else if (rtBlockNode instanceof RtOrderedList) {
            this.visitOrderedList((RtOrderedList)blockNode);
        } else if (rtBlockNode instanceof RtBlockquote) {
            this.visitBlockquote((RtBlockquote)blockNode);
        } else if (rtBlockNode instanceof RtCode) {
            this.visitCodeBlock((RtCode)blockNode);
        } else if (rtBlockNode instanceof RtHorizontalRule) {
            this.visitHorizontalRule();
        } else if (rtBlockNode instanceof RtTable) {
            this.visitTable((RtTable)blockNode);
        } else if (rtBlockNode instanceof RtBlockUnfurl) {
            this.visitBlockUnfurl((RtBlockUnfurl)blockNode);
        } else {
            Companion.getLogger().error("Unsupported block node '" + Reflection.getOrCreateKotlinClass(blockNode.getClass()).getSimpleName() + "'");
        }
    }

    public void visitHeading(@NotNull RtHeading heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        this.visitInlineNodes(heading.getChildren());
    }

    public void visitParagraph(@NotNull RtParagraph paragraph2) {
        Intrinsics.checkNotNullParameter((Object)paragraph2, (String)"paragraph");
        this.visitInlineNodes(paragraph2.getChildren());
    }

    public void visitBulletList(@NotNull RtBulletList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        Iterable $this$forEach$iv = list2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtListItem it = (RtListItem)element$iv;
            boolean bl = false;
            this.visitListItem(it);
        }
    }

    public void visitOrderedList(@NotNull RtOrderedList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        Iterable $this$forEach$iv = list2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtListItem it = (RtListItem)element$iv;
            boolean bl = false;
            this.visitListItem(it);
        }
    }

    public void visitListItem(@NotNull RtListItem listItem) {
        Intrinsics.checkNotNullParameter((Object)listItem, (String)"listItem");
        Iterable $this$forEach$iv = listItem.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public void visitBlockquote(@NotNull RtBlockquote blockquote) {
        Intrinsics.checkNotNullParameter((Object)blockquote, (String)"blockquote");
        Iterable $this$forEach$iv = blockquote.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public void visitCodeBlock(@NotNull RtCode code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.visitInlineNodes(code.getChildren());
    }

    public void visitText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
    }

    public void visitHorizontalRule() {
    }

    public void visitBreak() {
    }

    public void visitEmoji(@NotNull RtEmoji emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
    }

    public void visitImage(@NotNull RtImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
    }

    public void visitMention(@NotNull RtMention mention) {
        Intrinsics.checkNotNullParameter((Object)mention, (String)"mention");
    }

    public void visitInlineUnfurl(@NotNull RtUnfurl unfurl) {
        Intrinsics.checkNotNullParameter((Object)unfurl, (String)"unfurl");
    }

    public void visitBlockUnfurl(@NotNull RtBlockUnfurl unfurl) {
        Intrinsics.checkNotNullParameter((Object)unfurl, (String)"unfurl");
    }

    public void visitTable(@NotNull RtTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Iterable $this$forEach$iv = table.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtTableRow row = (RtTableRow)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = row.getChildren();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                RtTableRowContent content2 = (RtTableRowContent)element$iv2;
                boolean bl2 = false;
                RtTableRowContent rtTableRowContent = content2;
                if (rtTableRowContent instanceof RtTableHeader) {
                    this.visitTh(content2);
                    continue;
                }
                if (rtTableRowContent instanceof RtTableCell) {
                    this.visitTd(content2);
                    continue;
                }
                Companion.getLogger().error("Unsupported table row children " + content2);
            }
        }
    }

    public void visitTh(@NotNull RtTableRowContent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Iterable $this$forEach$iv = content2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public void visitTd(@NotNull RtTableRowContent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Iterable $this$forEach$iv = content2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public void onMarkStart(@NotNull RtDocumentMark mark2) {
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
    }

    public void onMarkEnd(@NotNull RtDocumentMark mark2) {
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
    }

    public final void visitInlineNodes(@NotNull List<? extends RtInlineNode> children2) {
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        List openedMarks = new ArrayList();
        Iterable $this$forEach$iv = children2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtInlineNode inlineNode = (RtInlineNode)element$iv;
            boolean bl = false;
            this.withMarks(this.getSortedMarks(inlineNode), openedMarks, (Function0<Unit>)((Function0)new Function0<Unit>(inlineNode, this){
                final /* synthetic */ RtInlineNode $inlineNode;
                final /* synthetic */ RtDocumentVisitor this$0;
                {
                    this.$inlineNode = $inlineNode;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    RtInlineNode rtInlineNode = this.$inlineNode;
                    if (rtInlineNode instanceof RtText) {
                        this.this$0.visitText(((RtText)this.$inlineNode).getValue());
                    } else if (rtInlineNode instanceof RtBreak) {
                        this.this$0.visitBreak();
                    } else if (rtInlineNode instanceof RtEmoji) {
                        this.this$0.visitEmoji((RtEmoji)this.$inlineNode);
                    } else if (rtInlineNode instanceof RtImage) {
                        this.this$0.visitImage((RtImage)this.$inlineNode);
                    } else if (rtInlineNode instanceof RtMention) {
                        this.this$0.visitMention((RtMention)this.$inlineNode);
                    } else if (rtInlineNode instanceof RtUnfurl) {
                        this.this$0.visitInlineUnfurl((RtUnfurl)this.$inlineNode);
                    } else {
                        RtDocumentVisitor.Companion.getLogger().error("Unsupported inline node '" + Reflection.getOrCreateKotlinClass(this.$inlineNode.getClass()).getSimpleName() + "'");
                    }
                }
            }));
        }
        this.closeMarksDownTo(openedMarks, 0, (Function1<? super RtDocumentMark, Unit>)((Function1)new Function1<RtDocumentMark, Unit>(this){
            final /* synthetic */ RtDocumentVisitor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RtDocumentMark it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.onMarkEnd(it);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void withMarks(List<? extends RtDocumentMark> requiredMarks, List<RtDocumentMark> openedMarks, Function0<Unit> block) {
        this.closeMarksDownTo(openedMarks, requiredMarks.size(), (Function1<? super RtDocumentMark, Unit>)((Function1)new Function1<RtDocumentMark, Unit>(this){
            final /* synthetic */ RtDocumentVisitor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RtDocumentMark it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.onMarkEnd(it);
            }
        }));
        Iterable $this$forEachIndexed$iv = requiredMarks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void mark2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RtDocumentMark rtDocumentMark = (RtDocumentMark)item$iv;
            int index2 = n;
            boolean bl = false;
            RtDocumentMark openedMark = (RtDocumentMark)CollectionsKt.getOrNull(openedMarks, (int)index2);
            if (Intrinsics.areEqual((Object)openedMark, (Object)mark2)) continue;
            if (!Intrinsics.areEqual((Object)openedMark, (Object)mark2)) {
                this.closeMarksDownTo(openedMarks, index2, (Function1<? super RtDocumentMark, Unit>)((Function1)new Function1<RtDocumentMark, Unit>(this){
                    final /* synthetic */ RtDocumentVisitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull RtDocumentMark it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.onMarkEnd(it);
                    }
                }));
            }
            ((Collection)openedMarks).add(mark2);
            this.onMarkStart((RtDocumentMark)mark2);
        }
        block.invoke();
    }

    private final List<RtDocumentMark> getSortedMarks(RtInlineNode $this$getSortedMarks) {
        if (!($this$getSortedMarks instanceof RtInlineNodeWithMarks)) {
            return CollectionsKt.emptyList();
        }
        return RtDocumentVisitorKt.sortRichTextMarks((Collection<? extends RtDocumentMark>)((RtInlineNodeWithMarks)$this$getSortedMarks).getMarks());
    }

    private final void closeMarksDownTo(List<RtDocumentMark> $this$closeMarksDownTo, int index2, Function1<? super RtDocumentMark, Unit> onClose2) {
        while ($this$closeMarksDownTo.size() > index2) {
            RtDocumentMark removedMark = (RtDocumentMark)CollectionsKt.removeLast($this$closeMarksDownTo);
            onClose2.invoke((Object)removedMark);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcirclet/client/api/richText/RtDocumentVisitor$Companion;", "Llibraries/klogging/KLogging;", "()V", "client-api"})
    public static final class Companion
    extends KLogging {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

