/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.auth;

import circlet.client.api.ChannelIdentifier;
import circlet.client.api.ChannelPermissionContextIdentifier;
import circlet.client.api.DocumentFolderPermissionContextIdentifier;
import circlet.client.api.DocumentPermissionContextIdentifier;
import circlet.client.api.GlobalPermissionContextIdentifier;
import circlet.client.api.PackageRepositoryPermissionContextIdentifier;
import circlet.client.api.PermissionContextIdentifier;
import circlet.client.api.ProfileIdentifier;
import circlet.client.api.ProjectIdentifier;
import circlet.client.api.ProjectPermissionContextIdentifier;
import circlet.client.api.td.TeamIdentifier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\nH\u0002\u001a\n\u0010\t\u001a\u00020\u0002*\u00020\u0001\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\u0006H\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u00a8\u0006\f"}, d2={"parsePermissionContextIdentifier", "Lcirclet/client/api/PermissionContextIdentifier;", "", "parseProfileIdentifier", "Lcirclet/client/api/ProfileIdentifier;", "parseProjectIdentifier", "Lcirclet/client/api/ProjectIdentifier;", "parseTeamIdentifier", "Lcirclet/client/api/td/TeamIdentifier;", "serialize", "Lcirclet/client/api/ChannelIdentifier;", "tryParsePermissionContextIdentifierOrNull", "client-api"})
public final class XSpaceScopeKt {
    @NotNull
    public static final PermissionContextIdentifier parsePermissionContextIdentifier(@NotNull String $this$parsePermissionContextIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$parsePermissionContextIdentifier, (String)"<this>");
        PermissionContextIdentifier permissionContextIdentifier = XSpaceScopeKt.tryParsePermissionContextIdentifierOrNull($this$parsePermissionContextIdentifier);
        if (permissionContextIdentifier == null) {
            throw new IllegalStateException(("Unknown identifier " + $this$parsePermissionContextIdentifier).toString());
        }
        return permissionContextIdentifier;
    }

    @Nullable
    public static final PermissionContextIdentifier tryParsePermissionContextIdentifierOrNull(@NotNull String $this$tryParsePermissionContextIdentifierOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$tryParsePermissionContextIdentifierOrNull, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$tryParsePermissionContextIdentifierOrNull, (String)"project:", (boolean)false, (int)2, null) ? (PermissionContextIdentifier)new ProjectPermissionContextIdentifier(XSpaceScopeKt.parseProjectIdentifier(StringsKt.removePrefix((String)$this$tryParsePermissionContextIdentifierOrNull, (CharSequence)"project:"))) : (StringsKt.startsWith$default((String)$this$tryParsePermissionContextIdentifierOrNull, (String)"channel:", (boolean)false, (int)2, null) ? (PermissionContextIdentifier)new ChannelPermissionContextIdentifier(StringsKt.removePrefix((String)$this$tryParsePermissionContextIdentifierOrNull, (CharSequence)"channel:")) : (StringsKt.startsWith$default((String)$this$tryParsePermissionContextIdentifierOrNull, (String)"document:", (boolean)false, (int)2, null) ? (PermissionContextIdentifier)new DocumentPermissionContextIdentifier(StringsKt.removePrefix((String)$this$tryParsePermissionContextIdentifierOrNull, (CharSequence)"document:")) : (StringsKt.startsWith$default((String)$this$tryParsePermissionContextIdentifierOrNull, (String)"folder:", (boolean)false, (int)2, null) ? (PermissionContextIdentifier)new DocumentFolderPermissionContextIdentifier(StringsKt.removePrefix((String)$this$tryParsePermissionContextIdentifierOrNull, (CharSequence)"folder:")) : (StringsKt.startsWith$default((String)$this$tryParsePermissionContextIdentifierOrNull, (String)"packageRepository:", (boolean)false, (int)2, null) ? (PermissionContextIdentifier)new PackageRepositoryPermissionContextIdentifier(StringsKt.removePrefix((String)$this$tryParsePermissionContextIdentifierOrNull, (CharSequence)"packageRepository:")) : (Intrinsics.areEqual((Object)$this$tryParsePermissionContextIdentifierOrNull, (Object)"global") ? (PermissionContextIdentifier)GlobalPermissionContextIdentifier.INSTANCE : null)))));
    }

    @NotNull
    public static final ProjectIdentifier parseProjectIdentifier(@NotNull String $this$parseProjectIdentifier) {
        Intrinsics.checkNotNullParameter((Object)$this$parseProjectIdentifier, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$parseProjectIdentifier, (String)"key:", (boolean)false, (int)2, null) ? (ProjectIdentifier)new ProjectIdentifier.Key(StringsKt.removePrefix((String)$this$parseProjectIdentifier, (CharSequence)"key:")) : (ProjectIdentifier)new ProjectIdentifier.Id($this$parseProjectIdentifier);
    }

    private static final ProfileIdentifier parseProfileIdentifier(String $this$parseProfileIdentifier) {
        if (StringsKt.startsWith$default((String)$this$parseProfileIdentifier, (String)"username:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$parseProfileIdentifier, (String)"external-id:", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)$this$parseProfileIdentifier, (Object)"me")) {
            throw new UnsupportedOperationException("Profile id should be used instead");
        }
        return new ProfileIdentifier.Id($this$parseProfileIdentifier);
    }

    private static final TeamIdentifier parseTeamIdentifier(String $this$parseTeamIdentifier) {
        if (StringsKt.startsWith$default((String)$this$parseTeamIdentifier, (String)"name:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$parseTeamIdentifier, (String)"externalId:", (boolean)false, (int)2, null)) {
            throw new UnsupportedOperationException("Team id should be used instead");
        }
        return new TeamIdentifier.Id($this$parseTeamIdentifier);
    }

    @NotNull
    public static final String serialize(@NotNull PermissionContextIdentifier $this$serialize) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$serialize, (String)"<this>");
        PermissionContextIdentifier permissionContextIdentifier = $this$serialize;
        if (permissionContextIdentifier instanceof ProjectPermissionContextIdentifier) {
            object = "project:" + XSpaceScopeKt.serialize(((ProjectPermissionContextIdentifier)$this$serialize).getProject());
        } else if (permissionContextIdentifier instanceof ChannelPermissionContextIdentifier) {
            object = "channel:" + ((ChannelPermissionContextIdentifier)$this$serialize).getChannel();
        } else if (permissionContextIdentifier instanceof GlobalPermissionContextIdentifier) {
            object = "global";
        } else if (permissionContextIdentifier instanceof DocumentPermissionContextIdentifier) {
            object = "document:" + ((DocumentPermissionContextIdentifier)$this$serialize).getDocument();
        } else if (permissionContextIdentifier instanceof DocumentFolderPermissionContextIdentifier) {
            object = "folder:" + ((DocumentFolderPermissionContextIdentifier)$this$serialize).getFolder();
        } else if (permissionContextIdentifier instanceof PackageRepositoryPermissionContextIdentifier) {
            object = "packageRepository:" + ((PackageRepositoryPermissionContextIdentifier)$this$serialize).getPackageRepository();
        } else {
            throw new IllegalStateException(("Unknown type " + Reflection.getOrCreateKotlinClass($this$serialize.getClass()).getSimpleName()).toString());
        }
        return object;
    }

    private static final String serialize(ProjectIdentifier $this$serialize) {
        Object object;
        ProjectIdentifier projectIdentifier2 = $this$serialize;
        if (projectIdentifier2 instanceof ProjectIdentifier.Id) {
            object = ((ProjectIdentifier.Id)$this$serialize).getId();
        } else if (projectIdentifier2 instanceof ProjectIdentifier.Key) {
            object = "key:" + ((ProjectIdentifier.Key)$this$serialize).getKey();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private static final String serialize(ChannelIdentifier $this$serialize) {
        if (!($this$serialize instanceof ChannelIdentifier.Id)) {
            throw new IllegalStateException(("Unknown type " + Reflection.getOrCreateKotlinClass($this$serialize.getClass()).getSimpleName()).toString());
        }
        return ((ChannelIdentifier.Id)$this$serialize).getId();
    }
}

