/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.ProfileIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcirclet/client/api/ProfileIdentifierResolver;", "", "()V", "idPrefix", "", "usernamePrefix", "resolve", "Lcirclet/client/api/ProfileIdentifier;", "profileAsString", "client-api"})
public final class ProfileIdentifierResolver {
    @NotNull
    public static final ProfileIdentifierResolver INSTANCE = new ProfileIdentifierResolver();
    @NotNull
    private static final String usernamePrefix = "username:";
    @NotNull
    private static final String idPrefix = "id:";

    private ProfileIdentifierResolver() {
    }

    @NotNull
    public final ProfileIdentifier resolve(@NotNull String profileAsString) {
        ProfileIdentifier profileIdentifier;
        Intrinsics.checkNotNullParameter((Object)profileAsString, (String)"profileAsString");
        if (StringsKt.equals((String)profileAsString, (String)"me", (boolean)true) || StringsKt.equals((String)profileAsString, (String)"my", (boolean)true)) {
            profileIdentifier = ProfileIdentifier.Me.INSTANCE;
        } else if (StringsKt.startsWith((String)profileAsString, (String)usernamePrefix, (boolean)true)) {
            String string2 = profileAsString.substring(usernamePrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            profileIdentifier = new ProfileIdentifier.Username(string2);
        } else if (StringsKt.startsWith((String)profileAsString, (String)idPrefix, (boolean)true)) {
            String string3 = profileAsString.substring(idPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            profileIdentifier = new ProfileIdentifier.Id(string3);
        } else {
            profileIdentifier = new ProfileIdentifier.Id(profileAsString);
        }
        return profileIdentifier;
    }
}

