/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.AvailableTrial;
import circlet.client.api.BillingAdminKt;
import circlet.client.api.BillingPeriod;
import circlet.client.api.CustomFieldAmount;
import circlet.client.api.Money;
import circlet.client.api.PurchasedBillingPlan;
import circlet.client.api.Tier;
import circlet.client.api.TierEntityUsage;
import circlet.client.api.TierFeature;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0012\u0010-\u001a\u00020.*\u00020/2\u0006\u00100\u001a\u00020/\u001a\u0015\u00101\u001a\u00020.*\u00020\u00032\u0006\u00100\u001a\u00020.H\u0086\u0002\u001a\u0015\u00102\u001a\u00020/*\u00020/2\u0006\u00103\u001a\u00020.H\u0086\u0002\u001a\u0015\u00102\u001a\u00020/*\u00020/2\u0006\u00103\u001a\u000204H\u0086\u0002\u001a\u0012\u00105\u001a\u000206*\u00020\u00022\u0006\u00107\u001a\u000208\u001a\n\u00109\u001a\u000206*\u00020\u0002\u001a\n\u0010:\u001a\u000206*\u00020;\u001a\u0015\u0010<\u001a\u00020/*\u00020/2\u0006\u00100\u001a\u00020/H\u0086\u0002\u001a\u0015\u0010=\u001a\u00020/*\u00020/2\u0006\u00100\u001a\u00020/H\u0086\u0002\u001a\u0012\u0010>\u001a\u00020\b*\u00020?2\u0006\u0010@\u001a\u00020\b\u001a\u0012\u0010$\u001a\u00020\u0002*\u0002082\u0006\u0010A\u001a\u000206\u001a\u0012\u0010B\u001a\u00020\u000e*\u00020\u00022\u0006\u0010A\u001a\u000206\u001a\u0015\u0010C\u001a\u00020/*\u00020/2\u0006\u00103\u001a\u00020.H\u0086\u0002\u001a\u0015\u0010C\u001a\u00020/*\u00020/2\u0006\u00103\u001a\u000204H\u0086\u0002\"!\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\"!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\"!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0019\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0015\u0010\u001e\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0015\u0010!\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0015\u0010$\u001a\u00020\u0002*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0015\u0010'\u001a\u00020\u000e*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b(\u0010#\"\u0017\u0010)\u001a\u0004\u0018\u00010\u0002*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b*\u0010&\"\u0015\u0010+\u001a\u00020\u0002*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b,\u0010&*\"\u0010D\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006E"}, d2={"DEFAULT_CUSTOM_FIELD_TIER_QUOTA", "Lkotlin/Function1;", "Lcirclet/client/api/Tier;", "Lcirclet/client/api/CustomFieldAmount;", "Lcirclet/client/api/CustomFieldTierQuota;", "getDEFAULT_CUSTOM_FIELD_TIER_QUOTA", "()Lkotlin/jvm/functions/Function1;", "FREE_GUESTS_RATIO_DEPRECATED", "", "ISSUE_CUSTOM_FIELD_TIER_QUOTA", "getISSUE_CUSTOM_FIELD_TIER_QUOTA", "UNLIMITED_CUSTOM_FIELD_TIER_QUOTA", "getUNLIMITED_CUSTOM_FIELD_TIER_QUOTA", "zeroPlanId", "", "availableTrials", "", "Lcirclet/client/api/AvailableTrial;", "Lcirclet/client/api/PurchasedBillingPlan;", "getAvailableTrials", "(Lcirclet/client/api/PurchasedBillingPlan;)Ljava/util/List;", "billingPeriodTyped", "Lcirclet/client/api/BillingPeriod;", "getBillingPeriodTyped", "(Lcirclet/client/api/PurchasedBillingPlan;)Lcirclet/client/api/BillingPeriod;", "endsOn", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "getEndsOn", "(Lcirclet/client/api/AvailableTrial;)Lcirclet/platform/api/KotlinXDate;", "nearestHigherPlanOnPrem", "getNearestHigherPlanOnPrem", "(Lcirclet/client/api/Tier;)Lcirclet/client/api/Tier;", "readableName", "getReadableName", "(Lcirclet/client/api/Tier;)Ljava/lang/String;", "tier", "getTier", "(Lcirclet/client/api/PurchasedBillingPlan;)Lcirclet/client/api/Tier;", "tierNameOnPrem", "getTierNameOnPrem", "trialTier", "getTrialTier", "trueTier", "getTrueTier", "compare", "", "Lcirclet/client/api/Money;", "that", "compareTo", "div", "number", "", "hasFeature", "", "feature", "Lcirclet/client/api/TierFeature;", "isFree", "isUnlimited", "Lcirclet/client/api/TierEntityUsage;", "minus", "plus", "round4", "Lcirclet/client/api/Money$Companion;", "value", "onPrem", "tierName", "times", "CustomFieldTierQuota", "client-api"})
@SourceDebugExtension(value={"SMAP\nBillingAdmin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BillingAdmin.kt\ncirclet/client/api/BillingAdminKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,781:1\n766#2:782\n857#2,2:783\n*S KotlinDebug\n*F\n+ 1 BillingAdmin.kt\ncirclet/client/api/BillingAdminKt\n*L\n746#1:782\n746#1:783,2\n*E\n"})
public final class BillingAdminKt {
    @NotNull
    private static final Function1<Tier, CustomFieldAmount> UNLIMITED_CUSTOM_FIELD_TIER_QUOTA = UNLIMITED_CUSTOM_FIELD_TIER_QUOTA.1.INSTANCE;
    @NotNull
    private static final Function1<Tier, CustomFieldAmount> ISSUE_CUSTOM_FIELD_TIER_QUOTA = ISSUE_CUSTOM_FIELD_TIER_QUOTA.1.INSTANCE;
    @NotNull
    private static final Function1<Tier, CustomFieldAmount> DEFAULT_CUSTOM_FIELD_TIER_QUOTA = DEFAULT_CUSTOM_FIELD_TIER_QUOTA.1.INSTANCE;
    @NotNull
    public static final String zeroPlanId = "zero";
    public static final double FREE_GUESTS_RATIO_DEPRECATED = 0.25;

    public static final boolean isUnlimited(@NotNull TierEntityUsage $this$isUnlimited) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnlimited, (String)"<this>");
        return $this$isUnlimited.getLimit() < 0;
    }

    @NotNull
    public static final Money times(@NotNull Money $this$times, int number2) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return new Money(BillingAdminKt.round4(Money.Companion, $this$times.getAmount() * (double)number2), $this$times.getCurrency());
    }

    @NotNull
    public static final Money times(@NotNull Money $this$times, long number2) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return new Money(BillingAdminKt.round4(Money.Companion, $this$times.getAmount() * (double)number2), $this$times.getCurrency());
    }

    @NotNull
    public static final Money div(@NotNull Money $this$div, int number2) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        return new Money(BillingAdminKt.round4(Money.Companion, $this$div.getAmount() / (double)number2), $this$div.getCurrency());
    }

    @NotNull
    public static final Money div(@NotNull Money $this$div, long number2) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        return new Money(BillingAdminKt.round4(Money.Companion, $this$div.getAmount() / (double)number2), $this$div.getCurrency());
    }

    @NotNull
    public static final Money plus(@NotNull Money $this$plus, @NotNull Money that) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        if (!Intrinsics.areEqual((Object)$this$plus.getCurrency(), (Object)that.getCurrency())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return new Money(BillingAdminKt.round4(Money.Companion, $this$plus.getAmount() + that.getAmount()), $this$plus.getCurrency());
    }

    @NotNull
    public static final Money minus(@NotNull Money $this$minus, @NotNull Money that) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        if (!Intrinsics.areEqual((Object)$this$minus.getCurrency(), (Object)that.getCurrency())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return new Money(BillingAdminKt.round4(Money.Companion, $this$minus.getAmount() - that.getAmount()), $this$minus.getCurrency());
    }

    public static final int compare(@NotNull Money $this$compare, @NotNull Money that) {
        Intrinsics.checkNotNullParameter((Object)$this$compare, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        if (!Intrinsics.areEqual((Object)$this$compare.getCurrency(), (Object)that.getCurrency())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return $this$compare.getAmount() < that.getAmount() ? -1 : ($this$compare.getAmount() > that.getAmount() ? 1 : 0);
    }

    public static final double round4(@NotNull Money.Companion $this$round4, double value2) {
        Intrinsics.checkNotNullParameter((Object)$this$round4, (String)"<this>");
        return Math.rint(value2 * (double)10000) / (double)10000;
    }

    public static final boolean isFree(@NotNull Tier $this$isFree) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isFree), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isFree.ordinal()]) {
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public static final String getReadableName(@NotNull Tier $this$readableName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$readableName), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$readableName.ordinal()]) {
            case 1: {
                string2 = "Free";
                break;
            }
            case 3: {
                string2 = "Team";
                break;
            }
            case 4: {
                string2 = "Organization";
                break;
            }
            case 5: {
                string2 = "Classroom";
                break;
            }
            case 2: {
                string2 = "Beta";
                break;
            }
            case 6: {
                string2 = "Enterprise";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @NotNull
    public static final String getTierNameOnPrem(@NotNull Tier $this$tierNameOnPrem) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$tierNameOnPrem), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$tierNameOnPrem.ordinal()]) {
            case 1: {
                string2 = "SPPF";
                break;
            }
            case 4: {
                string2 = "SPPO";
                break;
            }
            case 6: {
                string2 = "SPPE";
                break;
            }
            case 2: {
                string2 = "SPPB";
                break;
            }
            case 3: 
            case 5: {
                string2 = $this$tierNameOnPrem.getTierName();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @NotNull
    public static final String tierName(@NotNull Tier $this$tierName, boolean onPrem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$tierName), (String)"<this>");
        return onPrem ? BillingAdminKt.getTierNameOnPrem($this$tierName) : $this$tierName.getTierName();
    }

    @NotNull
    public static final Tier getNearestHigherPlanOnPrem(@NotNull Tier $this$nearestHigherPlanOnPrem) {
        Tier tier2;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$nearestHigherPlanOnPrem), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$nearestHigherPlanOnPrem.ordinal()]) {
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                tier2 = $this$nearestHigherPlanOnPrem;
                break;
            }
            case 3: 
            case 5: {
                tier2 = Tier.Organization;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return tier2;
    }

    @NotNull
    public static final Tier tier(@NotNull TierFeature $this$tier, boolean onPrem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$tier), (String)"<this>");
        return onPrem ? BillingAdminKt.getNearestHigherPlanOnPrem($this$tier.getTier()) : $this$tier.getTier();
    }

    public static final boolean hasFeature(@NotNull Tier $this$hasFeature, @NotNull TierFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$hasFeature), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        return $this$hasFeature.compareTo((Enum)feature.getTier()) >= 0;
    }

    public static final int compareTo(@NotNull CustomFieldAmount $this$compareTo, int that) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        CustomFieldAmount customFieldAmount = $this$compareTo;
        if (customFieldAmount instanceof CustomFieldAmount.None) {
            n = 0;
        } else if (customFieldAmount instanceof CustomFieldAmount.Limited) {
            n = ((CustomFieldAmount.Limited)$this$compareTo).getAmount();
        } else if (customFieldAmount instanceof CustomFieldAmount.Unlimited) {
            n = Integer.MAX_VALUE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n - that;
    }

    @NotNull
    public static final Function1<Tier, CustomFieldAmount> getUNLIMITED_CUSTOM_FIELD_TIER_QUOTA() {
        return UNLIMITED_CUSTOM_FIELD_TIER_QUOTA;
    }

    @NotNull
    public static final Function1<Tier, CustomFieldAmount> getISSUE_CUSTOM_FIELD_TIER_QUOTA() {
        return ISSUE_CUSTOM_FIELD_TIER_QUOTA;
    }

    @NotNull
    public static final Function1<Tier, CustomFieldAmount> getDEFAULT_CUSTOM_FIELD_TIER_QUOTA() {
        return DEFAULT_CUSTOM_FIELD_TIER_QUOTA;
    }

    @NotNull
    public static final Tier getTrueTier(@NotNull PurchasedBillingPlan $this$trueTier) {
        Tier tier2;
        Intrinsics.checkNotNullParameter((Object)$this$trueTier, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$trueTier.isTrial(), (Object)true) && $this$trueTier.getTrialBasePlan() != null) {
            tier2 = Tier.Companion.findTier($this$trueTier.getTrialBasePlan());
            if (tier2 == null) {
                tier2 = BillingAdminKt.getTier($this$trueTier);
            }
        } else {
            tier2 = BillingAdminKt.getTier($this$trueTier);
        }
        return tier2;
    }

    @Nullable
    public static final Tier getTrialTier(@NotNull PurchasedBillingPlan $this$trialTier) {
        Intrinsics.checkNotNullParameter((Object)$this$trialTier, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$trialTier.isTrial(), (Object)true) ? BillingAdminKt.getTier($this$trialTier) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AvailableTrial> getAvailableTrials(@NotNull PurchasedBillingPlan $this$availableTrials) {
        void $this$filterTo$iv$iv;
        List list2;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$availableTrials, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[BillingAdminKt.getTrueTier($this$availableTrials).ordinal()]) {
            case 1: {
                objectArray = new AvailableTrial[]{new AvailableTrial(Tier.Team, 30), new AvailableTrial(Tier.Organization, 30)};
                list2 = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case 3: {
                list2 = CollectionsKt.listOf((Object)new AvailableTrial(Tier.Organization, 30));
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                list2 = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AvailableTrial it = (AvailableTrial)element$iv$iv;
            boolean bl = false;
            if (!($this$availableTrials.getSpentTrials() == null || !$this$availableTrials.getSpentTrials().contains(it.getTier().getTierName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final KotlinXDate getEndsOn(@NotNull AvailableTrial $this$endsOn) {
        Intrinsics.checkNotNullParameter((Object)$this$endsOn, (String)"<this>");
        return ADateJvmKt.plusDays(ADateJvmKt.toDate(ADateJvmKt.getANow()), $this$endsOn.getDurationDays() - 1);
    }

    @NotNull
    public static final Tier getTier(@NotNull PurchasedBillingPlan $this$tier) {
        Intrinsics.checkNotNullParameter((Object)$this$tier, (String)"<this>");
        Tier tier2 = Tier.Companion.findTier($this$tier.getPlan());
        if (tier2 == null) {
            tier2 = Tier.Free;
        }
        return tier2;
    }

    @Nullable
    public static final BillingPeriod getBillingPeriodTyped(@NotNull PurchasedBillingPlan $this$billingPeriodTyped) {
        BillingPeriod billingPeriod;
        Intrinsics.checkNotNullParameter((Object)$this$billingPeriodTyped, (String)"<this>");
        String string2 = $this$billingPeriodTyped.getBillingPeriod().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        switch (string2) {
            case "monthly": {
                billingPeriod = BillingPeriod.Monthly;
                break;
            }
            case "annual": {
                billingPeriod = BillingPeriod.Annual;
                break;
            }
            case "infinite": {
                billingPeriod = BillingPeriod.Infinite;
                break;
            }
            default: {
                billingPeriod = null;
            }
        }
        return billingPeriod;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Tier.values().length];
            try {
                nArray[Tier.Free.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.Beta.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.Team.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.Organization.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.Classroom.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Tier.Enterprise.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

