/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.security;

import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.idea.maven.server.security.MavenToken;

public class TokenReader {
    public static final String PREFIX = "token=";
    private final AtomicReference<String> myRef = new AtomicReference();
    private final AtomicReference<Throwable> myExceptionRef = new AtomicReference();
    private final Scanner myScanner;

    public TokenReader(Scanner scanner, int timeoutMillis) {
        this.myScanner = scanner;
        this.startReading(timeoutMillis);
    }

    public MavenToken getToken() throws Throwable {
        if (this.myExceptionRef.get() != null) {
            throw this.myExceptionRef.get();
        }
        if (this.myRef.get() == null) {
            throw new IllegalStateException("Didn't receive token");
        }
        return new MavenToken(this.myRef.get());
    }

    private void startReading(int timeoutMillis) {
        MyReadThread newThread = new MyReadThread();
        newThread.setDaemon(true);
        newThread.start();
        this.waitUntilReadOrTimeout(timeoutMillis, newThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilReadOrTimeout(int timeoutMillis, Thread newThread) {
        long started = System.currentTimeMillis();
        long deadline = started + (long)timeoutMillis;
        boolean interrupted = false;
        try {
            while (this.myRef.get() == null && this.myExceptionRef.get() == null && System.currentTimeMillis() < deadline) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            interrupted = true;
        }
        finally {
            newThread.interrupt();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class MyReadThread
    extends Thread {
        MyReadThread() {
            super("Key Read Thread");
        }

        @Override
        public void run() {
            try {
                while (TokenReader.this.myScanner.hasNextLine() && !this.isInterrupted()) {
                    String line = TokenReader.this.myScanner.nextLine();
                    if (line == null || !(line = line.trim()).startsWith(TokenReader.PREFIX)) continue;
                    TokenReader.this.myRef.set(line.substring(TokenReader.PREFIX.length()));
                    return;
                }
            }
            catch (Throwable e) {
                TokenReader.this.myExceptionRef.set(e);
            }
        }
    }
}

