/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractBasicBackBasicSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.CodeBlockOrInitializerSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaDocElementType;
import com.intellij.psi.impl.source.BasicJavaElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MethodOrClassSelectioner
extends AbstractBasicBackBasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        ASTNode node;
        if (e == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(0);
        }
        return (BasicJavaAstTreeUtil.is(node = BasicJavaAstTreeUtil.toNode(e), BasicJavaElementType.CLASS_SET) && !BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_TYPE_PARAMETER) || BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_METHOD)) && e.getLanguage() == JavaLanguage.INSTANCE;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        ASTNode node = BasicJavaAstTreeUtil.toNode(e);
        if (node == null) {
            return result;
        }
        ASTNode firstChild = node.getFirstChildNode();
        List<ASTNode> children = BasicJavaAstTreeUtil.getChildren(node);
        int i = 1;
        if (BasicJavaAstTreeUtil.is(firstChild, BasicJavaDocElementType.BASIC_DOC_COMMENT)) {
            while (BasicJavaAstTreeUtil.isWhiteSpace(children.get(i))) {
                ++i;
            }
            TextRange range = new TextRange(children.get(i).getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result.add(range);
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)range));
            range = firstChild.getTextRange();
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)range));
            firstChild = children.get(i++);
        }
        if (BasicJavaAstTreeUtil.is(firstChild, BasicElementTypes.BASIC_JAVA_COMMENT_BIT_SET)) {
            while (BasicJavaAstTreeUtil.is(children.get(i), BasicElementTypes.BASIC_JAVA_COMMENT_OR_WHITESPACE_BIT_SET)) {
                ++i;
            }
            ASTNode last = BasicJavaAstTreeUtil.isWhiteSpace(children.get(i - 1)) ? children.get(i - 2) : children.get(i - 1);
            TextRange range = new TextRange(firstChild.getTextRange().getStartOffset(), last.getTextRange().getEndOffset());
            if (range.contains(cursorOffset)) {
                result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)range));
            }
            range = new TextRange(children.get(i).getTextRange().getStartOffset(), e.getTextRange().getEndOffset());
            result.add(range);
            result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)range));
        }
        result.add(node.getTextRange());
        result.addAll(MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)node.getTextRange()));
        if (BasicJavaAstTreeUtil.is(node, BasicJavaElementType.CLASS_SET)) {
            result.addAll(MethodOrClassSelectioner.selectWithTypeParameters(node));
            result.addAll(MethodOrClassSelectioner.selectBetweenBracesLines(children, editorText));
        }
        if (BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_ANONYMOUS_CLASS)) {
            result.addAll(MethodOrClassSelectioner.selectWholeBlock(node));
        }
        return result;
    }

    private static Collection<TextRange> selectWithTypeParameters(@NotNull ASTNode astClass) {
        if (astClass == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(4);
        }
        ASTNode identifier = BasicJavaAstTreeUtil.getNameIdentifier(astClass);
        ASTNode list = BasicJavaAstTreeUtil.getTypeParameterList(astClass);
        if (identifier != null && list != null) {
            return Collections.singletonList(new TextRange(identifier.getTextRange().getStartOffset(), list.getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectBetweenBracesLines(List<ASTNode> children, @NotNull CharSequence editorText) {
        int start;
        if (editorText == null) {
            MethodOrClassSelectioner.$$$reportNull$$$0(5);
        }
        if ((start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children)) != 0) {
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children, start);
            return MethodOrClassSelectioner.expandToWholeLinesWithBlanks((CharSequence)editorText, (TextRange)new TextRange(start, end));
        }
        return Collections.emptyList();
    }

    private static Collection<TextRange> selectWholeBlock(ASTNode clazz) {
        ASTNode lBrace = BasicJavaAstTreeUtil.getLBrace(clazz);
        ASTNode rBrace = BasicJavaAstTreeUtil.getRBrace(clazz);
        if (lBrace != null && rBrace != null) {
            return Collections.singleton(new TextRange(lBrace.getTextRange().getStartOffset(), rBrace.getTextRange().getEndOffset()));
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/MethodOrClassSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectWithTypeParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "selectBetweenBracesLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

