/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractBasicBackBasicSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.BasicLiteralUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LiteralSelectioner
extends AbstractBasicBackBasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            LiteralSelectioner.$$$reportNull$$$0(0);
        }
        PsiElement parent = e.getParent();
        return LiteralSelectioner.isStringLiteral(e) || LiteralSelectioner.isStringLiteral(parent);
    }

    private static boolean isStringLiteral(PsiElement element) {
        return BasicJavaAstTreeUtil.is(BasicJavaAstTreeUtil.toNode(element), BasicElementTypes.BASIC_STRING_LITERALS) && element.getText().startsWith("\"") && element.getText().endsWith("\"");
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        ASTNode parent;
        List result;
        if (e == null) {
            LiteralSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            LiteralSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            LiteralSelectioner.$$$reportNull$$$0(3);
        }
        if ((result = super.select(e, editorText, cursorOffset, editor)) == null) {
            return null;
        }
        ASTNode node = BasicJavaAstTreeUtil.toNode(e);
        if (node == null) {
            return null;
        }
        TextRange range = node.getTextRange();
        SelectWordUtil.addWordHonoringEscapeSequences((CharSequence)editorText, (TextRange)range, (int)cursorOffset, (Lexer)new StringLiteralLexer('\"', JavaTokenType.STRING_LITERAL), (List)result);
        ASTNode literalExpression = null;
        if (BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_LITERAL_EXPRESSION)) {
            literalExpression = node;
        }
        if (literalExpression == null && BasicJavaAstTreeUtil.is(parent = node.getTreeParent(), BasicJavaElementType.BASIC_LITERAL_EXPRESSION)) {
            literalExpression = parent;
        }
        PsiElement literalPsiExpression = BasicJavaAstTreeUtil.toPsi(literalExpression);
        if (literalExpression != null && literalPsiExpression != null && BasicJavaAstTreeUtil.isTextBlock(literalExpression)) {
            char c;
            int end;
            int contentStart = StringUtil.indexOf((CharSequence)editorText, (char)'\n', (int)range.getStartOffset());
            if (contentStart == -1) {
                return result;
            }
            ++contentStart;
            int indent = BasicLiteralUtil.getTextBlockIndent(literalPsiExpression);
            if (indent == -1) {
                return result;
            }
            for (int i = 0; i < indent; ++i) {
                if (editorText.charAt(contentStart + i) != '\n') continue;
                return result;
            }
            int start = contentStart + indent;
            for (end = range.getEndOffset() - 4; end >= start && (c = editorText.charAt(end)) != '\n'; --end) {
                if (Character.isWhitespace(c)) continue;
                ++end;
                break;
            }
            if (start < end) {
                result.add(new TextRange(start, end));
            }
        } else {
            result.add(new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/LiteralSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

