/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractBasicBackBasicSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CodeBlockOrInitializerSelectioner
extends AbstractBasicBackBasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        ASTNode node;
        if (e == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(0);
        }
        return BasicJavaAstTreeUtil.is(node = BasicJavaAstTreeUtil.toNode(e), BasicJavaElementType.BASIC_CODE_BLOCK) || BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_ARRAY_INITIALIZER_EXPRESSION) || BasicJavaAstTreeUtil.is(node, BasicJavaElementType.CLASS_SET) && !BasicJavaAstTreeUtil.is(node, BasicJavaElementType.BASIC_TYPE_PARAMETER);
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        int start;
        if (e == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        ASTNode node = BasicJavaAstTreeUtil.toNode(e);
        if (node == null) {
            return null;
        }
        result.add(this.getElementRange(node));
        List<ASTNode> children = BasicJavaAstTreeUtil.getChildren(node);
        if (!children.isEmpty() && (start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children)) != 0) {
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children, start);
            result.addAll(CodeBlockOrInitializerSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(start, end)));
        }
        return result;
    }

    public TextRange getElementRange(@NotNull ASTNode astNode) {
        if (astNode == null) {
            CodeBlockOrInitializerSelectioner.$$$reportNull$$$0(4);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.CLASS_SET)) {
            ASTNode lBrace = BasicJavaAstTreeUtil.getLBrace(astNode);
            ASTNode rBrace = BasicJavaAstTreeUtil.getRBrace(astNode);
            if (lBrace != null && rBrace != null) {
                return new TextRange(BasicJavaAstTreeUtil.getTextOffset(lBrace), rBrace.getTextRange().getEndOffset());
            }
        }
        return astNode.getTextRange();
    }

    public static int findOpeningBrace(List<ASTNode> children) {
        int start = 0;
        for (int i = 0; i < children.size(); ++i) {
            ASTNode child = children.get(i);
            if (!BasicJavaAstTreeUtil.is(child, JavaTokenType.LBRACE)) continue;
            int j = i + 1;
            while (BasicJavaAstTreeUtil.isWhiteSpace(children.get(j))) {
                ++j;
            }
            start = children.get(j).getTextRange().getStartOffset();
        }
        return start;
    }

    public static int findClosingBrace(List<ASTNode> children, int startOffset) {
        int end = children.get(children.size() - 1).getTextRange().getEndOffset();
        for (int i = 0; i < children.size(); ++i) {
            ASTNode child = children.get(i);
            if (!BasicJavaAstTreeUtil.is(child, JavaTokenType.RBRACE)) continue;
            int j = i - 1;
            while (BasicJavaAstTreeUtil.isWhiteSpace(children.get(j)) && children.get(j).getTextRange().getStartOffset() > startOffset) {
                --j;
            }
            end = children.get(j).getTextRange().getEndOffset();
        }
        return end;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/CodeBlockOrInitializerSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

