/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingArrayInitializerBraceFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            MissingArrayInitializerBraceFixer.$$$reportNull$$$0(0);
        }
        if (!BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_ARRAY_INITIALIZER_EXPRESSION) && !BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_ANNOTATION_ARRAY_INITIALIZER)) {
            return;
        }
        ASTNode child = astNode.getFirstChildNode();
        if (!child.getElementType().equals(JavaTokenType.LBRACE)) {
            return;
        }
        PsiElement psi = BasicJavaAstTreeUtil.toPsi(astNode);
        if (psi == null) {
            return;
        }
        if (!EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace((Editor)editor, (int)child.getTextRange().getEndOffset(), (FileType)psi.getContainingFile().getFileType())) {
            return;
        }
        ASTNode anchor = BasicJavaAstTreeUtil.findChildByType(astNode, TokenType.ERROR_ELEMENT);
        if (anchor == null) {
            PsiElement last = PsiTreeUtil.getDeepestVisibleLast((PsiElement)psi);
            while (last != null && last.getNode().getElementType().equals(JavaTokenType.RBRACE)) {
                last = PsiTreeUtil.prevCodeLeaf((PsiElement)last);
            }
            if (last != null && PsiTreeUtil.isAncestor((PsiElement)psi, (PsiElement)last, (boolean)true)) {
                anchor = last.getNode();
            }
        }
        int endOffset = (anchor != null ? anchor : astNode).getTextRange().getEndOffset();
        editor.getDocument().insertString(endOffset, (CharSequence)"}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/MissingArrayInitializerBraceFixer", "apply"));
    }
}

