/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.definition.AbstractBasicJavaDefinitionService;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler,
MultiCharQuoteHandler {
    private final TokenSet myConcatenableStrings = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.STRING_LITERAL});
    private final ParentAwareTokenSet myAppropriateElementTypeForLiteral = ParentAwareTokenSet.orSet((ParentAwareTokenSet[])new ParentAwareTokenSet[]{ParentAwareTokenSet.create((TokenSet)JavaDocTokenType.ALL_JAVADOC_TOKENS), BasicElementTypes.BASIC_JAVA_COMMENT_OR_WHITESPACE_BIT_SET, ParentAwareTokenSet.create((TokenSet)BasicElementTypes.BASIC_TEXT_LITERALS), ParentAwareTokenSet.create((IElementType[])new IElementType[]{JavaTokenType.SEMICOLON, JavaTokenType.COMMA, JavaTokenType.RPARENTH, JavaTokenType.RBRACKET, JavaTokenType.RBRACE})});

    public JavaQuoteHandler() {
        super(TokenSet.orSet((TokenSet[])new TokenSet[]{BasicElementTypes.BASIC_TEXT_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_TAG_VALUE_QUOTE})}));
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean openingQuote = super.isOpeningQuote(iterator, offset);
        if (openingQuote && !iterator.atEnd()) {
            iterator.retreat();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                openingQuote = false;
            }
            iterator.advance();
        }
        return openingQuote;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_LITERAL) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start >= 5 && offset >= end - 3;
        }
        boolean closingQuote = super.isClosingQuote(iterator, offset);
        if (closingQuote && !iterator.atEnd()) {
            iterator.advance();
            if (!iterator.atEnd() && StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType())) {
                closingQuote = false;
            }
            iterator.retreat();
        }
        return closingQuote;
    }

    @NotNull
    public TokenSet getConcatenatableStringTokenTypes() {
        TokenSet tokenSet = this.myConcatenableStrings;
        if (tokenSet == null) {
            JavaQuoteHandler.$$$reportNull$$$0(0);
        }
        return tokenSet;
    }

    public String getStringConcatenationOperatorRepresentation() {
        return "+";
    }

    public TokenSet getStringTokenTypes() {
        return this.myLiteralTokenSet;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            JavaQuoteHandler.$$$reportNull$$$0(1);
        }
        return this.myAppropriateElementTypeForLiteral.contains(tokenType);
    }

    public boolean needParenthesesAroundConcatenation(PsiElement element) {
        return element != null && element.getParent() != null && element.getParent().getParent() != null && BasicJavaAstTreeUtil.is(element.getParent().getNode(), BasicJavaElementType.BASIC_LITERAL_EXPRESSION) && BasicJavaAstTreeUtil.is(element.getParent().getParent().getNode(), BasicJavaElementType.REFERENCE_EXPRESSION_SET);
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            JavaQuoteHandler.$$$reportNull$$$0(2);
        }
        return (iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_LITERAL || iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) && offset == iterator.getStart() + 3 ? "\"\"\"" : null;
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        if (iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_LITERAL || iterator.getTokenType() == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
            PsiFile file;
            Document document = editor.getDocument();
            Project project = editor.getProject();
            PsiFile psiFile = file = project == null ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (file == null || !JavaQuoteHandler.testBlocksIsAvailable(file)) {
                return false;
            }
            String text = document.getText();
            boolean hasOpenQuotes = StringUtil.equals((CharSequence)text.substring(iterator.getStart(), offset + 1), (CharSequence)"\"\"\"");
            if (hasOpenQuotes) {
                boolean hasCloseQuotes = StringUtil.contains((CharSequence)text.substring(offset + 1, iterator.getEnd()), (CharSequence)"\"\"\"");
                if (!hasCloseQuotes) {
                    return true;
                }
                int nTextBlockQuotes = StringUtil.getOccurrenceCount((String)text.substring(iterator.getEnd()), (String)"\"\"\"");
                return nTextBlockQuotes % 2 != 0;
            }
        }
        return super.hasNonClosedLiteral(editor, iterator, offset);
    }

    private static boolean testBlocksIsAvailable(@NotNull PsiFile file) {
        if (file == null) {
            JavaQuoteHandler.$$$reportNull$$$0(3);
        }
        return AbstractBasicJavaDefinitionService.getJavaDefinitionService().getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_15);
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, @NotNull PsiFile file, @NotNull CharSequence closingQuote) {
        if (editor == null) {
            JavaQuoteHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JavaQuoteHandler.$$$reportNull$$$0(5);
        }
        if (closingQuote == null) {
            JavaQuoteHandler.$$$reportNull$$$0(6);
        }
        editor.getDocument().insertString(offset, (CharSequence)"\n\"\"\"");
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement token = file.findElementAt(offset);
        if (token == null) {
            return;
        }
        PsiElement parent = token.getParent();
        if (parent != null && BasicJavaAstTreeUtil.is(parent.getNode(), BasicJavaElementType.BASIC_LITERAL_EXPRESSION)) {
            CodeStyleManager.getInstance((Project)project).reformat(parent);
            editor.getCaretModel().moveToOffset(parent.getTextRange().getEndOffset() - 3);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/JavaQuoteHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingQuote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcatenatableStringTokenTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/JavaQuoteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateElementTypeForLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClosingQuote";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "testBlocksIsAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertClosingQuote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

