/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.JavaTypingTokenSets;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBasicJavaTypedHandler
extends TypedHandlerDelegate {
    private boolean myJavaLTTyped;

    protected AbstractBasicJavaTypedHandler() {
    }

    protected abstract boolean isJavaFile(@NotNull PsiFile var1);

    protected abstract boolean isJspFile(@NotNull PsiFile var1);

    protected abstract void autoPopupMemberLookup(@NotNull Project var1, @NotNull Editor var2);

    protected abstract void autoPopupJavadocLookup(@NotNull Project var1, @NotNull Editor var2);

    protected abstract boolean isLanguageLevel5OrHigher(@NotNull PsiFile var1);

    @NotNull
    protected abstract TypedHandlerDelegate.Result processWhileAndIfStatementBody(@NotNull Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    public abstract boolean handleEquality(Project var1, Editor var2, PsiFile var3, int var4);

    protected abstract boolean handleQuestionMark(Project var1, Editor var2, PsiFile var3, int var4);

    protected abstract boolean handleAnnotationParameter(Project var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        HighlighterIterator iterator;
        int offset;
        if (project == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(3);
        }
        if (!this.isJavaFile(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                AbstractBasicJavaTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (c == '@') {
            this.autoPopupJavadocLookup(project, editor);
        } else if (c == '#' || c == '.') {
            this.autoPopupMemberLookup(project, editor);
        }
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && !this.isJspFile(file) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && this.isLanguageLevel5OrHigher(file) && TypedHandlerUtil.isAfterClassLikeIdentifierOrDot((int)offsetBefore, (Editor)editor, (IElementType)JavaTokenType.DOT, (IElementType)JavaTokenType.IDENTIFIER, (boolean)true);
        if ('>' == c && !this.isJspFile(file) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && this.isLanguageLevel5OrHigher(file) && TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)JavaTypingTokenSets.INVALID_INSIDE_REFERENCE)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                AbstractBasicJavaTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        if (c == '?' && this.handleQuestionMark(project, editor, file, offsetBefore)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                AbstractBasicJavaTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        if (c == '=' && this.handleEquality(project, editor, file, offsetBefore)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                AbstractBasicJavaTypedHandler.$$$reportNull$$$0(7);
            }
            return result;
        }
        if (c == ';' && AbstractBasicJavaTypedHandler.handleSemicolon(project, editor, file, fileType)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                AbstractBasicJavaTypedHandler.$$$reportNull$$$0(8);
            }
            return result;
        }
        if (fileType instanceof JavaFileType && c == '}') {
            offset = editor.getCaretModel().getOffset();
            iterator = editor.getHighlighter().createIterator(offset);
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if (!(iterator.atEnd() || iterator.getStart() != offset || iterator.getTokenType() != JavaTokenType.STRING_TEMPLATE_END && iterator.getTokenType() != JavaTokenType.TEXT_BLOCK_TEMPLATE_END && iterator.getTokenType() != JavaTokenType.STRING_TEMPLATE_MID && iterator.getTokenType() != JavaTokenType.TEXT_BLOCK_TEMPLATE_MID || sequence.length() <= offset || sequence.charAt(offset) != '}')) {
                editor.getCaretModel().moveToOffset(offset + 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(9);
                }
                return result;
            }
        }
        if (fileType instanceof JavaFileType && c == '{') {
            PsiElement prev;
            CharSequence sequence;
            offset = editor.getCaretModel().getOffset();
            if (offset == 0) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(10);
                }
                return result;
            }
            iterator = editor.getHighlighter().createIterator(offset - 1);
            while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                iterator.retreat();
            }
            if (iterator.atEnd() || iterator.getTokenType() == JavaTokenType.RBRACKET || iterator.getTokenType() == JavaTokenType.EQ) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(11);
                }
                return result;
            }
            Document doc = editor.getDocument();
            if (!(iterator.atEnd() || iterator.getTokenType() != StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && iterator.getTokenType() != StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || (sequence = doc.getCharsSequence()).charAt(offset - 1) != '\\' || sequence.length() != offset && sequence.charAt(offset) == '}')) {
                doc.insertString(offset, (CharSequence)"{}");
                editor.getCaretModel().moveToOffset(offset + 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
            PsiElement leaf = file.findElementAt(offset);
            if (BasicJavaAstTreeUtil.getParentOfType(leaf, BasicJavaElementType.BASIC_ARRAY_INITIALIZER_EXPRESSION, false, ParentAwareTokenSet.orSet((ParentAwareTokenSet[])new ParentAwareTokenSet[]{ParentAwareTokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_CODE_BLOCK}), BasicJavaElementType.MEMBER_SET})) != null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(13);
                }
                return result;
            }
            PsiElement st = leaf != null ? leaf.getParent() : null;
            PsiElement psiElement = prev = offset > 1 ? file.findElementAt(offset - 1) : null;
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && AbstractBasicJavaTypedHandler.isRparenth(leaf) && st != null && (BasicJavaAstTreeUtil.is(st.getNode(), BasicJavaElementType.BASIC_WHILE_STATEMENT) || BasicJavaAstTreeUtil.is(st.getNode(), BasicJavaElementType.BASIC_IF_STATEMENT)) && AbstractBasicJavaTypedHandler.shouldInsertStatementBody(st, doc, prev)) {
                TypedHandlerDelegate.Result result = this.processWhileAndIfStatementBody(project, editor, file);
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(14);
                }
                return result;
            }
            if (BasicJavaAstTreeUtil.getParentOfType(leaf, BasicJavaElementType.BASIC_CODE_BLOCK, false, BasicJavaElementType.MEMBER_SET) != null && !AbstractBasicJavaTypedHandler.shouldInsertPairedBrace(leaf)) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{");
                TypedHandler.indentOpenedBrace((Project)project, (Editor)editor);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(15);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(16);
        }
        return result;
    }

    private static boolean shouldInsertPairedBrace(@NotNull PsiElement leaf) {
        PsiElement prevLeaf;
        if (leaf == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(17);
        }
        if ((prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf)) != null && prevLeaf.getNode().getElementType() == JavaTokenType.ARROW) {
            return true;
        }
        ParentAwareTokenSet stopAt = ParentAwareTokenSet.orSet((ParentAwareTokenSet[])new ParentAwareTokenSet[]{BasicJavaElementType.MEMBER_SET, ParentAwareTokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_CODE_BLOCK})});
        if (BasicJavaAstTreeUtil.getParentOfType(prevLeaf, BasicJavaElementType.BASIC_NEW_EXPRESSION, true, stopAt) != null) {
            return true;
        }
        if (prevLeaf != null && prevLeaf.getParent() != null && BasicJavaAstTreeUtil.is(prevLeaf.getNode(), JavaTokenType.IDENTIFIER) && BasicJavaAstTreeUtil.is(prevLeaf.getParent().getNode(), BasicJavaElementType.CLASS_SET)) {
            return true;
        }
        return prevLeaf != null && prevLeaf.getParent() != null && prevLeaf.getNode().getElementType() == JavaTokenType.RPARENTH && BasicJavaAstTreeUtil.is(prevLeaf.getParent().getNode(), BasicJavaElementType.BASIC_RECORD_HEADER);
    }

    private static boolean shouldInsertStatementBody(@NotNull PsiElement statement, @NotNull Document doc, @Nullable PsiElement prev) {
        ASTNode astNodeStatement;
        if (statement == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(18);
        }
        if (doc == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(19);
        }
        ASTNode block = BasicJavaAstTreeUtil.is(astNodeStatement = statement.getNode(), BasicJavaElementType.BASIC_WHILE_STATEMENT) ? BasicJavaAstTreeUtil.getBlock(astNodeStatement) : BasicJavaAstTreeUtil.getThenBranch(astNodeStatement);
        ASTNode condition = BasicJavaAstTreeUtil.findChildByType(astNodeStatement, BasicJavaElementType.EXPRESSION_SET);
        ASTNode latestExpression = BasicJavaAstTreeUtil.getParentOfType(BasicJavaAstTreeUtil.toNode(prev), BasicJavaElementType.EXPRESSION_SET);
        if (BasicJavaAstTreeUtil.is(latestExpression, BasicJavaElementType.BASIC_NEW_EXPRESSION) && BasicJavaAstTreeUtil.getAnonymousClass(latestExpression) == null) {
            return false;
        }
        return !BasicJavaAstTreeUtil.is(block, BasicJavaElementType.BASIC_BLOCK_STATEMENT) && (block == null || AbstractBasicJavaTypedHandler.startLine(doc, block) != AbstractBasicJavaTypedHandler.startLine(doc, astNodeStatement) || condition == null);
    }

    private static boolean isRparenth(@Nullable PsiElement leaf) {
        if (leaf == null) {
            return false;
        }
        if (leaf.getNode().getElementType() == JavaTokenType.RPARENTH) {
            return true;
        }
        PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf);
        if (next == null) {
            return false;
        }
        return next.getNode().getElementType() == JavaTokenType.RPARENTH;
    }

    private static int startLine(@NotNull Document doc, @NotNull ASTNode astNode) {
        if (doc == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(20);
        }
        if (astNode == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(21);
        }
        return doc.getLineNumber(astNode.getTextRange().getStartOffset());
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(22);
        }
        if (editor == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(23);
        }
        if (file == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(24);
        }
        if (!this.isJavaFile(file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                AbstractBasicJavaTypedHandler.$$$reportNull$$$0(25);
            }
            return result;
        }
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)JavaTypingTokenSets.INVALID_INSIDE_REFERENCE);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                AbstractBasicJavaTypedHandler.$$$reportNull$$$0(26);
            }
            return result;
        }
        if (c == ':') {
            if (AbstractBasicJavaTypedHandler.autoIndentCase(editor, project, file)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(27);
                }
                return result;
            }
        } else {
            if (c == ',' && this.handleAnnotationParameter(project, editor, file)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(28);
                }
                return result;
            }
            if (c == '.' && AbstractBasicJavaTypedHandler.handleDotTyped(project, editor, file)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    AbstractBasicJavaTypedHandler.$$$reportNull$$$0(29);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(30);
        }
        return result;
    }

    private static boolean handleDotTyped(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        if (project == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(31);
        }
        if (editor == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(32);
        }
        if (file == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(33);
        }
        if ((offset = editor.getCaretModel().getOffset() - 1) >= 0) {
            Document document = editor.getDocument();
            int line = document.getLineNumber(offset);
            int lineStart = document.getLineStartOffset(line);
            if (StringUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence().subSequence(lineStart, offset))) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset);
                return true;
            }
        }
        return false;
    }

    private static boolean handleSemicolon(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(34);
        }
        if (editor == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(35);
        }
        if (file == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(36);
        }
        if (fileType == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(37);
        }
        if (!(fileType instanceof JavaFileType)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        if (AbstractBasicJavaTypedHandler.moveSemicolonAtRParen(project, editor, file, offset)) {
            return true;
        }
        char charAt = editor.getDocument().getCharsSequence().charAt(offset);
        if (charAt != ';') {
            return false;
        }
        HighlighterIterator hi = editor.getHighlighter().createIterator(offset);
        if (hi.atEnd() || hi.getTokenType() != JavaTokenType.SEMICOLON) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    private static boolean moveSemicolonAtRParen(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int caretOffset) {
        if (project == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(38);
        }
        if (editor == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(39);
        }
        if (file == null) {
            AbstractBasicJavaTypedHandler.$$$reportNull$$$0(40);
        }
        if (!Registry.is((String)"editor.move.semicolon.after.paren")) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        HighlighterIterator it = editor.getHighlighter().createIterator(caretOffset);
        int afterLastParenOffset = -1;
        while (!it.atEnd() && !AbstractBasicJavaTypedHandler.isAtLineEnd(it) && it.getTokenType() != JavaTokenType.RBRACE) {
            if (it.getTokenType() == JavaTokenType.RPARENTH) {
                afterLastParenOffset = it.getEnd();
            } else if (it.getTokenType() != TokenType.WHITE_SPACE) {
                return false;
            }
            it.advance();
        }
        if (!it.atEnd() && afterLastParenOffset >= 0 && afterLastParenOffset >= caretOffset) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement curElement = file.findElementAt(caretOffset);
            ASTNode curStmt = BasicJavaAstTreeUtil.getParentOfType(BasicJavaAstTreeUtil.toNode(curElement), BasicJavaElementType.STATEMENT_SET);
            if (curStmt != null) {
                int stmtEndOffset;
                if (BasicJavaAstTreeUtil.is(curStmt, BasicJavaElementType.BASIC_TRY_STATEMENT)) {
                    return false;
                }
                if (BasicJavaAstTreeUtil.is(curStmt, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
                    return false;
                }
                PsiElement curPsiElement = BasicJavaAstTreeUtil.toPsi(curStmt);
                if (curPsiElement != null && PsiTreeUtil.getDeepestLast((PsiElement)curPsiElement) instanceof PsiErrorElement && ((stmtEndOffset = curStmt.getTextRange().getEndOffset()) == afterLastParenOffset || stmtEndOffset == it.getStart())) {
                    editor.getDocument().insertString(stmtEndOffset, (CharSequence)";");
                    editor.getCaretModel().moveToOffset(stmtEndOffset + 1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isAtLineEnd(HighlighterIterator it) {
        if (it.getTokenType() == TokenType.WHITE_SPACE) {
            CharSequence tokenText = it.getDocument().getImmutableCharSequence().subSequence(it.getStart(), it.getEnd());
            return CharArrayUtil.containLineBreaks((CharSequence)tokenText);
        }
        return false;
    }

    private static boolean autoIndentCase(Editor editor, Project project, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset - 1);
        if (currElement != null && BasicJavaAstTreeUtil.is(BasicJavaAstTreeUtil.toNode(parent = currElement.getParent()), BasicJavaElementType.BASIC_SWITCH_LABEL_STATEMENT)) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, parent.getTextOffset());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 25, 26, 27, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 23: 
            case 32: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 24: 
            case 33: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/AbstractBasicJavaTypedHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/AbstractBasicJavaTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertPairedBrace";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertStatementBody";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startLine";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "handleDotTyped";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "handleSemicolon";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "moveSemicolonAtRParen";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 25, 26, 27, 28, 29, 30 -> new IllegalStateException(string);
        };
    }
}

