/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.sunburst;

import com.intellij.profiler.ui.sunburst.Sunburst;
import com.intellij.profiler.ui.sunburst.SunburstKt;
import com.intellij.profiler.ui.sunburst.SunburstModel;
import com.intellij.profiler.ui.sunburst.SunburstSection;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.JBAnimator;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.EDT;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.DoubleConsumer;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002KLB\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010.\u001a\u00020/2\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110%2\u0012\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110%H\u0002JD\u00102\u001a\u00020/2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u0002062\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\u0015H\u0002J\u001d\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\b\u0010=\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010>J\u001e\u0010<\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00112\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206J\b\u0010?\u001a\u00020/H\u0002J3\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110%2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\n\b\u0002\u0010A\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020/H\u0007J\"\u0010D\u001a\u00020/2\u001a\u0010E\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00180\u0017J \u0010F\u001a\u00020/2\u0018\u0010E\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\u0004\u0012\u00020\u00180\u0017J\u0010\u0010G\u001a\u00020/2\u0006\u00103\u001a\u00020HH\u0014J\u0006\u0010'\u001a\u00020(J\u0016\u0010'\u001a\u00020/2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206J \u0010I\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110%H\u0002J\u001a\u0010J\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011*\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u0004\u0018\u00018\u00002\b\u0010\b\u001a\u0004\u0018\u00018\u0000@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR*\u0010\u000f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110\u0010j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR0\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00110%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006M"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst;", "T", "Ljavax/swing/JComponent;", "()V", "adjust", "", "animator", "Lcom/intellij/util/animation/JBAnimator;", "value", "center", "getCenter", "()Ljava/lang/Object;", "setCenter", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "comparator", "Ljava/util/Comparator;", "Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "Lkotlin/Comparator;", "hiddenItemsColor", "Lkotlin/Function1;", "Ljava/awt/Color;", "hover", "Ljava/util/function/BiConsumer;", "Ljava/awt/event/InputEvent;", "hovered", "getHovered", "()Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "setHovered", "(Lcom/intellij/profiler/ui/sunburst/SunburstSection;)V", "Lcom/intellij/profiler/ui/sunburst/SunburstModel;", "model", "getModel", "()Lcom/intellij/profiler/ui/sunburst/SunburstModel;", "setModel", "(Lcom/intellij/profiler/ui/sunburst/SunburstModel;)V", "sections", "", "select", "shift", "Ljava/awt/Point;", "thickness", "getThickness", "()D", "setThickness", "(D)V", "animate", "", "source", "target", "fillSection", "g", "Ljava/awt/Graphics2D;", "x", "", "y", "from", "to", "depth", "color", "findSection", "content", "(Ljava/lang/Object;)Lcom/intellij/profiler/ui/sunburst/SunburstSection;", "fireMouseHoverEvent", "generate", "root", "(Lcom/intellij/profiler/ui/sunburst/SunburstModel;Ljava/lang/Object;)Ljava/util/Collection;", "ignorePowerSave", "onHover", "consumer", "onSelect", "paintComponent", "Ljava/awt/Graphics;", "getRootSection", "takeIfVisible", "MouseListener", "SortedIterable", "intellij.profiler.common"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nSunburst.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sunburst.kt\ncom/intellij/profiler/ui/sunburst/Sunburst\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,424:1\n1#2:425\n1855#3,2:426\n1855#3,2:428\n1855#3,2:430\n1855#3,2:432\n1855#3,2:434\n1855#3,2:440\n1855#3,2:442\n1855#3,2:444\n215#4,2:436\n215#4,2:438\n*S KotlinDebug\n*F\n+ 1 Sunburst.kt\ncom/intellij/profiler/ui/sunburst/Sunburst\n*L\n148#1:426,2\n158#1:428,2\n185#1:430,2\n189#1:432,2\n205#1:434,2\n235#1:440,2\n239#1:442,2\n251#1:444,2\n213#1:436,2\n222#1:438,2\n*E\n"})
public final class Sunburst<T>
extends JComponent {
    private double thickness = 20.0;
    @NotNull
    private SunburstModel<T> model = new SunburstModel.Empty();
    @Nullable
    private T center;
    @Nullable
    private SunburstSection<T> hovered;
    @Nullable
    private Function1<? super SunburstSection<T>, ? extends Color> hiddenItemsColor = new Function1<SunburstSection<T>, JBColor>(this){
        final /* synthetic */ Sunburst<T> this$0;
        {
            this.this$0 = $receiver;
            super(1);
        }

        @NotNull
        public final JBColor invoke(@NotNull SunburstSection<T> base) {
            Intrinsics.checkNotNullParameter(base, (String)"base");
            JBColor jBColor = JBColor.lazy(() -> hiddenItemsColor.1.invoke$lambda$0(this.this$0, base));
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
            return jBColor;
        }

        private static final Color invoke$lambda$0(Sunburst this$0, SunburstSection $base) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$base, (String)"$base");
            double proportion = ColorUtil.isDark((Color)this$0.getBackground()) ? 0.9 : 0.8;
            return ColorUtil.mix((Color)$base.getColor(), (Color)this$0.getBackground(), (double)proportion);
        }
    };
    @NotNull
    private final JBAnimator animator;
    @NotNull
    private final Comparator<SunburstSection<T>> comparator;
    @NotNull
    private Collection<SunburstSection<T>> sections;
    private double adjust;
    @NotNull
    private final Point shift;
    @NotNull
    private BiConsumer<SunburstSection<T>, InputEvent> hover;
    @NotNull
    private BiConsumer<SunburstSection<T>, InputEvent> select;

    /*
     * WARNING - void declaration
     */
    public Sunburst() {
        void $this$animator_u24lambda_u240;
        JBAnimator jBAnimator;
        JBAnimator jBAnimator2 = jBAnimator = new JBAnimator();
        Sunburst sunburst = this;
        boolean bl = false;
        $this$animator_u24lambda_u240.setPeriod(16);
        sunburst.animator = jBAnimator;
        this.comparator = Sunburst::comparator$lambda$1;
        this.sections = new ArrayList();
        this.shift = new Point(0, 0);
        this.hover = (arg_0, arg_1) -> Sunburst.hover$lambda$2(this, arg_0, arg_1);
        this.select = Sunburst::select$lambda$3;
        MouseListener listener2 = new MouseListener();
        this.addMouseMotionListener(listener2);
        this.addMouseListener(listener2);
    }

    public final double getThickness() {
        return this.thickness;
    }

    public final void setThickness(double value) {
        this.thickness = value;
        this.repaint();
    }

    @NotNull
    public final SunburstModel<T> getModel() {
        return this.model;
    }

    public final void setModel(@NotNull SunburstModel<T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.model = value;
        this.setCenter(value.getRoot());
    }

    @Nullable
    public final T getCenter() {
        return this.center;
    }

    public final void setCenter(@Nullable T value) {
        this.center = value;
        this.hovered = null;
        if (this.model instanceof SunburstModel.WithAnimation) {
            this.animate(this.sections, this.generate(this.model, value));
        } else {
            this.sections = this.generate(this.model, value);
            this.fireMouseHoverEvent();
            this.repaint();
        }
    }

    @Nullable
    public final SunburstSection<T> getHovered() {
        return this.hovered;
    }

    public final void setHovered(@Nullable SunburstSection<T> sunburstSection) {
        this.hovered = sunburstSection;
    }

    private final void fireMouseHoverEvent() {
        Point position;
        if (!GraphicsEnvironment.isHeadless() && (position = this.getMousePosition(true)) != null) {
            SunburstSection<T> section = this.findSection(position.x, position.y);
            MouseEvent event = new MouseEvent(this, 503, 0L, 0, position.x, position.y, 0, false);
            this.hover.accept(section, event);
        }
    }

    @TestOnly
    public final void ignorePowerSave() {
        this.animator.ignorePowerSaveMode();
    }

    public final void onHover(@NotNull BiConsumer<SunburstSection<T>, InputEvent> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BiConsumer<SunburstSection<SunburstSection<T>>, InputEvent> biConsumer = this.hover.andThen(consumer);
        Intrinsics.checkNotNullExpressionValue(biConsumer, (String)"andThen(...)");
        this.hover = biConsumer;
    }

    public final void onSelect(@NotNull BiConsumer<SunburstSection<T>, InputEvent> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BiConsumer<SunburstSection<SunburstSection<T>>, InputEvent> biConsumer = this.select.andThen(consumer);
        Intrinsics.checkNotNullExpressionValue(biConsumer, (String)"andThen(...)");
        this.select = biConsumer;
    }

    @Nullable
    public final SunburstSection<T> findSection(int x, int y) {
        Object v0;
        block2: {
            double dX = (double)x - (double)this.getWidth() / 2.0 + (double)this.shift.x;
            double dY = (double)y - (double)this.getHeight() / 2.0 + (double)this.shift.y;
            double radius = Math.sqrt(dX * dX + dY * dY) - this.adjust;
            Ref.DoubleRef angle = new Ref.DoubleRef();
            angle.element = Math.atan2(dX, -dY);
            if (angle.element < 0.0) {
                angle.element += Math.PI * 2;
            }
            angle.element /= Math.PI * 2;
            Function1 condition2 = new Function1<SunburstSection<T>, Boolean>(angle, this, radius){
                final /* synthetic */ Ref.DoubleRef $angle;
                final /* synthetic */ Sunburst<T> this$0;
                final /* synthetic */ double $radius;
                {
                    this.$angle = $angle;
                    this.this$0 = $receiver;
                    this.$radius = $radius;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull SunburstSection<T> s) {
                    Intrinsics.checkNotNullParameter(s, (String)"s");
                    return s.getStart() <= this.$angle.element && this.$angle.element <= s.getEnd() && (double)s.getDepth() * this.this$0.getThickness() <= this.$radius && this.$radius <= (double)(s.getDepth() + 1) * this.this$0.getThickness();
                }
            };
            Iterable iterable = this.sections;
            for (Object t : iterable) {
                if (!((Boolean)condition2.invoke(t)).booleanValue()) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SunburstSection sunburstSection = v0;
        return sunburstSection != null ? this.takeIfVisible(sunburstSection) : null;
    }

    @Nullable
    public final SunburstSection<T> findSection(@Nullable T content) {
        Object v0;
        block2: {
            if (content == null) {
                return null;
            }
            Iterable iterable = this.sections;
            for (Object t : iterable) {
                SunburstSection it = (SunburstSection)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getContent(), content)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        SunburstSection sunburstSection = v0;
        return sunburstSection != null ? this.takeIfVisible(sunburstSection) : null;
    }

    private final SunburstSection<T> takeIfVisible(SunburstSection<T> $this$takeIfVisible) {
        SunburstSection<T> sunburstSection;
        SunburstSection<T> it = sunburstSection = $this$takeIfVisible;
        boolean bl = false;
        return SunburstKt.access$createShape(it, this.getWidth() / 2, this.getHeight() / 2, this.thickness, this.adjust) != null ? sunburstSection : null;
    }

    public final void shift(int x, int y) {
        this.shift.x = x;
        this.shift.y = y;
        this.repaint();
    }

    @NotNull
    public final Point shift() {
        return new Point(this.shift.x, this.shift.y);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        Rectangle bounds2 = g2d.getClipBounds();
        g2d.setPaint(this.getBackground());
        g2d.fillRect(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
        int x = bounds2.width / 2 - this.shift.x;
        int y = bounds2.height / 2 - this.shift.y;
        if (!this.sections.isEmpty() && this.hiddenItemsColor != null) {
            SortedIterable<SunburstSection<T>> shadows = new SortedIterable<SunburstSection<T>>(this.sections, this.comparator);
            SunburstSection current = null;
            current = new SunburstSection((SunburstSection)CollectionsKt.first((Iterable)shadows));
            Iterable $this$forEach$iv = shadows;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SunburstSection next = (SunburstSection)element$iv;
                boolean bl = false;
                if (next.getStart() - current.getEnd() >= 0.002777777777777778 || current.getDepth() != next.getDepth()) {
                    Function1<? super SunburstSection<T>, ? extends Color> function1 = this.hiddenItemsColor;
                    this.fillSection((Graphics2D)g, x, y, current.getStart(), current.getEnd(), current.getDepth(), function1 != null ? (Color)function1.invoke(current) : null);
                    current = new SunburstSection(next);
                }
                current.setEnd(next.getEnd());
            }
            Function1<? super SunburstSection<T>, ? extends Color> function1 = this.hiddenItemsColor;
            this.fillSection((Graphics2D)g, x, y, current.getStart(), current.getEnd(), current.getDepth(), function1 != null ? (Color)function1.invoke(current) : null);
        }
        Iterable $this$forEach$iv = this.sections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape shape;
            SunburstSection it = (SunburstSection)element$iv;
            boolean bl = false;
            if (SunburstKt.access$createShape(it, x, y, this.thickness, this.adjust) == null) continue;
            Color color2 = it.getColor();
            g2d.setColor(this.hovered == it ? ColorUtil.mix((Color)color2, (Color)Color.BLACK, (double)0.05) : color2);
            g2d.fill(shape);
        }
    }

    private final void fillSection(Graphics2D g, int x, int y, double from2, double to, int depth, Color color2) {
        Color color3 = color2;
        if (color3 == null) {
            color3 = Color.GRAY;
        }
        Color color4 = color3;
        Intrinsics.checkNotNull((Object)color4);
        Shape stub = SunburstKt.access$createShape(new SunburstSection<Object>(null, from2, to, depth, color4), x, y, this.thickness, this.adjust);
        if (stub != null) {
            if (color2 != null) {
                g.setColor(color2);
            }
            g.fill(stub);
        }
    }

    static /* synthetic */ void fillSection$default(Sunburst sunburst, Graphics2D graphics2D, int n, int n2, double d, double d2, int n3, Color color2, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            color2 = null;
        }
        sunburst.fillSection(graphics2D, n, n2, d, d2, n3, color2);
    }

    /*
     * WARNING - void declaration
     */
    private final void animate(Collection<SunburstSection<T>> source, Collection<SunburstSection<T>> target) {
        void $this$animate_u24lambda_u2432;
        Animation animation;
        SunburstSection section;
        Object k;
        Object content;
        Object element$iv;
        EDT.assertIsEdt();
        SunburstModel<T> sunburstModel = this.model;
        SunburstModel.WithAnimation withAnimation = sunburstModel instanceof SunburstModel.WithAnimation ? (SunburstModel.WithAnimation)sunburstModel : null;
        if (withAnimation == null) {
            throw new IllegalStateException();
        }
        SunburstModel.WithAnimation model2 = withAnimation;
        SunburstSection<T> oldRoot = this.getRootSection(source);
        SunburstSection<T> newRoot = this.getRootSection(target);
        int distance = oldRoot != null && newRoot != null ? model2.getDistance(oldRoot.getContent(), newRoot.getContent()) : 0;
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap((int)source.size());
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
        Map sourceMap = map2;
        Iterable $this$forEach$iv = source;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            SunburstSection it = (SunburstSection)element$iv2;
            boolean bl = false;
            sourceMap.put(it.getContent(), it);
        }
        Map map3 = CollectionFactory.createSmallMemoryFootprintMap((int)target.size());
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createSmallMemoryFootprintMap(...)");
        Map targetMap = map3;
        Iterable $this$forEach$iv2 = target;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            SunburstSection it = (SunburstSection)element$iv3;
            boolean bl = false;
            targetMap.put(it.getContent(), it);
        }
        Set set = CollectionFactory.createSmallMemoryFootprintSet((Collection)sourceMap.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet(...)");
        Set sameSet = set;
        sameSet.retainAll(targetMap.keySet());
        SunburstSection<T> sunburstSection = newRoot;
        SunburstSection oldNewRoot = (SunburstSection)sourceMap.get(sunburstSection != null ? sunburstSection.getContent() : null);
        SunburstSection<T> sunburstSection2 = oldRoot;
        SunburstSection newOldRoot = (SunburstSection)targetMap.get(sunburstSection2 != null ? sunburstSection2.getContent() : null);
        List animations = new ArrayList();
        Object $this$forEach$iv22 = sameSet;
        boolean $i$f$forEach3 = false;
        Animation animation2 = $this$forEach$iv22.iterator();
        while (animation2.hasNext()) {
            SunburstSection to;
            SunburstSection from2;
            content = element$iv = animation2.next();
            boolean bl = false;
            if ((SunburstSection)sourceMap.get(content) == null) {
                throw new IllegalStateException(("can't find value " + content).toString());
            }
            if ((SunburstSection)targetMap.get(content) == null) {
                throw new IllegalStateException(("can't find value " + content).toString());
            }
            animations.add(Sunburst.animate$animation(from2.getStart(), to.getStart(), arg_0 -> Sunburst.animate$lambda$13$lambda$11(from2, arg_0)));
            animations.add(Sunburst.animate$animation(from2.getEnd(), to.getEnd(), arg_0 -> Sunburst.animate$lambda$13$lambda$12(from2, arg_0)));
        }
        if (oldNewRoot != null) {
            $this$forEach$iv22 = sourceMap;
            $i$f$forEach3 = false;
            animation2 = $this$forEach$iv22.entrySet().iterator();
            while (animation2.hasNext()) {
                content = element$iv = (Map.Entry)animation2.next();
                boolean bl = false;
                k = content.getKey();
                section = (SunburstSection)content.getValue();
                if (sameSet.contains(k)) continue;
                animations.add(Sunburst.animate$animation(section.getStart(), section.getStart() <= oldNewRoot.getStart() ? 0.0 : 1.0, arg_0 -> Sunburst.animate$lambda$16$lambda$14(section, arg_0)));
                animations.add(Sunburst.animate$animation(section.getEnd(), section.getEnd() < oldNewRoot.getEnd() ? 0.0 : 1.0, arg_0 -> Sunburst.animate$lambda$16$lambda$15(section, arg_0)));
            }
        }
        if (newOldRoot != null) {
            $this$forEach$iv22 = targetMap;
            $i$f$forEach3 = false;
            animation2 = $this$forEach$iv22.entrySet().iterator();
            while (animation2.hasNext()) {
                content = element$iv = (Map.Entry)animation2.next();
                boolean bl = false;
                k = content.getKey();
                section = (SunburstSection)content.getValue();
                if (sameSet.contains(k)) continue;
                double start2 = section.getStart() <= newOldRoot.getStart() ? 0.0 : 1.0;
                double end = section.getEnd() < newOldRoot.getEnd() ? 0.0 : 1.0;
                SunburstSection fake = new SunburstSection(section.getContent(), start2, end, section.getDepth() + distance, section.getColor());
                Collection<SunburstSection<T>> collection = this.sections;
                Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.MutableCollection<com.intellij.profiler.ui.sunburst.SunburstSection<T of com.intellij.profiler.ui.sunburst.Sunburst.animate$lambda$19>>");
                TypeIntrinsics.asMutableCollection(collection).add(fake);
                animations.add(Sunburst.animate$animation(fake.getStart(), section.getStart(), arg_0 -> Sunburst.animate$lambda$19$lambda$17(fake, arg_0)));
                animations.add(Sunburst.animate$animation(fake.getEnd(), section.getEnd(), arg_0 -> Sunburst.animate$lambda$19$lambda$18(fake, arg_0)));
            }
        }
        if (newOldRoot == null && oldNewRoot == null) {
            SunburstSection section2;
            boolean $this$forEach$iv3 = sameSet.isEmpty();
            if (_Assertions.ENABLED && !$this$forEach$iv3) {
                String $i$f$forEach4 = "Assertion failed";
                throw new AssertionError((Object)$i$f$forEach4);
            }
            $this$forEach$iv22 = sourceMap.values();
            $i$f$forEach3 = false;
            animation2 = $this$forEach$iv22.iterator();
            while (animation2.hasNext()) {
                element$iv = animation2.next();
                section2 = (SunburstSection)element$iv;
                boolean bl = false;
                animations.add(Sunburst.animate$animation(section2.getStart(), 1.0, arg_0 -> Sunburst.animate$lambda$22$lambda$20(section2, arg_0)));
                animations.add(Sunburst.animate$animation(section2.getEnd(), 1.0, arg_0 -> Sunburst.animate$lambda$22$lambda$21(section2, arg_0)));
            }
            $this$forEach$iv22 = targetMap.values();
            $i$f$forEach3 = false;
            animation2 = $this$forEach$iv22.iterator();
            while (animation2.hasNext()) {
                element$iv = animation2.next();
                section2 = (SunburstSection)element$iv;
                boolean bl = false;
                SunburstSection fake = new SunburstSection(section2.getContent(), 0.0, 0.0, section2.getDepth(), section2.getColor());
                Collection<SunburstSection<T>> collection = this.sections;
                Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.MutableCollection<com.intellij.profiler.ui.sunburst.SunburstSection<T of com.intellij.profiler.ui.sunburst.Sunburst.animate$lambda$25>>");
                TypeIntrinsics.asMutableCollection(collection).add(fake);
                animations.add(Sunburst.animate$animation(fake.getStart(), section2.getStart(), arg_0 -> Sunburst.animate$lambda$25$lambda$23(fake, arg_0)));
                animations.add(Sunburst.animate$animation(fake.getEnd(), section2.getEnd(), arg_0 -> Sunburst.animate$lambda$25$lambda$24(fake, arg_0)));
            }
        } else {
            animations.add(Sunburst.animate$animation(this.adjust, (double)(-distance) * this.thickness, arg_0 -> Sunburst.animate$lambda$26(this, arg_0)));
        }
        Animation[] animationArray = new Animation[1];
        animation2 = animation = new Animation(arg_0 -> Sunburst.animate$lambda$28(animations, arg_0));
        int n = 0;
        Animation[] animationArray2 = animationArray;
        JBAnimator jBAnimator = this.animator;
        boolean bl = false;
        $this$animate_u24lambda_u2432.setDuration(500);
        $this$animate_u24lambda_u2432.setEasing(Sunburst::animate$lambda$32$lambda$29);
        $this$animate_u24lambda_u2432.runWhenUpdated(() -> Sunburst.animate$lambda$32$lambda$30(this));
        $this$animate_u24lambda_u2432.runWhenExpired(() -> Sunburst.animate$lambda$32$lambda$31(this, target));
        Unit unit = Unit.INSTANCE;
        animationArray2[n] = animation;
        jBAnimator.animate(animationArray);
    }

    private final Collection<SunburstSection<T>> generate(SunburstModel<T> model2, T root) {
        List result2 = new ArrayList();
        if (root == null) {
            return result2;
        }
        result2.add(new SunburstSection<T>(root, 0.0, 1.0, 0, model2.getColor(root)));
        SunburstKt.access$generate0(model2, result2, root, 0.0, 1.0, 1);
        CollectionsKt.sortWith((List)result2, this.comparator);
        return result2;
    }

    static /* synthetic */ Collection generate$default(Sunburst sunburst, SunburstModel sunburstModel, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = sunburstModel.getRoot();
        }
        return sunburst.generate(sunburstModel, object);
    }

    private final SunburstSection<T> getRootSection(Collection<SunburstSection<T>> $this$getRootSection) {
        Object v0;
        block1: {
            Iterable iterable = $this$getRootSection;
            for (Object t : iterable) {
                SunburstSection it = (SunburstSection)t;
                boolean bl = false;
                if (!(it.getDepth() == 0)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final int comparator$lambda$1(SunburstSection o1, SunburstSection o2) {
        int byDepth = Intrinsics.compare((int)o1.getDepth(), (int)o2.getDepth());
        return byDepth != 0 ? byDepth : Double.compare(o1.getStart(), o2.getStart());
    }

    private static final void hover$lambda$2(Sunburst this$0, SunburstSection hover, InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"<anonymous parameter 1>");
        this$0.hovered = hover;
        this$0.repaint();
    }

    private static final void select$lambda$3(SunburstSection sunburstSection, InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)sunburstSection, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"<anonymous parameter 1>");
    }

    private static final void animate$animation$lambda$10(DoubleConsumer $consumer, double $from, double $to, double value) {
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        $consumer.accept($from + value * ($to - $from));
    }

    private static final DoubleConsumer animate$animation(double from2, double to, DoubleConsumer consumer) {
        return arg_0 -> Sunburst.animate$animation$lambda$10(consumer, from2, to, arg_0);
    }

    private static final void animate$lambda$13$lambda$11(SunburstSection $from, double it) {
        Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
        $from.setStart(it);
    }

    private static final void animate$lambda$13$lambda$12(SunburstSection $from, double it) {
        Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
        $from.setEnd(it);
    }

    private static final void animate$lambda$16$lambda$14(SunburstSection $section, double it) {
        $section.setStart(it);
    }

    private static final void animate$lambda$16$lambda$15(SunburstSection $section, double it) {
        $section.setEnd(it);
    }

    private static final void animate$lambda$19$lambda$17(SunburstSection $fake, double it) {
        Intrinsics.checkNotNullParameter((Object)$fake, (String)"$fake");
        $fake.setStart(it);
    }

    private static final void animate$lambda$19$lambda$18(SunburstSection $fake, double it) {
        Intrinsics.checkNotNullParameter((Object)$fake, (String)"$fake");
        $fake.setEnd(it);
    }

    private static final void animate$lambda$22$lambda$20(SunburstSection $section, double it) {
        $section.setStart(it);
    }

    private static final void animate$lambda$22$lambda$21(SunburstSection $section, double it) {
        $section.setEnd(it);
    }

    private static final void animate$lambda$25$lambda$23(SunburstSection $fake, double it) {
        Intrinsics.checkNotNullParameter((Object)$fake, (String)"$fake");
        $fake.setStart(it);
    }

    private static final void animate$lambda$25$lambda$24(SunburstSection $fake, double it) {
        Intrinsics.checkNotNullParameter((Object)$fake, (String)"$fake");
        $fake.setEnd(it);
    }

    private static final void animate$lambda$26(Sunburst this$0, double it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.adjust = it;
    }

    private static final void animate$lambda$28(List $animations, double value) {
        Intrinsics.checkNotNullParameter((Object)$animations, (String)"$animations");
        Iterable $this$forEach$iv = $animations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DoubleConsumer it = (DoubleConsumer)element$iv;
            boolean bl = false;
            it.accept(value);
        }
    }

    private static final double animate$lambda$32$lambda$29(double x) {
        return Math.sqrt(1.0 - Math.pow(1.0 - x, 3.0));
    }

    private static final void animate$lambda$32$lambda$30(Sunburst this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.repaint();
    }

    private static final void animate$lambda$32$lambda$31(Sunburst this$0, Collection $target) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        this$0.sections = $target;
        this$0.adjust = 0.0;
        this$0.fireMouseHoverEvent();
        this$0.repaint();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst$MouseListener;", "Ljava/awt/event/MouseAdapter;", "(Lcom/intellij/profiler/ui/sunburst/Sunburst;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "mouseMoved", "intellij.profiler.common"})
    private final class MouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getButton() != 1 || e.isConsumed()) {
                return;
            }
            SunburstSection section = Sunburst.this.findSection(e.getX(), e.getY());
            if (section != null) {
                Sunburst.this.select.accept(section, e);
                e.consume();
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Sunburst.this.hover.accept(Sunburst.this.findSection(e.getX(), e.getY()), e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Sunburst.this.hover.accept(null, e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0006j\b\u0012\u0004\u0012\u00028\u0001`\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rH\u0096\u0002R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00028\u00010\nj\b\u0012\u0004\u0012\u00028\u0001`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/sunburst/Sunburst$SortedIterable;", "T", "", "collection", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/Collection;Ljava/util/Comparator;)V", "data", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "iterator", "", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nSunburst.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sunburst.kt\ncom/intellij/profiler/ui/sunburst/Sunburst$SortedIterable\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,424:1\n1224#2,2:425\n*S KotlinDebug\n*F\n+ 1 Sunburst.kt\ncom/intellij/profiler/ui/sunburst/Sunburst$SortedIterable\n*L\n303#1:425,2\n*E\n"})
    private static final class SortedIterable<T>
    implements Iterable<T>,
    KMappedMarker {
        @NotNull
        private final ArrayList<T> data;

        public SortedIterable(@NotNull Collection<? extends T> collection, @NotNull Comparator<T> comparator2) {
            boolean isSorted;
            block2: {
                boolean bl;
                Intrinsics.checkNotNullParameter(collection, (String)"collection");
                Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
                this.data = new ArrayList<T>(collection);
                Sequence $this$all$iv = SequencesKt.zipWithNext((Sequence)CollectionsKt.asSequence((Iterable)this.data));
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    Object next;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    Object prev = pair.component1();
                    if (comparator2.compare(prev, next = pair.component2()) <= 0) continue;
                    bl = false;
                    break block2;
                }
                bl = isSorted = true;
            }
            if (!isSorted) {
                CollectionsKt.sortWith((List)this.data, comparator2);
            }
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            Iterator<T> iterator2 = this.data.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            return iterator2;
        }
    }
}

