/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.util.tracer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.sql.Time;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.util.tracer.AverageByKindTimePresentation;
import org.jetbrains.idea.perforce.util.tracer.AverageByKindTimeStatistics;
import org.jetbrains.idea.perforce.util.tracer.ConcurrentThreadsPresentation;
import org.jetbrains.idea.perforce.util.tracer.ConcurrentThreadsStatistics;
import org.jetbrains.idea.perforce.util.tracer.LongCallsParameters;
import org.jetbrains.idea.perforce.util.tracer.LongCallsPresentation;
import org.jetbrains.idea.perforce.util.tracer.LongCallsStatistics;
import org.jetbrains.idea.perforce.util.tracer.StatisticsPresentation;
import org.jetbrains.idea.perforce.util.tracer.Tracer;
import org.jetbrains.idea.perforce.util.tracer.TracerParameters;

public class TracerManager<Kind extends Enum>
implements Tracer<Kind, Object> {
    private final List<Pair<Tracer, StatisticsPresentation>> myPresentations;
    private final Logger myLogger;
    private final long myInterval;
    private long myPreviousOutputTime;
    private final Runnable myInnerLogger;

    public TracerManager(@Nullable TracerParameters traceAverageTimes, @Nullable TracerParameters traceNumberConcurrentThreads, @Nullable LongCallsParameters traceLongCalls, Logger logger, long interval) {
        this.myLogger = logger;
        this.myInterval = interval;
        this.myPresentations = new LinkedList<Pair<Tracer, StatisticsPresentation>>();
        this.myInnerLogger = () -> {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.myPreviousOutputTime < this.myInterval) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Statistics at: ").append(new Time(System.currentTimeMillis())).append('\n');
            for (Pair<Tracer, StatisticsPresentation> presentation : this.myPresentations) {
                ((StatisticsPresentation)presentation.getSecond()).putSelf(sb, (Tracer)presentation.getFirst());
                sb.append('\n');
            }
            this.myLogger.info(sb.toString());
            this.myPreviousOutputTime = currentTime;
        };
        if (traceAverageTimes != null) {
            this.myPresentations.add((Pair<Tracer, StatisticsPresentation>)new Pair(new AverageByKindTimeStatistics(traceAverageTimes.getIntervalInMillis(), traceAverageTimes.getHistoryQueueSize(), this.myInnerLogger), new AverageByKindTimePresentation()));
        }
        if (traceNumberConcurrentThreads != null) {
            this.myPresentations.add((Pair<Tracer, StatisticsPresentation>)new Pair(new ConcurrentThreadsStatistics(traceNumberConcurrentThreads.getIntervalInMillis(), traceNumberConcurrentThreads.getHistoryQueueSize(), this.myInnerLogger), new ConcurrentThreadsPresentation()));
        }
        if (traceLongCalls != null) {
            this.myPresentations.add((Pair<Tracer, StatisticsPresentation>)new Pair(new LongCallsStatistics(traceLongCalls.getIntervalInMillis(), traceLongCalls.getHistoryQueueSize(), this.myInnerLogger, traceLongCalls.getMaxKept(), traceLongCalls.getLowerBound()), new LongCallsPresentation()));
        }
    }

    @Override
    public Object start(Kind kind, String presentation) {
        ArrayList result = new ArrayList();
        for (Pair<Tracer, StatisticsPresentation> presentationPair : this.myPresentations) {
            result.add(((Tracer)presentationPair.getFirst()).start(kind, presentation));
        }
        return result;
    }

    @Override
    public void stop(Object o, Kind kind, String presentation) {
        List parameters = (List)o;
        for (int i = 0; i < parameters.size(); ++i) {
            Object param = parameters.get(i);
            Pair<Tracer, StatisticsPresentation> presentationPair = this.myPresentations.get(i);
            ((Tracer)presentationPair.getFirst()).stop(param, kind, presentation);
        }
    }
}

