/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class AuthNotifier {
    @NonNls
    public static final String INSPECT = "inspect";
    @NonNls
    public static final String FIX = "fix";
    @NonNls
    public static final String RETRY = "retry";
    @NonNls
    public static final String OFFLINE = "offline";
    private final Project myProject;
    private final PerforceSettings mySettings;
    private final MyLoginNotifier myLoginNotifier;
    private final MyPasswordNotifier myPasswordNotifier;

    public AuthNotifier(Project project, PerforceLoginManager loginManager, PerforceSettings perforceSettings) {
        this.myProject = project;
        this.mySettings = perforceSettings;
        this.myLoginNotifier = new MyLoginNotifier(this.myProject, loginManager);
        this.myPasswordNotifier = new MyPasswordNotifier(this.myProject, loginManager);
    }

    public void ensureNotify(P4Connection connection, VcsConnectionProblem exception) {
        if (!this.mySettings.ENABLED || !this.mySettings.USE_LOGIN) {
            return;
        }
        if (exception.getMessage().contains("Your password has expired")) {
            this.myPasswordNotifier.ensureNotify(connection);
        } else {
            this.myLoginNotifier.ensureNotify(connection);
        }
    }

    public void removeLazyNotification(P4Connection connection) {
        this.myLoginNotifier.removeLazyNotification(connection);
    }

    public void showPasswordWasOk(boolean value) {
        if (value) {
            new VcsBalloonProblemNotifier(this.myProject, PerforceBundle.message("login.successful", new Object[0]), MessageType.INFO).run();
        } else {
            new VcsBalloonProblemNotifier(this.myProject, PerforceBundle.message("login.not.logged.into.p4", new Object[0]), MessageType.ERROR).run();
        }
    }

    public boolean isEmpty() {
        return this.myLoginNotifier.isEmpty();
    }

    public void clear() {
        this.myLoginNotifier.clear();
        this.myPasswordNotifier.clear();
    }

    private static final class MyLoginNotifier
    extends GenericNotifierImpl<P4Connection, ConnectionId> {
        private final PerforceLoginManager myLoginManager;

        private MyLoginNotifier(Project project, PerforceLoginManager loginManager) {
            super(project, "Perforce", PerforceBundle.message("login.not.logged.in.title", new Object[0]), NotificationType.ERROR);
            this.myLoginManager = loginManager;
        }

        @NotNull
        @NlsContexts.NotificationContent
        protected String getNotificationContent(P4Connection connection) {
            HtmlBuilder builder = new HtmlBuilder();
            builder.append(HtmlChunk.raw((String)PerforceBundle.message("login.error.notification", connection.getWorkingDirectory())));
            builder.append((HtmlChunk)HtmlChunk.br());
            builder.append((HtmlChunk)HtmlChunk.link((String)AuthNotifier.FIX, (String)PerforceBundle.message("login.fix", new Object[0])));
            builder.append((HtmlChunk)HtmlChunk.br());
            builder.append((HtmlChunk)HtmlChunk.link((String)AuthNotifier.INSPECT, (String)PerforceBundle.message("login.inspect", new Object[0])));
            String string = builder.toString();
            if (string == null) {
                MyLoginNotifier.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected boolean ask(P4Connection obj, String description) {
            if (AuthNotifier.FIX.equals(description)) {
                return this.myLoginManager.checkAndRepair(obj);
            }
            if (AuthNotifier.INSPECT.equals(description)) {
                PerforceConnectionProblemsNotifier.showConnectionState(this.myProject, true);
                return false;
            }
            return false;
        }

        @NotNull
        protected ConnectionId getKey(P4Connection obj) {
            ConnectionId connectionId = obj.getId();
            if (connectionId == null) {
                MyLoginNotifier.$$$reportNull$$$0(1);
            }
            return connectionId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/perforce/perforce/login/AuthNotifier$MyLoginNotifier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class MyPasswordNotifier
    extends GenericNotifierImpl<P4Connection, ConnectionId> {
        private final PerforceLoginManager myLoginManager;

        public MyPasswordNotifier(@NotNull Project project, @NotNull PerforceLoginManager loginManager) {
            if (project == null) {
                MyPasswordNotifier.$$$reportNull$$$0(0);
            }
            if (loginManager == null) {
                MyPasswordNotifier.$$$reportNull$$$0(1);
            }
            super(project, "Perforce", PerforceBundle.message("login.password.expired.title", new Object[0]), NotificationType.ERROR);
            this.myLoginManager = loginManager;
        }

        protected boolean ask(P4Connection obj, @Nullable String description) {
            if (AuthNotifier.FIX.equals(description)) {
                return this.myLoginManager.checkPasswordExpirationAndRepair(obj);
            }
            if (AuthNotifier.INSPECT.equals(description)) {
                PerforceConnectionProblemsNotifier.showConnectionState(this.myProject, true);
                return false;
            }
            return false;
        }

        protected ConnectionId getKey(P4Connection obj) {
            return null;
        }

        @NotNull
        @NlsContexts.NotificationContent
        protected String getNotificationContent(P4Connection connection) {
            HtmlBuilder builder = new HtmlBuilder();
            builder.append(HtmlChunk.raw((String)PerforceBundle.message("login.password.expired", connection.getWorkingDirectory())));
            builder.append((HtmlChunk)HtmlChunk.br());
            builder.append((HtmlChunk)HtmlChunk.link((String)AuthNotifier.FIX, (String)PerforceBundle.message("login.fix", new Object[0])));
            builder.append((HtmlChunk)HtmlChunk.br());
            builder.append((HtmlChunk)HtmlChunk.link((String)AuthNotifier.INSPECT, (String)PerforceBundle.message("login.inspect", new Object[0])));
            String string = builder.toString();
            if (string == null) {
                MyPasswordNotifier.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loginManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/perforce/perforce/login/AuthNotifier$MyPasswordNotifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/perforce/perforce/login/AuthNotifier$MyPasswordNotifier";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

