/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.util.GitSimplePathsBrowser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitUntrackedFilesHelper {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHelper.class);

    private GitUntrackedFilesHelper() {
    }

    public static void notifyUntrackedFilesOverwrittenBy(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, @NotNull @Nls String operation, @Nullable @NlsContexts.DetailedDescription String description2) {
        if (project == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(1);
        }
        if (relativePaths == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(2);
        }
        if (operation == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(3);
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, root, relativePaths, operation, description2, null, new NotificationAction[0]);
    }

    public static void notifyUntrackedFilesOverwrittenBy(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, @NotNull @Nls String operation, @Nullable @NlsContexts.DetailedDescription String description2, @Nullable NotificationListener listener2, NotificationAction ... actions2) {
        if (project == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(5);
        }
        if (relativePaths == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(6);
        }
        if (operation == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(7);
        }
        if (actions2 == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(8);
        }
        Notification notification2 = GitUntrackedFilesHelper.getUntrackedFilesOverwrittenByNotification(project, root, relativePaths, operation, description2, listener2);
        for (NotificationAction action : actions2) {
            notification2.addAction((AnAction)action);
        }
        VcsNotifier.getInstance((Project)project).notify(notification2);
    }

    public static boolean showUntrackedFilesDialogWithRollback(@NotNull Project project, @NotNull @Nls String operationName, @NotNull @NlsContexts.Label String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (project == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(9);
        }
        if (operationName == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(10);
        }
        if (rollbackProposal == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(11);
        }
        if (root == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(12);
        }
        if (relativePaths == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(13);
        }
        Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, absolutePath -> GitUtil.findRefreshFileOrLog(absolutePath));
        Ref rollback = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            JComponent filesBrowser;
            if (untrackedFiles.isEmpty()) {
                LOG.debug("Couldn't find the untracked files, displaying simplified dialog.");
                filesBrowser = new GitSimplePathsBrowser(project, absolutePaths);
            } else {
                long validFiles = untrackedFiles.stream().filter(VirtualFile::isValid).count();
                LOG.debug(String.format("Untracked files: [%s]. Valid: %d (of %d)", untrackedFiles, validFiles, untrackedFiles.size()));
                filesBrowser = ScrollPaneFactory.createScrollPane((Component)new SelectFilesDialog.VirtualFileList(project, false, true, untrackedFiles));
            }
            String title = GitBundle.message("dialog.title.could.not.operation", StringUtil.capitalize((String)operationName));
            String description2 = GitBundle.message("dialog.message.untracked.files.will.be.overwritten.by.operation", operationName);
            UntrackedFilesRollBackDialog dialog2 = new UntrackedFilesRollBackDialog(project, filesBrowser, description2, rollbackProposal);
            dialog2.setTitle(title);
            DialogManager.show(dialog2);
            rollback.set((Object)dialog2.isOK());
        });
        return (Boolean)rollback.get();
    }

    @NotNull
    private static Notification getUntrackedFilesOverwrittenByNotification(final @NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, final @NotNull @Nls String operation, @Nullable @NlsContexts.DetailedDescription String description2, @Nullable NotificationListener listener2) {
        if (project == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(15);
        }
        if (relativePaths == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(16);
        }
        if (operation == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(17);
        }
        if (description2 == null) {
            description2 = "";
        }
        String notificationTitle = GitBundle.message("notification.title.untracked.files.prevent.operation", StringUtil.capitalize((String)operation));
        String notificationDesc = GitBundle.message("notification.content.untracked.files.prevent.operation.move.or.commit", operation, description2);
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        final List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, absolutePath -> GitUtil.findRefreshFileOrLog(absolutePath));
        Notification notification2 = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(notificationTitle, notificationDesc, NotificationType.ERROR).setDisplayId("untracked.files.overwritten");
        if (listener2 != null) {
            notification2.setListener(listener2);
        }
        notification2.addAction((AnAction)new NotificationAction(VcsBundle.messagePointer((String)"action.NotificationAction.VFSListener.text.view.files", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                String dialogDesc = GitBundle.message("dialog.message.untracked.files.will.be.overwritten.by.operation", operation);
                String title = GitBundle.message("dialog.title.untracked.files.preventing.operation", StringUtil.capitalize((String)operation));
                if (untrackedFiles.isEmpty()) {
                    GitUtil.showPathsInDialog(project, absolutePaths, title, dialogDesc);
                } else {
                    UntrackedFilesDialog dialog2 = new UntrackedFilesDialog(project, untrackedFiles, dialogDesc);
                    dialog2.setTitle(title);
                    dialog2.show();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "git4idea/util/GitUntrackedFilesHelper$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Notification notification3 = notification2;
        if (notification3 == null) {
            GitUntrackedFilesHelper.$$$reportNull$$$0(18);
        }
        return notification3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 6: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 3: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rollbackProposal";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitUntrackedFilesHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitUntrackedFilesHelper";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUntrackedFilesOverwrittenByNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notifyUntrackedFilesOverwrittenBy";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesDialogWithRollback";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUntrackedFilesOverwrittenByNotification";
                break;
            }
            case 18: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }

    private static class UntrackedFilesRollBackDialog
    extends DialogWrapper {
        @NotNull
        private final JComponent myFilesBrowser;
        @NotNull
        private final @NlsContexts.Label String myPrompt;
        @NotNull
        private final @NlsContexts.Label String myRollbackProposal;

        UntrackedFilesRollBackDialog(@NotNull Project project, @NotNull JComponent filesBrowser, @NotNull @NlsContexts.Label String prompt, @NotNull @NlsContexts.Label String rollbackProposal) {
            if (project == null) {
                UntrackedFilesRollBackDialog.$$$reportNull$$$0(0);
            }
            if (filesBrowser == null) {
                UntrackedFilesRollBackDialog.$$$reportNull$$$0(1);
            }
            if (prompt == null) {
                UntrackedFilesRollBackDialog.$$$reportNull$$$0(2);
            }
            if (rollbackProposal == null) {
                UntrackedFilesRollBackDialog.$$$reportNull$$$0(3);
            }
            super(project);
            this.myFilesBrowser = filesBrowser;
            this.myPrompt = prompt;
            this.myRollbackProposal = rollbackProposal;
            this.setOKButtonText(GitBundle.message("button.rollback", new Object[0]));
            this.setCancelButtonText(GitBundle.message("button.don.t.rollback", new Object[0]));
            this.init();
        }

        protected JComponent createSouthPanel() {
            JComponent buttons = super.createSouthPanel();
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
            panel2.add((Component)new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.myRollbackProposal)));
            if (buttons != null) {
                panel2.add(buttons);
            }
            return panel2;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myFilesBrowser;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            JLabel label = new JLabel(this.myPrompt);
            label.setUI((LabelUI)new MultiLineLabelUI());
            label.setBorder(new EmptyBorder(5, 1, 5, 1));
            return label;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filesBrowser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prompt";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rollbackProposal";
                    break;
                }
            }
            objectArray[1] = "git4idea/util/GitUntrackedFilesHelper$UntrackedFilesRollBackDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UntrackedFilesDialog
    extends SelectFilesDialog {
        UntrackedFilesDialog(Project project, @NotNull Collection<? extends VirtualFile> untrackedFiles, @NotNull @NlsContexts.Label String dialogDesc) {
            if (untrackedFiles == null) {
                UntrackedFilesDialog.$$$reportNull$$$0(0);
            }
            if (dialogDesc == null) {
                UntrackedFilesDialog.$$$reportNull$$$0(1);
            }
            super(project, new ArrayList<VirtualFile>(untrackedFiles), StringUtil.stripHtml((String)dialogDesc, (boolean)true), null, false, true);
            this.init();
        }

        protected Action @NotNull [] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                UntrackedFilesDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "untrackedFiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialogDesc";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/util/GitUntrackedFilesHelper$UntrackedFilesDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/util/GitUntrackedFilesHelper$UntrackedFilesDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

