/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.GroupingKey;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import git4idea.GitLocalBranch;
import git4idea.branch.GitBranchType;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchesDashboardUtil;
import git4idea.ui.branch.dashboard.NodeDescriptorsModel;
import git4idea.ui.branch.dashboard.NodeType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J6\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00102\u001c\b\u0002\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u000bJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\f\u001a\u00020\u0003J$\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J(\u0010\u0019\u001a\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001f2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bJ\u0014\u0010 \u001a\u00020\u001d*\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020\u001d*\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R6\u0010\u0006\u001a*\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\u0007j\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lgit4idea/ui/branch/dashboard/NodeDescriptorsModel;", "", "localRootNodeDescriptor", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "remoteRootNodeDescriptor", "(Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;)V", "branchNodeDescriptors", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "addChild", "", "parent", "child", "applyGroupingByDirectory", "branch", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "applyGroupingByRepository", "curParent", "br", "additionalGrouping", "Lkotlin/Function2;", "clear", "getChildrenForParent", "", "populateFrom", "groupingConfig", "", "Lcom/intellij/dvcs/branch/GroupingKey;", "", "branches", "Lkotlin/sequences/Sequence;", "isCurrentBranch", "Lgit4idea/repo/GitRepository;", "branchName", "", "isFavorite", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesTreeModel.kt\ngit4idea/ui/branch/dashboard/NodeDescriptorsModel\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,184:1\n1313#2,2:185\n1855#3,2:187\n30#4,3:189\n*S KotlinDebug\n*F\n+ 1 BranchesTreeModel.kt\ngit4idea/ui/branch/dashboard/NodeDescriptorsModel\n*L\n113#1:185,2\n136#1:187,2\n181#1:189,3\n*E\n"})
public final class NodeDescriptorsModel {
    @NotNull
    private final BranchNodeDescriptor localRootNodeDescriptor;
    @NotNull
    private final BranchNodeDescriptor remoteRootNodeDescriptor;
    @NotNull
    private final HashMap<BranchNodeDescriptor, Set<BranchNodeDescriptor>> branchNodeDescriptors;

    public NodeDescriptorsModel(@NotNull BranchNodeDescriptor localRootNodeDescriptor, @NotNull BranchNodeDescriptor remoteRootNodeDescriptor) {
        Intrinsics.checkNotNullParameter((Object)localRootNodeDescriptor, (String)"localRootNodeDescriptor");
        Intrinsics.checkNotNullParameter((Object)remoteRootNodeDescriptor, (String)"remoteRootNodeDescriptor");
        this.localRootNodeDescriptor = localRootNodeDescriptor;
        this.remoteRootNodeDescriptor = remoteRootNodeDescriptor;
        this.branchNodeDescriptors = new HashMap();
    }

    public final void clear() {
        this.branchNodeDescriptors.clear();
    }

    @NotNull
    public final Set<BranchNodeDescriptor> getChildrenForParent(@NotNull BranchNodeDescriptor parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return ((Map)this.branchNodeDescriptors).getOrDefault(parent, SetsKt.emptySet());
    }

    public final void populateFrom(@NotNull Sequence<BranchInfo> branches2, @NotNull Map<GroupingKey, Boolean> groupingConfig) {
        Intrinsics.checkNotNullParameter(branches2, (String)"branches");
        Intrinsics.checkNotNullParameter(groupingConfig, (String)"groupingConfig");
        Sequence<BranchInfo> $this$forEach$iv = branches2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BranchInfo branch = (BranchInfo)element$iv;
            boolean bl = false;
            this.populateFrom(branch, groupingConfig);
        }
    }

    private final void populateFrom(BranchInfo br, Map<GroupingKey, Boolean> groupingConfig) {
        BranchNodeDescriptor curParent = br.isLocal() ? this.localRootNodeDescriptor : this.remoteRootNodeDescriptor;
        Boolean bl = groupingConfig.get(GroupingKey.GROUPING_BY_DIRECTORY);
        Intrinsics.checkNotNull((Object)bl);
        boolean groupByDirectory = bl;
        Boolean bl2 = groupingConfig.get(GroupingKey.GROUPING_BY_REPOSITORY);
        Intrinsics.checkNotNull((Object)bl2);
        boolean groupByRepository = bl2;
        if (groupByRepository && groupByDirectory) {
            this.applyGroupingByRepository(curParent, br, (Function2<? super BranchInfo, ? super BranchNodeDescriptor, Unit>)((Function2)new Function2<BranchInfo, BranchNodeDescriptor, Unit>(this){
                final /* synthetic */ NodeDescriptorsModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull BranchInfo branch, @NotNull BranchNodeDescriptor parent) {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                    NodeDescriptorsModel.access$applyGroupingByDirectory(this.this$0, parent, branch);
                }
            }));
        } else if (groupByRepository) {
            NodeDescriptorsModel.applyGroupingByRepository$default(this, curParent, br, null, 4, null);
        } else if (groupByDirectory) {
            this.applyGroupingByDirectory(curParent, BranchInfo.copy$default(br, null, false, false, false, null, null, 63, null));
        } else {
            this.addChild(curParent, new BranchNodeDescriptor(NodeType.BRANCH, BranchInfo.copy$default(br, null, false, false, false, null, null, 63, null), null, null, curParent, 12, null));
        }
    }

    private final void applyGroupingByRepository(BranchNodeDescriptor curParent, BranchInfo br, Function2<? super BranchInfo, ? super BranchNodeDescriptor, Unit> additionalGrouping) {
        HashMap<Object, BranchNodeDescriptor> repositoryNodeDescriptors = new HashMap<Object, BranchNodeDescriptor>();
        Iterable $this$forEach$iv = br.getRepositories();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BranchNodeDescriptor repositoryNodeDescriptor2;
            GitRepository repository = (GitRepository)element$iv;
            boolean bl = false;
            BranchInfo branch = BranchInfo.copy$default(br, null, false, this.isCurrentBranch(repository, br.getBranchName()), this.isFavorite(repository, br), BranchesDashboardUtil.INSTANCE.getIncomingOutgoingState(repository, br.getBranchName()), null, 35, null);
            Intrinsics.checkNotNullExpressionValue((Object)repositoryNodeDescriptors.computeIfAbsent(repository, arg_0 -> NodeDescriptorsModel.applyGroupingByRepository$lambda$2$lambda$1((Function1)new Function1<GitRepository, BranchNodeDescriptor>(repository, curParent, this){
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ BranchNodeDescriptor $curParent;
                final /* synthetic */ NodeDescriptorsModel this$0;
                {
                    this.$repository = $repository;
                    this.$curParent = $curParent;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final BranchNodeDescriptor invoke(@NotNull GitRepository it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    BranchNodeDescriptor repositoryNodeDescriptor2 = new BranchNodeDescriptor(NodeType.GROUP_REPOSITORY_NODE, null, this.$repository, null, this.$curParent, 10, null);
                    NodeDescriptorsModel.access$addChild(this.this$0, this.$curParent, repositoryNodeDescriptor2);
                    return repositoryNodeDescriptor2;
                }
            }, arg_0)), (String)"computeIfAbsent(...)");
            if (additionalGrouping != null) {
                additionalGrouping.invoke((Object)branch, (Object)repositoryNodeDescriptor2);
                continue;
            }
            BranchNodeDescriptor branchNodeDescriptor = new BranchNodeDescriptor(NodeType.BRANCH, branch, null, null, repositoryNodeDescriptor2, 12, null);
            this.addChild(repositoryNodeDescriptor2, branchNodeDescriptor);
        }
    }

    static /* synthetic */ void applyGroupingByRepository$default(NodeDescriptorsModel nodeDescriptorsModel, BranchNodeDescriptor branchNodeDescriptor, BranchInfo branchInfo, Function2 function2, int n, Object object) {
        if ((n & 4) != 0) {
            function2 = null;
        }
        nodeDescriptorsModel.applyGroupingByRepository(branchNodeDescriptor, branchInfo, (Function2<? super BranchInfo, ? super BranchNodeDescriptor, Unit>)function2);
    }

    private final void applyGroupingByDirectory(BranchNodeDescriptor parent, BranchInfo branch) {
        String[] stringArray = new String[]{"/"};
        Iterator iter = StringsKt.split$default((CharSequence)branch.getBranchName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).iterator();
        BranchNodeDescriptor curParent = parent;
        while (iter.hasNext()) {
            String branchNamePart = (String)iter.next();
            boolean groupNode = iter.hasNext();
            NodeType nodeType = groupNode ? NodeType.GROUP_NODE : NodeType.BRANCH;
            BranchInfo branchInfo = nodeType == NodeType.BRANCH ? branch : null;
            BranchNodeDescriptor branchNodeDescriptor = new BranchNodeDescriptor(nodeType, branchInfo, null, branchNamePart, curParent, 4, null);
            this.addChild(curParent, branchNodeDescriptor);
            curParent = branchNodeDescriptor;
        }
    }

    private final void addChild(BranchNodeDescriptor parent, BranchNodeDescriptor child) {
        Set set = this.branchNodeDescriptors.computeIfAbsent(parent, arg_0 -> NodeDescriptorsModel.addChild$lambda$3(addChild.directChildren.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        Set directChildren2 = set;
        directChildren2.add(child);
        ((Map)this.branchNodeDescriptors).put(parent, directChildren2);
    }

    private final boolean isCurrentBranch(GitRepository $this$isCurrentBranch, String branchName) {
        GitLocalBranch gitLocalBranch = $this$isCurrentBranch.getCurrentBranch();
        return Intrinsics.areEqual((Object)(gitLocalBranch != null ? gitLocalBranch.getName() : null), (Object)branchName);
    }

    private final boolean isFavorite(GitRepository $this$isFavorite, BranchInfo branch) {
        Project project = $this$isFavorite.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitBranchManager> serviceClass$iv = GitBranchManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return ((GitBranchManager)((Object)object)).isFavorite(branch.isLocal() ? GitBranchType.LOCAL : GitBranchType.REMOTE, $this$isFavorite, branch.getBranchName());
    }

    private static final BranchNodeDescriptor applyGroupingByRepository$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (BranchNodeDescriptor)$tmp0.invoke(p0);
    }

    private static final Set addChild$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$applyGroupingByDirectory(NodeDescriptorsModel $this, BranchNodeDescriptor parent, BranchInfo branch) {
        $this.applyGroupingByDirectory(parent, branch);
    }

    public static final /* synthetic */ void access$addChild(NodeDescriptorsModel $this, BranchNodeDescriptor parent, BranchNodeDescriptor child) {
        $this.addChild(parent, child);
    }
}

